/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.widget;

import net.minecraft.client.gui.Gui;

public class ColourPickerWidget {
    private int x;
    private int y;
    private int width;
    private int height;
    private int currentColour;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;

    public ColourPickerWidget(int x, int y, int width, int height, int initialColour) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setColour(initialColour);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        for (int px = 0; px < this.width; ++px) {
            float s = (float)px / (float)Math.max(1, this.width - 1);
            for (int py = 0; py < this.height; ++py) {
                float b = 1.0f - (float)py / (float)Math.max(1, this.height - 1);
                int col = this.hsvToRgb(this.hue * 360.0f, s, b);
                Gui.func_73734_a((int)(this.x + px), (int)(this.y + py), (int)(this.x + px + 1), (int)(this.y + py + 1), (int)(0xFF000000 | col & 0xFFFFFF));
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            float s = (float)(mouseX - (double)this.x) / (float)Math.max(1, this.width - 1);
            float b = 1.0f - (float)(mouseY - (double)this.y) / (float)Math.max(1, this.height - 1);
            this.saturation = ColourPickerWidget.clamp01(s);
            this.brightness = ColourPickerWidget.clamp01(b);
            this.updateColour();
            return true;
        }
        return false;
    }

    private void updateColour() {
        int rgb = this.hsvToRgb(this.hue * 360.0f, this.saturation, this.brightness);
        this.currentColour = 0xFF000000 | rgb & 0xFFFFFF;
    }

    private int hsvToRgb(float h, float s, float v) {
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        float rf = 0.0f;
        float gf = 0.0f;
        float bf = 0.0f;
        if (h < 60.0f) {
            rf = c;
            gf = x;
            bf = 0.0f;
        } else if (h < 120.0f) {
            rf = x;
            gf = c;
            bf = 0.0f;
        } else if (h < 180.0f) {
            rf = 0.0f;
            gf = c;
            bf = x;
        } else if (h < 240.0f) {
            rf = 0.0f;
            gf = x;
            bf = c;
        } else if (h < 300.0f) {
            rf = x;
            gf = 0.0f;
            bf = c;
        } else {
            rf = c;
            gf = 0.0f;
            bf = x;
        }
        int r = Math.round((rf + m) * 255.0f);
        int g = Math.round((gf + m) * 255.0f);
        int b = Math.round((bf + m) * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public int getColour() {
        return this.currentColour;
    }

    public void setColour(int colour) {
        this.currentColour = colour;
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        float[] hsv = this.rgbToHsv(r, g, b);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.brightness = hsv[2];
    }

    private float[] rgbToHsv(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float d = max - min;
        float h = 0.0f;
        h = d == 0.0f ? 0.0f : (max == rf ? (gf - bf) / d % 6.0f : (max == gf ? (bf - rf) / d + 2.0f : (rf - gf) / d + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = max == 0.0f ? 0.0f : d / max;
        float v = max;
        return new float[]{h, s, v};
    }

    private static float clamp01(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }
}

