/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenshears;

import de.cech12.woodenshears.CommonLoader;
import de.cech12.woodenshears.Constants;
import de.cech12.woodenshears.item.WoodenShearsItem;
import java.util.function.Function;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="woodenshears")
@Mod.EventBusSubscriber(modid="woodenshears", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeWoodenShearsMod {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"woodenshears");

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> itemConstructor) {
        return ITEMS.register(name, () -> (Item)itemConstructor.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.id(name)))));
    }

    public ForgeWoodenShearsMod(FMLJavaModLoadingContext context) {
        ITEMS.register(context.getModBusGroup());
        CommonLoader.init();
    }

    @SubscribeEvent
    public static void registerDispenseBehavior(FMLCommonSetupEvent event) {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)Constants.WOODEN_SHEARS.get()), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(Constants.WOODEN_SHEARS);
        }
    }

    static {
        Constants.WOODEN_SHEARS = ForgeWoodenShearsMod.registerItem("wooden_shears", WoodenShearsItem::new);
    }
}

