/*
 * Decompiled with CFR 0.152.
 */
package org.stellium.ignoring.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;

@Config(name="ignoring")
public class IgnoringConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.TransitiveObject
    public boolean ignoreChat = false;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.TransitiveObject
    public boolean ignoreRender = false;
    @ConfigEntry.Gui.Tooltip
    public List<String> ignoredPlayerList = new ArrayList<String>();

    public IgnoringConfig() {
        if (this.ignoredPlayerList.isEmpty()) {
            this.ignoredPlayerList.add("Insert name");
        }
    }

    static void validate(IgnoringConfig config) {
        if (config.ignoredPlayerList != null) {
            config.ignoredPlayerList.removeIf(name -> name == null || name.isBlank());
        }
    }

    public static void init() {
        AutoConfig.register(IgnoringConfig.class, GsonConfigSerializer::new);
    }

    public static IgnoringConfig get() {
        IgnoringConfig config = (IgnoringConfig)AutoConfig.getConfigHolder(IgnoringConfig.class).getConfig();
        IgnoringConfig.validate(config);
        return config;
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        IgnoringConfig.validate(this);
    }
}

