/*
 * Decompiled with CFR 0.152.
 */
package org.stellium.ignoring.render;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.stellium.ignoring.config.IgnoringConfig;
import org.stellium.ignoring.util.ArgbUtils;

public class TransparencyManager {
    public static int getTranslucentArgb(class_1297 entity, int original) {
        if (!IgnoringConfig.get().ignoreRender) {
            return original;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_243 entityPos = entity.method_19538();
        if (player == null || world == null) {
            return original;
        }
        if (player.equals((Object)entity)) {
            return TransparencyManager.getColorForYourself(original);
        }
        if (entity.method_5756((class_1657)player)) {
            return original;
        }
        return ArgbUtils.swapAlpha(original, TransparencyManager.getAlpha(cameraPos, entityPos));
    }

    private static int getAlpha(class_243 cameraPos, class_243 entityPos) {
        float hidingActivationDistance = 4.0f;
        float fullHidingDistance = 2.8f;
        float minHidingValue = 0.2f;
        float distance = TransparencyManager.calculateDistance(cameraPos, entityPos);
        if (hidingActivationDistance <= 0.0f) {
            return 255;
        }
        float a = hidingActivationDistance - fullHidingDistance;
        float b = distance - fullHidingDistance;
        if (a <= 0.0f || b <= 0.0f) {
            return (int)(minHidingValue * 255.0f);
        }
        if (b >= a) {
            return 255;
        }
        return (int)(class_3532.method_15363((float)(minHidingValue + (1.0f - minHidingValue) * (b / a)), (float)0.0f, (float)1.0f) * 255.0f);
    }

    private static int getColorForYourself(int original) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return ArgbUtils.swapAlpha(original, 51);
        }
        return original;
    }

    public static float calculateDistance(class_243 cameraPos, class_243 entityPos) {
        float f = (float)(cameraPos.method_10216() - entityPos.method_10216());
        float g = (float)(cameraPos.method_10214() - entityPos.method_10214());
        float h = (float)(cameraPos.method_10215() - entityPos.method_10215());
        return class_3532.method_15355((float)(f * f + g * g + h * h));
    }

    public static boolean canRenderTransparencyShadow(class_1297 entity) {
        IgnoringConfig config = IgnoringConfig.get();
        return config.ignoredPlayerList.contains(entity.method_5476().getString()) && config.ignoreRender;
    }
}

