package dev.rvbsm.fsit.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import dev.rvbsm.fsit.client.option.HybridKeyBinding;
import net.minecraft.class_304;

@Mixin(class_304.class)
public abstract class KeyBindingMixin {

    @ModifyVariable(method = "untoggleStickyKeys", at = @At("STORE"))
    private static class_304 untoggleHybridKey(class_304 keyBinding) {
        if (keyBinding instanceof HybridKeyBinding hybridKeyBinding) {
            hybridKeyBinding.untoggle();
        }

        return keyBinding;
    }
}
