package dev.rvbsm.fsit.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import dev.rvbsm.fsit.FSitMod;
import dev.rvbsm.fsit.client.FSitModClient;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5519;
import net.minecraft.class_5520;
import net.minecraft.class_7919;

@Mixin(class_5519.class)
public abstract class SocialInteractionsPlayerListEntryMixin extends class_4265.class_4266<class_5519> {

    //? if <=1.20.1 {
    /*@Unique
    private static final net.minecraft.util.Identifier RESTRICT_TEXTURE = FSitMod.id("textures/gui/restrict_button.png");
    *///?} else if >=1.20.2 {
    @Unique
    private static final net.minecraft.class_8666 RESTRICT_TEXTURE = new net.minecraft.class_8666(FSitMod.id("social_interactions/restrict_button"), FSitMod.id("social_interactions/restrict_button_disabled"), FSitMod.id("social_interactions/restrict_button_highlighted"));
    @Unique
    private static final net.minecraft.class_8666 ALLOW_TEXTURE = new net.minecraft.class_8666(FSitMod.id("social_interactions/allow_button"), FSitMod.id("social_interactions/allow_button_disabled"), FSitMod.id("social_interactions/allow_button_highlighted"));
    //?}
    @Unique
    private static final class_2561 RESTRICT_BUTTON = FSitMod.translatable("gui", "socialInteractions.restrict");
    @Unique
    private static final class_2561 ALLOW_BUTTON = FSitMod.translatable("gui", "socialInteractions.allow");
    @Unique
    private static final class_2561 DISABLED_BUTTON = FSitMod.translatable("gui", "socialInteractions.disabled");

    @Shadow
    private @Final List<class_339> buttons;
    @Shadow
    private @Final UUID uuid;
    @Unique
    private class_4185 restrictButton;
    @Unique
    private class_4185 allowButton;

    @Inject(
        method = "<init>",
        at = @At(
            value = "INVOKE",
            target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
            shift = At.Shift.AFTER,
            ordinal = 1))
    protected void restrictButtons(CallbackInfo ci, @Local class_5520 socialInteractionsManager) {
        if (FSitModClient.INSTANCE.isServerFSitCompatible()) {
            //? if <=1.20.1 {
            /*this.restrictButton = new TexturedButtonWidget(0, 0, 20, 20, 0, 0, 20, RESTRICT_TEXTURE, this::restrict);
            this.allowButton = new TexturedButtonWidget(0, 0, 20, 20, 20, 0, 20, RESTRICT_TEXTURE, this::allow);
            *///?} else if >=1.20.2 {
            this.restrictButton = new class_344(20, 20, RESTRICT_TEXTURE, this::restrict, RESTRICT_BUTTON);
            this.allowButton = new class_344(20, 20, ALLOW_TEXTURE, this::allow, ALLOW_BUTTON);
            //?}

            final boolean isHidden = socialInteractionsManager.method_31340(uuid);

            this.restrictButton.field_22763 = !isHidden && FSitMod.getConfig().getOnUse().getRiding();
            this.restrictButton.method_47400(class_7919.method_47407(this.restrictButton.field_22763 ? RESTRICT_BUTTON : DISABLED_BUTTON));

            this.allowButton.field_22763 = !isHidden && FSitMod.getConfig().getOnUse().getRiding();
            this.allowButton.method_47400(class_7919.method_47407(this.allowButton.field_22763 ? ALLOW_BUTTON : DISABLED_BUTTON));

            buttons.add(this.restrictButton);
            updateButtons(FSitModClient.isRestricted(uuid));
        }
    }

    @Inject(method = "render", at = @At("TAIL"))
    public void renderRestrictButtons(
        class_332 context,
        int index,
        int y,
        int x,
        int entryWidth,
        int entryHeight,
        int mouseX,
        int mouseY,
        boolean hovered,
        float tickDelta,
        CallbackInfo ci
    ) {
        if (this.restrictButton != null && this.allowButton != null) {
            final int offset = 24 * (buttons.size() - 1);

            this.restrictButton.method_46421(x + (entryWidth - this.restrictButton.method_25368() - 4) - offset);
            this.restrictButton.method_46419(y + (entryHeight - this.restrictButton.method_25364()) / 2);
            this.restrictButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.allowButton.method_46421(x + (entryWidth - this.allowButton.method_25368() - 4) - offset);
            this.allowButton.method_46419(y + (entryHeight - this.allowButton.method_25364()) / 2);
            this.allowButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    @Inject(method = "setShowButtonVisible", at = @At("TAIL"))
    private void setRestrictionButtonVisible(boolean showButtonVisible, CallbackInfo ci) {
        if (FSitModClient.INSTANCE.isServerFSitCompatible()) {
            this.restrictButton.field_22763 = !showButtonVisible;
            this.allowButton.field_22763 = !showButtonVisible;
        }
    }

    @Unique
    private void updateButtons(boolean isRestricted) {
        this.restrictButton.field_22764 = !isRestricted;
        this.allowButton.field_22764 = isRestricted;
        this.buttons.set(2, isRestricted ? this.allowButton : this.restrictButton);
    }

    @Unique
    private void restrict(class_4185 button) {
        FSitModClient.restrictInteractionsFor(uuid);
        this.updateButtons(true);
    }

    @Unique
    private void allow(class_4185 button) {
        FSitModClient.allowInteractionsFor(uuid);
        this.updateButtons(false);
    }
}
