package dev.rvbsm.fsit.client.option

import net.minecraft.text.Text

interface TranslatableOption {
    val translationKey: String
    val text: Text get() = Text.translatable(translationKey)
}

enum class KeyBindingMode(override val translationKey: String) : TranslatableOption {
    Toggle("options.key.toggle"), Hold("options.key.hold"), Hybrid("option.fsit.key.hybrid");
}
