package dev.rvbsm.fsit.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import dev.rvbsm.fsit.entity.ModPose;

@FunctionalInterface
public interface UpdatePoseCallback {

    Event<UpdatePoseCallback> EVENT = EventFactory.createArrayBacked(
        UpdatePoseCallback.class, (listeners) -> (player, pose, pos) -> {
            for (UpdatePoseCallback listener : listeners) {
                listener.update(player, pose, pos);
            }
        });

    void update(@NotNull class_3222 player, @NotNull ModPose pose, @Nullable class_243 pos);
}
