package dev.rvbsm.fsit.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import dev.rvbsm.fsit.api.event.PassedUseBlockCallback;
import dev.rvbsm.fsit.api.event.PassedUseEntityCallback;
import dev.rvbsm.fsit.api.network.RidingRequestHandler;
import dev.rvbsm.fsit.api.player.PlayerConfig;
import dev.rvbsm.fsit.api.player.PlayerLastSneakTime;
import dev.rvbsm.fsit.api.player.PlayerPose;
import dev.rvbsm.fsit.entity.ModPose;
import dev.rvbsm.fsit.networking.payload.RidingResponseC2SPayload;

import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin implements RidingRequestHandler {

    @Unique
    private final Map<UUID, CompletableFuture<Boolean>> pendingRidingRequests = new WeakHashMap<>();
    @Shadow
    public class_3222 player;

    //? if <=1.21.5 {
    /*@Inject(method = "onClientCommand", at = @At("TAIL"))
    public void onClientCommand(net.minecraft.network.packet.c2s.play.ClientCommandC2SPacket packet, CallbackInfo ci) {
        dev.rvbsm.fsit.api.event.ClientCommandCallback.EVENT.invoker().process(this.player, packet.getMode());
    }
    *///?}

    // just a copy-paste from SneakListener
    //? if >=1.21.6 {
    @Unique
    private boolean prevSneaking = false;

    @ModifyArg(
        method = "onPlayerInput",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;setSneaking(Z)V"))
    public boolean onPlayerInput(boolean sneaking) {
        if (!this.prevSneaking && sneaking && this.updateSneaking()) {
            this.prevSneaking = false;
            return false;
        }
        this.prevSneaking = sneaking;

        return sneaking;
    }

    @Unique
    private boolean updateSneaking() {
        if (player.method_31483() instanceof dev.rvbsm.fsit.entity.RideEntity) {
            player.method_5772();
            return false;
        }

        final var playerSneak = (PlayerLastSneakTime) this.player;
        final var sneakConfig = ((PlayerConfig) this.player).fsit$getConfig().getOnSneak();
        if (!sneakConfig.getSitting() && !sneakConfig.getCrawling()) {
            return false;
        } else if (this.player.method_36455() < sneakConfig.getMinPitch()) {
            return false;
        }

        if (this.player.method_5765() || !this.player.method_24828()) {
            return false;
        }

        if (class_156.method_658() - playerSneak.fsit$getLastSneakTime() <= sneakConfig.getDelay()) {
            final ModPose modPose;
            if (sneakConfig.getCrawling() && this.isPlayerNearGap()) {
                modPose = ModPose.Crawling;
            } else if (sneakConfig.getSitting()) {
                modPose = ModPose.Sitting;
            } else {
                return false;
            }

            playerSneak.fsit$resetLastSneakTime();
            //? if >=1.21.9 {
            ((PlayerPose) this.player).fsit$setPose(modPose, this.player.method_73189());
            //?} else
            /*((PlayerPose) this.player).fsit$setPose(modPose, this.player.getPos());*/
            return true;
        }

        playerSneak.fsit$updateLastSneakTime();
        return false;
    }

    @Unique
    private boolean isPlayerNearGap() {
        final class_4048 crawlingDimensions = this.player.method_18377(class_4050.field_18079);
        final class_4048 crouchingDimensions = this.player.method_18377(class_4050.field_18081);

        final double yawRadians = this.player.method_36454() / 180 * Math.PI;
        final double offsetX = -Math.sin(yawRadians) * 0.1;
        final double offsetZ = Math.cos(yawRadians) * 0.1;

        //? if >=1.21.9 {
        final class_243 playerPos = this.player.method_73189();
        //?} else
        /*final Vec3d playerPos = this.player.getPos();*/
        final class_243 expectEmptyAt = playerPos.method_1031(offsetX, 0.0, offsetZ);
        final class_243 expectFullAt = playerPos.method_1031(offsetX, crouchingDimensions.comp_2186(), offsetZ);

        //? if >=1.21.9 {
        final class_1937 world = this.player.method_51469();
        //?} else
        /*final World world = this.player.getWorld();*/
        return world.method_8587(this.player, crawlingDimensions.method_30757(expectEmptyAt).method_1011(1.0e-6)) &&
            !world.method_8587(this.player, crawlingDimensions.method_30757(expectFullAt).method_1011(1.0e-6));
    }
    //?}

    @ModifyVariable(method = "onPlayerInteractBlock", at = @At("STORE"))
    private class_1269 interactBlock(
        class_1269 interactionActionResult,
        @Local class_3218 world,
        @Local LocalRef<class_1268> handRef,
        @Local class_1799 itemStack,
        @Local class_3965 blockHitResult
    ) {
        if (interactionActionResult != class_1269.field_5811 || itemStack.method_7976().ordinal() != 0) {
            return interactionActionResult;
        }

        switch (handRef.get()) {
            case field_5808 -> {
                if (!this.player.method_6079().method_7960()) {
                    return interactionActionResult;
                }
            }

            case field_5810 -> {
                handRef.set(class_1268.field_5808);
            }
        }

        return PassedUseBlockCallback.EVENT.invoker().interact(player, world, blockHitResult);
    }

    @Inject(method = "onDisconnected", at = @At("TAIL"))
    public void purgePendingRequests(CallbackInfo ci) {
        this.pendingRidingRequests.forEach((uuid, future) -> future.complete(false));
        this.pendingRidingRequests.clear();
    }

    @Override
    public @NotNull CompletableFuture<Boolean> fsit$newRidingRequest(
        @NotNull UUID playerUUID,
        @NotNull Duration timeout
    ) {
        final CompletableFuture<Boolean> pendingFuture = this.pendingRidingRequests.get(playerUUID);
        if (pendingFuture != null && !pendingFuture.isDone()) {
            return CompletableFuture.completedFuture(false);
        }

        final CompletableFuture<Boolean> ridingResponse = new CompletableFuture<Boolean>().completeOnTimeout(
            false,
            timeout.toMillis(),
            TimeUnit.MILLISECONDS);
        this.pendingRidingRequests.put(playerUUID, ridingResponse);

        return ridingResponse;
    }

    @Override
    public void fsit$completeRidingRequest(@NotNull RidingResponseC2SPayload response) {
        final CompletableFuture<Boolean> future = this.pendingRidingRequests.remove(response.getUuid());
        if (future != null && !future.isDone()) {
            future.complete(response.getResponse().isAccepted());
        }
    }

    @Mixin(targets = "net.minecraft.server.network.ServerPlayNetworkHandler$1")
    public abstract static class PlayerInteractEntityC2SPacketHandler {
        @Shadow
        @Final
        class_3244 field_28963;

        @Shadow
        @Final
        class_1297 field_28962;

        @Shadow
        @Final
        class_3218 field_39991;

        @ModifyVariable(method = "processInteract", at = @At("STORE"))
        private class_1269 interactPlayer(
            class_1269 interactionActionResult,
            @Local(argsOnly = true) LocalRef<class_1268> handRef
        ) {
            if (interactionActionResult == class_1269.field_5811 &&
                handRef.get() == class_1268.field_5810 &&
                field_28963.field_14140.method_5998(handRef.get()).method_7976().ordinal() == 0) {
                handRef.set(class_1268.field_5808);

                return PassedUseEntityCallback.EVENT.invoker().interact(field_28963.field_14140, field_39991, field_28962);
            }

            return interactionActionResult;
        }
    }
}
