/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.api;

import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.DumpSettings;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.FlowStyle;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.NonPrintableStyle;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.ScalarStyle;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.SpecVersion;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.emitter.Emitter;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.EmitterException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.nodes.Tag;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.schema.JsonSchema;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.schema.Schema;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.serializer.AnchorGenerator;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.serializer.NumberAnchorGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DumpSettingsBuilder {
    @NotNull
    private Map<Object, Object> customProperties = new LinkedHashMap();
    private boolean explicitStart;
    private boolean explicitEnd;
    @NotNull
    private NonPrintableStyle nonPrintableStyle = NonPrintableStyle.ESCAPE;
    @Nullable
    private Tag explicitRootTag;
    @NotNull
    private AnchorGenerator anchorGenerator = new NumberAnchorGenerator(0, 1, null);
    @Nullable
    private SpecVersion yamlDirective;
    @NotNull
    private Map<String, String> tagDirective = MapsKt.emptyMap();
    @NotNull
    private FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    @NotNull
    private ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    private boolean canonical;
    private boolean multiLineFlow;
    private boolean useUnicodeEncoding = true;
    private int indent = 2;
    private int indicatorIndent;
    private int width = 80;
    @NotNull
    private String bestLineBreak = "\n";
    private boolean splitLines = true;
    private int maxSimpleKeyLength = 128;
    private boolean indentWithIndicator;
    private boolean dumpComments;
    private boolean isDereferenceAliases;
    @NotNull
    private Schema schema = new JsonSchema(null, null, 3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DumpSettingsBuilder setIndent(int indent) {
        void var1_1;
        IntRange intRange = Emitter.VALID_INDENT_RANGE;
        int n = intRange.getFirst();
        if (!(indent <= intRange.getLast() ? n <= indent : false)) {
            throw new EmitterException("Indent must be at in range " + Emitter.VALID_INDENT_RANGE);
        }
        this.indent = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DumpSettingsBuilder setIndicatorIndent(int indicatorIndent) {
        void var1_1;
        IntRange intRange = Emitter.VALID_INDICATOR_INDENT_RANGE;
        int n = intRange.getFirst();
        if (!(indicatorIndent <= intRange.getLast() ? n <= indicatorIndent : false)) {
            throw new EmitterException("Indicator indent must be in range " + Emitter.VALID_INDICATOR_INDENT_RANGE);
        }
        this.indicatorIndent = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DumpSettingsBuilder setWidth(int width) {
        void var1_1;
        this.width = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DumpSettingsBuilder setIndentWithIndicator(boolean indentWithIndicator) {
        void var1_1;
        this.indentWithIndicator = var1_1;
        return this;
    }

    @NotNull
    public final DumpSettingsBuilder setDumpComments(boolean dumpComments) {
        this.dumpComments = true;
        return this;
    }

    @NotNull
    public final DumpSettings build() {
        return new DumpSettings(this.explicitStart, this.explicitEnd, this.explicitRootTag, this.anchorGenerator, this.yamlDirective, this.tagDirective, this.defaultFlowStyle, this.defaultScalarStyle, this.nonPrintableStyle, this.schema, this.canonical, this.multiLineFlow, this.useUnicodeEncoding, this.indent, this.indicatorIndent, this.width, this.bestLineBreak, this.splitLines, this.maxSimpleKeyLength, this.customProperties, this.indentWithIndicator, this.dumpComments, this.isDereferenceAliases);
    }
}

