/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.emitter;

import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.DumpSettings;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.StreamDataWriter;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentEventsCollector;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentLine;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentType;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.Anchor;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.CharConstants;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.ScalarStyle;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.SpecVersion;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.emitter.EmitterState;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.emitter.ScalarAnalysis;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.AliasEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.CollectionEndEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.CollectionStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.CommentEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.DocumentEndEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.DocumentStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.Event;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.MappingStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.NodeEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.ScalarEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.SequenceStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.StreamEndEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.StreamStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.EmitterException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.YamlEngineException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.CharSequenceExtensionsKt;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.nodes.Tag;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.StreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Emitter.kt\nit/krzeminski/snakeyaml/engine/kmp/emitter/Emitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1612:1\n295#2,2:1613\n*S KotlinDebug\n*F\n+ 1 Emitter.kt\nit/krzeminski/snakeyaml/engine/kmp/emitter/Emitter\n*L\n928#1:1613,2\n*E\n"})
public final class Emitter {
    @NotNull
    private final DumpSettings opts;
    @NotNull
    private final StreamDataWriter stream;
    @NotNull
    private final ArrayDeque<EmitterState> states;
    @NotNull
    private EmitterState state;
    @NotNull
    private final ArrayDeque<Event> events;
    @Nullable
    private Event event;
    @NotNull
    private final ArrayDeque<Integer> indents;
    @Nullable
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private final boolean canonical;
    private final boolean multiLineFlow;
    private final boolean allowUnicode;
    private final int bestIndent;
    private final int bestWidth;
    @NotNull
    private Map<String, String> tagPrefixes;
    @Nullable
    private Anchor preparedAnchor;
    @Nullable
    private String preparedTag;
    @Nullable
    private ScalarAnalysis analysis;
    @Nullable
    private ScalarStyle scalarStyle;
    @NotNull
    private final CommentEventsCollector blockCommentsCollector;
    @NotNull
    private final CommentEventsCollector inlineCommentsCollector;
    @NotNull
    private static final Map<Character, String> ESCAPE_REPLACEMENTS;
    @NotNull
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    @JvmField
    @NotNull
    public static final IntRange VALID_INDENT_RANGE;
    @JvmField
    @NotNull
    public static final IntRange VALID_INDICATOR_INDENT_RANGE;
    @NotNull
    private static final Regex HANDLE_FORMAT;

    /*
     * WARNING - void declaration
     */
    public Emitter(@NotNull DumpSettings opts, @NotNull StreamDataWriter stream) {
        void var2_4;
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.opts = intRange;
        this.stream = var2_4;
        this.states = new ArrayDeque(100);
        this.state = new ExpectStreamStart(this);
        this.events = new ArrayDeque(100);
        this.indents = new ArrayDeque(100);
        this.whitespace = true;
        this.indention = true;
        this.canonical = this.opts.isCanonical();
        this.multiLineFlow = this.opts.isMultiLineFlow();
        this.allowUnicode = this.opts.isUseUnicodeEncoding();
        intRange = VALID_INDENT_RANGE;
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = this.opts.indent;
        this.bestIndent = (n <= n3 ? n3 <= n2 : false) ? this.opts.indent : 2;
        this.bestWidth = this.opts.width > this.bestIndent << 1 ? this.opts.width : 80;
        this.tagPrefixes = new LinkedHashMap();
        CommentType[] commentTypeArray = new CommentType[2];
        CommentType[] commentTypeArray2 = commentTypeArray;
        commentTypeArray[0] = CommentType.BLANK_LINE;
        commentTypeArray2[1] = CommentType.BLOCK;
        this.blockCommentsCollector = new CommentEventsCollector(this.events, commentTypeArray2);
        CommentType[] commentTypeArray3 = new CommentType[1];
        commentTypeArray2 = commentTypeArray3;
        commentTypeArray3[0] = CommentType.IN_LINE;
        this.inlineCommentsCollector = new CommentEventsCollector(this.events, commentTypeArray2);
    }

    public final void emit(@NotNull Event event) {
        Emitter emitter;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.events.add((Object)emitter);
        while (true) {
            boolean bl;
            block5: {
                emitter = this;
                if (emitter.events.isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = emitter.events.iterator();
                    Event event2 = (Event)iterator.next();
                    while (event2 instanceof CommentEvent) {
                        if (!iterator.hasNext()) {
                            bl = true;
                            break block5;
                        }
                        event2 = (Event)iterator.next();
                    }
                    bl = event2 instanceof DocumentStartEvent ? Emitter.needEvents(iterator, 1) : (event2 instanceof SequenceStartEvent ? Emitter.needEvents(iterator, 2) : (event2 instanceof MappingStartEvent ? Emitter.needEvents(iterator, 3) : (event2 instanceof StreamStartEvent ? Emitter.needEvents(iterator, 2) : (!(event2 instanceof StreamEndEvent) && emitter.opts.dumpComments ? Emitter.needEvents(iterator, 1) : false))));
                }
            }
            if (bl) break;
            this.event = (Event)this.events.removeFirst();
            this.state.expect();
            this.event = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean needEvents(Iterator<? extends Event> iter, int count) {
        void var1_1;
        void var3_3;
        Iterator<? extends Event> iterator;
        int level = 0;
        int actualCount = 0;
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event instanceof CommentEvent) continue;
            ++actualCount;
            Event event2 = event;
            if (event2 instanceof DocumentStartEvent || event2 instanceof CollectionStartEvent) {
                ++level;
            } else if (event2 instanceof DocumentEndEvent || event2 instanceof CollectionEndEvent) {
                --level;
            } else if (event2 instanceof StreamEndEvent) {
                level = -1;
            }
            if (level >= 0) continue;
            return false;
        }
        return var3_3 < var1_1;
    }

    static /* synthetic */ void increaseIndent$default$65bc426f(Emitter emitter, boolean bl, boolean bl2, int n) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        emitter.indents.addLast((Object)emitter.indent);
        if (emitter.indent == null) {
            emitter.indent = bl ? Integer.valueOf(emitter.bestIndent) : Integer.valueOf(0);
            return;
        }
        if (!bl2) {
            Integer n2 = emitter.indent;
            Intrinsics.checkNotNull((Object)n2);
            emitter.indent = n2 + emitter.bestIndent;
        }
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ void expectNode$default$52081599(Emitter var0, boolean var1_7, boolean var2_10, boolean var3_16, int var4_19) {
        if ((var4_19 & 1) != 0) {
            var1_7 = false;
        }
        if ((var4_19 & 2) != 0) {
            var2_10 = false;
        }
        if ((var4_19 & 4) != 0) {
            var3_16 = false;
        }
        v0.rootContext = var1_7;
        var0.mappingContext = var2_10;
        var0.simpleKeyContext = var3_16;
        v1 = var0.event;
        v2 = v1 != null ? v1.getEventId() : null;
        block0 : switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
            case 1: {
                var2_10 = var3_16;
                var1_8 = var0;
                if (!(var1_8.event instanceof AliasEvent)) {
                    throw new EmitterException("Expecting Alias.");
                }
                var4_19 = (int)var2_10;
                var3_17 = var1_8;
                var3_17.processAnchorOrAlias("*", (boolean)var4_19);
                var0.state = (EmitterState)var1_8.states.removeLast();
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                var1_9 = var0;
                var1_9.processAnchorOrAlias("&", false);
                var1_9 = var0;
                v3 = var1_9.event;
                if ((v3 != null ? v3.getEventId() : null) != Event.ID.Scalar) ** GOTO lbl84
                v4 = var1_9.event;
                Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                var3_18 = (ScalarEvent)v4;
                var2_11 = var3_18.getTag();
                if (var1_9.scalarStyle != null) ** GOTO lbl77
                var5_22 = var3_18;
                var4_20 = var1_9;
                if (var4_20.analysis == null) {
                    var4_20.analysis = var4_20.analyzeScalar(var5_22.getValue());
                }
                if ((var5_22.getPlain() || !var5_22.getDQuoted()) && !var4_20.canonical) ** GOTO lbl41
                v5 = ScalarStyle.DOUBLE_QUOTED;
                ** GOTO lbl77
lbl41:
                // 1 sources

                if (var5_22.getJson() && Intrinsics.areEqual((Object)var5_22.getTag(), (Object)Tag.STR.getValue())) ** GOTO lbl-1000
                if (!var5_22.getPlain() && !var5_22.getJson() || !var5_22.getImplicit().canOmitTagInPlainScalar()) ** GOTO lbl60
                if (!var4_20.simpleKeyContext) ** GOTO lbl50
                v6 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v6);
                if (v6.getEmpty()) ** GOTO lbl60
                v7 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v7);
                if (v7.getMultiline()) ** GOTO lbl60
lbl50:
                // 2 sources

                if (var4_20.flowLevel == 0) ** GOTO lbl54
                v8 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v8);
                if (v8.getAllowFlowPlain()) ** GOTO lbl58
lbl54:
                // 2 sources

                if (var4_20.flowLevel != 0) ** GOTO lbl60
                v9 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v9);
                if (!v9.getAllowBlockPlain()) ** GOTO lbl60
lbl58:
                // 2 sources

                v5 = ScalarStyle.PLAIN;
                ** GOTO lbl77
lbl60:
                // 5 sources

                if (!var5_22.getLiteral() && !var5_22.getFolded() || var4_20.flowLevel != 0 || var4_20.simpleKeyContext) ** GOTO lbl66
                v10 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v10);
                if (!v10.getAllowBlock()) ** GOTO lbl66
                v5 = var5_22.getScalarStyle();
                ** GOTO lbl77
lbl66:
                // 2 sources

                if (!var5_22.getPlain() && !var5_22.getSQuoted()) ** GOTO lbl-1000
                v11 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v11);
                if (!v11.getAllowSingleQuoted()) ** GOTO lbl-1000
                if (!var4_20.simpleKeyContext) ** GOTO lbl-1000
                v12 = var4_20.analysis;
                Intrinsics.checkNotNull((Object)v12);
                if (!v12.getMultiline()) lbl-1000:
                // 2 sources

                {
                    v5 = ScalarStyle.SINGLE_QUOTED;
                } else lbl-1000:
                // 4 sources

                {
                    v5 = var4_20.scalarStyle = ScalarStyle.DOUBLE_QUOTED;
                }
lbl77:
                // 6 sources

                if (var1_9.canonical && var2_11 != null || (var1_9.scalarStyle != ScalarStyle.PLAIN || !var3_18.getImplicit().canOmitTagInPlainScalar()) && (var1_9.scalarStyle == ScalarStyle.PLAIN || !var3_18.getImplicit().canOmitTagInNonPlainScalar())) ** GOTO lbl80
                var1_9.preparedTag = null;
                ** GOTO lbl98
lbl80:
                // 1 sources

                if (!var3_18.getImplicit().canOmitTagInPlainScalar() || var2_11 != null) ** GOTO lbl-1000
                var2_11 = "!";
                var1_9.preparedTag = null;
                ** GOTO lbl-1000
lbl84:
                // 1 sources

                v13 = var1_9.event;
                Intrinsics.checkNotNull((Object)v13, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.CollectionStartEvent");
                var3_18 = (CollectionStartEvent)v13;
                var2_11 = var3_18.getTag();
                if ((!var1_9.canonical || var2_11 == null) && var3_18.isImplicit()) {
                    var1_9.preparedTag = null;
                } else lbl-1000:
                // 3 sources

                {
                    if (var2_11 == null) {
                        throw new EmitterException("tag is not specified");
                    }
                    v14 = var1_9.preparedTag;
                    if (v14 == null) {
                        v14 = var1_9.prepareTag((String)var2_11);
                    }
                    var3_18 = v14;
                    Emitter.writeIndicator$default$39c64b9d((Emitter)var1_9, (String)var3_18, true, false, false, 12);
                }
lbl98:
                // 3 sources

                v15 = var0;
                v16 = v15.event;
                Intrinsics.checkNotNull((Object)v16);
                var2_11 = v16.getEventId();
                var1_9 = v15;
                switch (WhenMappings.$EnumSwitchMapping$0[var2_11.ordinal()]) {
                    case 2: {
                        var3_18 = var1_9;
                        Emitter.increaseIndent$default$65bc426f((Emitter)var3_18, true, false, 2);
                        v17 = var3_18;
                        v18 = v17.event;
                        Intrinsics.checkNotNull((Object)v18, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                        var5_22 = (ScalarEvent)v18;
                        var4_21 = v17;
                        if (v17.analysis == null) {
                            var4_21.analysis = super.analyzeScalar(var5_22.getValue());
                        }
                        if (var4_21.simpleKeyContext) ** GOTO lbl-1000
                        var14_29 = var4_21;
                        if (var14_29.opts.isSplitLines()) {
                            v19 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v19 = false;
                        }
                        var0_1 = v19;
                        v20 = var4_21.scalarStyle;
                        switch (v20 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[v20.ordinal()]) {
                            case 1: {
                                v21 = var4_21;
                                v22 = v21.analysis;
                                Intrinsics.checkNotNull((Object)v22);
                                var2_12 = var0_1;
                                var1_9 = v22.getScalar();
                                var0_2 = v21;
                                if (v21.rootContext) {
                                    var0_2.openEnded = true;
                                }
                                if (((CharSequence)var1_9).length() == 0) break;
                                if (!var0_2.whitespace) {
                                    var5_23 = var0_2.column;
                                    var0_2.column = var5_23 + 1;
                                    var0_2.stream.write(" ");
                                }
                                var0_2.whitespace = false;
                                var0_2.indention = false;
                                var5_24 = false;
                                var6_46 = false;
                                var7_51 = 0;
                                for (var8_56 = 0; var8_56 <= var1_9.length(); ++var8_56) {
                                    var9_63 = '\u0000';
                                    if (var8_56 < var1_9.length()) {
                                        var9_63 = var1_9.charAt(var8_56);
                                    }
                                    if (var5_24) {
                                        if (var9_63 != ' ') {
                                            if (var7_51 + 1 == var8_56 && var0_2.column > var0_2.bestWidth && var2_12) {
                                                super.writeIndent();
                                                var0_2.whitespace = false;
                                                var0_2.indention = false;
                                            } else {
                                                var10_68 = var8_56 - var7_51;
                                                var0_2.column += var10_68;
                                                var0_2.stream.write((String)var1_9, var7_51, var10_68);
                                            }
                                            var7_51 = var8_56;
                                        }
                                    } else if (var6_46) {
                                        if (CharConstants.LINEBR.hasNo(var9_63)) {
                                            if (var1_9.charAt(var7_51) == '\n') {
                                                var14_30 = true;
                                                var14_31 = null;
                                                var14_31 = var0_2;
                                                super.writeLineBreak(null);
                                            }
                                            Intrinsics.checkNotNullExpressionValue((Object)var1_9.substring(var7_51, var8_56), (String)"substring(...)");
                                            Intrinsics.checkNotNullExpressionValue((Object)var10_69.toCharArray(), (String)"toCharArray(...)");
                                            for (char var14_32 : var11_79) {
                                                super.writeLineBreak(var14_32 == '\n' ? null : String.valueOf(var14_32));
                                            }
                                            super.writeIndent();
                                            var0_2.whitespace = false;
                                            var0_2.indention = false;
                                            var7_51 = var8_56;
                                        }
                                    } else if (CharConstants.LINEBR.has(var9_63, "\u0000 ")) {
                                        var10_68 = var8_56 - var7_51;
                                        var0_2.column += var10_68;
                                        var0_2.stream.write((String)var1_9, var7_51, var10_68);
                                        var7_51 = var8_56;
                                    }
                                    if (var9_63 == '\u0000') continue;
                                    var5_24 = var9_63 == ' ';
                                    var6_46 = CharConstants.LINEBR.has(var9_63);
                                }
                                break;
                            }
                            case 2: {
                                v23 = var4_21;
                                v24 = v23.analysis;
                                Intrinsics.checkNotNull((Object)v24);
                                var2_13 = var0_1;
                                var1_9 = v24.getScalar();
                                var0_3 = v23;
                                Emitter.writeIndicator$default$39c64b9d((Emitter)v23, "\"", true, false, false, 12);
                                var5_25 = 0;
                                for (var6_47 = 0; var6_47 <= var1_9.length(); ++var6_47) {
                                    var7_52 = null;
                                    if (var6_47 < var1_9.length()) {
                                        var7_52 = Character.valueOf(var1_9.charAt(var6_47));
                                    }
                                    if (var7_52 != null && !StringsKt.contains$default((CharSequence)"\"\\\u0085\u2028\u2029\ufeff", (char)var7_52.charValue(), (boolean)false, (int)2, null) && Intrinsics.compare((int)32, (int)var7_52.charValue()) <= 0 && Intrinsics.compare((int)var7_52.charValue(), (int)126) <= 0) ** GOTO lbl260
                                    if (var5_25 < var6_47) {
                                        var8_57 = var6_47 - var5_25;
                                        var0_3.column += var8_57;
                                        var0_3.stream.write((String)var1_9, var5_25, var8_57);
                                        var5_25 = var6_47;
                                    }
                                    if (var7_52 == null) ** GOTO lbl260
                                    if (!Emitter.ESCAPE_REPLACEMENTS.containsKey(var7_52)) ** GOTO lbl210
                                    v25 = "\\" + Emitter.ESCAPE_REPLACEMENTS.get(var7_52);
                                    ** GOTO lbl256
lbl210:
                                    // 1 sources

                                    if (Character.isHighSurrogate(var7_52.charValue()) && var6_47 + 1 < var1_9.length()) {
                                        var10_70 = var1_9.charAt(var6_47 + 1);
                                        v26 = dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.toCodePoint$snakeyaml_engine_kmp(var7_52.charValue(), var10_70);
                                    } else {
                                        v26 = var9_64 = var7_52.charValue();
                                    }
                                    if (!var0_3.allowUnicode) ** GOTO lbl-1000
                                    if (StreamReader.Companion.isPrintable(var9_64)) {
                                        var8_58 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(var9_64));
                                        if (dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.charCount$snakeyaml_engine_kmp(var9_64) == 2) {
                                            ++var6_47;
                                        }
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        if (Intrinsics.compare((int)var7_52.charValue(), (int)255) <= 0) {
                                            v27 = new StringBuilder("0");
                                            v28 = Integer.toString(var7_52.charValue(), CharsKt.checkRadix((int)16));
                                            Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"toString(...)");
                                            var10_71 = v27.append(v28).toString();
                                            v29 = new StringBuilder("\\x");
                                            v30 = var10_71;
                                            v31 = v30.substring(v30.length() - 2);
                                            Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"substring(...)");
                                            v25 = v29.append(v31).toString();
                                        } else if (dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.charCount$snakeyaml_engine_kmp(var9_64) == 2) {
                                            ++var6_47;
                                            v32 = new StringBuilder("000");
                                            v33 = Integer.toString(var9_64, CharsKt.checkRadix((int)16));
                                            Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"toString(...)");
                                            var10_72 = v32.append(v33).toString();
                                            v34 = new StringBuilder("\\U");
                                            v35 = var10_72;
                                            v36 = v35.substring(v35.length() - 8);
                                            Intrinsics.checkNotNullExpressionValue((Object)v36, (String)"substring(...)");
                                            v25 = v34.append(v36).toString();
                                        } else {
                                            v37 = new StringBuilder("000");
                                            v38 = Integer.toString(var7_52.charValue(), CharsKt.checkRadix((int)16));
                                            Intrinsics.checkNotNullExpressionValue((Object)v38, (String)"toString(...)");
                                            var10_73 = v37.append(v38).toString();
                                            v39 = new StringBuilder("\\u");
                                            v40 = var10_73;
                                            v41 = v40.substring(v40.length() - 4);
                                            Intrinsics.checkNotNullExpressionValue((Object)v41, (String)"substring(...)");
                                            v25 = v39.append(v41).toString();
                                        }
lbl256:
                                        // 4 sources

                                        var8_58 = v25;
                                    }
                                    var0_3.column += var8_58.length();
                                    var0_3.stream.write(var8_58);
                                    var5_25 = var6_47 + 1;
lbl260:
                                    // 3 sources

                                    if (var6_47 <= 0 || var6_47 >= var1_9.length() - 1) continue;
                                    v42 = var7_52;
                                    if ((v42 == null || v42.charValue() != ' ') && var5_25 < var6_47 || var0_3.column + (var6_47 - var5_25) <= var0_3.bestWidth || !var2_13) continue;
                                    if (var5_25 >= var6_47) {
                                        v43 = "\\";
                                    } else {
                                        v44 = new StringBuilder();
                                        v45 = var1_9.substring(var5_25, var6_47);
                                        Intrinsics.checkNotNullExpressionValue((Object)v45, (String)"substring(...)");
                                        v43 = var8_59 = v44.append(v45).append('\\').toString();
                                    }
                                    if (var5_25 < var6_47) {
                                        var5_25 = var6_47;
                                    }
                                    var0_3.column += var8_59.length();
                                    var0_3.stream.write(var8_59);
                                    super.writeIndent();
                                    var0_3.whitespace = false;
                                    var0_3.indention = false;
                                    if (var1_9.charAt(var5_25) != ' ') continue;
                                    var8_59 = "\\";
                                    var0_3.column += var8_59.length();
                                    var0_3.stream.write(var8_59);
                                }
                                Emitter.writeIndicator$default$39c64b9d((Emitter)var0_3, "\"", false, false, false, 14);
                                break;
                            }
                            case 3: {
                                v46 = var4_21;
                                v47 = v46.analysis;
                                Intrinsics.checkNotNull((Object)v47);
                                var2_14 = var0_1;
                                var1_9 = v47.getScalar();
                                var0_4 = v46;
                                Emitter.writeIndicator$default$39c64b9d((Emitter)v46, "'", true, false, false, 12);
                                var5_26 = false;
                                var6_48 = false;
                                var7_53 = 0;
                                for (var8_60 = 0; var8_60 <= var1_9.length(); ++var8_60) {
                                    var9_65 = '\u0000';
                                    if (var8_60 < var1_9.length()) {
                                        var9_65 = var1_9.charAt(var8_60);
                                    }
                                    if (var5_26) {
                                        if (var9_65 != ' ') {
                                            if (var7_53 + 1 == var8_60 && var0_4.column > var0_4.bestWidth && var2_14 && var7_53 != 0 && var8_60 != var1_9.length()) {
                                                super.writeIndent();
                                            } else {
                                                var10_74 = var8_60 - var7_53;
                                                var0_4.column += var10_74;
                                                var0_4.stream.write((String)var1_9, var7_53, var10_74);
                                            }
                                            var7_53 = var8_60;
                                        }
                                    } else if (var6_48) {
                                        if (var9_65 == '\u0000' || CharConstants.LINEBR.hasNo(var9_65)) {
                                            if (var1_9.charAt(var7_53) == '\n') {
                                                var14_33 = true;
                                                var14_34 = null;
                                                var14_34 = var0_4;
                                                super.writeLineBreak(null);
                                            }
                                            Intrinsics.checkNotNullExpressionValue((Object)var1_9.substring(var7_53, var8_60), (String)"substring(...)");
                                            Intrinsics.checkNotNullExpressionValue((Object)var10_75.toCharArray(), (String)"toCharArray(...)");
                                            for (char var14_35 : var11_80) {
                                                if (var14_35 == '\n') {
                                                    var14_35 = '\u0001';
                                                    var14_36 = null;
                                                    var14_36 = var0_4;
                                                    super.writeLineBreak(null);
                                                    continue;
                                                }
                                                super.writeLineBreak(String.valueOf(var14_35));
                                            }
                                            super.writeIndent();
                                            var7_53 = var8_60;
                                        }
                                    } else if (CharConstants.LINEBR.has(var9_65, "\u0000 '") && var7_53 < var8_60) {
                                        var10_76 = var8_60 - var7_53;
                                        var0_4.column += var10_76;
                                        var0_4.stream.write((String)var1_9, var7_53, var10_76);
                                        var7_53 = var8_60;
                                    }
                                    if (var9_65 == '\'') {
                                        var0_4.column += 2;
                                        var0_4.stream.write("''");
                                        var7_53 = var8_60 + 1;
                                    }
                                    if (var9_65 == '\u0000') continue;
                                    var5_26 = var9_65 == ' ';
                                    var6_48 = CharConstants.LINEBR.has(var9_65);
                                }
                                Emitter.writeIndicator$default$39c64b9d((Emitter)var0_4, "'", false, false, false, 14);
                                break;
                            }
                            case 4: {
                                v48 = var4_21;
                                v49 = v48.analysis;
                                Intrinsics.checkNotNull((Object)v49);
                                var2_15 = var0_1;
                                var1_9 = v49.getScalar();
                                var0_5 = v48;
                                var5_22 = super.determineBlockHints((String)var1_9);
                                Emitter.writeIndicator$default$39c64b9d((Emitter)var0_5, ">" + (String)var5_22, true, false, false, 12);
                                if (StringsKt.endsWith$default((CharSequence)((CharSequence)var5_22), (char)'+', (boolean)false, (int)2, null)) {
                                    var0_5.openEnded = true;
                                }
                                if (!super.writeInlineComments()) {
                                    var14_37 = true;
                                    var14_29 = null;
                                    var14_29 = var0_5;
                                    super.writeLineBreak(null);
                                }
                                var6_49 = true;
                                var7_54 = false;
                                var8_61 = true;
                                var9_66 = 0;
                                for (var10_77 = 0; var10_77 <= var1_9.length(); ++var10_77) {
                                    var11_81 = '\u0000';
                                    if (var10_77 < var1_9.length()) {
                                        var11_81 = var1_9.charAt(var10_77);
                                    }
                                    if (var8_61) {
                                        if (var11_81 == '\u0000' || CharConstants.LINEBR.hasNo(var11_81)) {
                                            if (!var6_49 && var11_81 != '\u0000' && var11_81 != ' ' && var1_9.charAt(var9_66) == '\n') {
                                                var14_38 = true;
                                                var14_39 = null;
                                                var14_39 = var0_5;
                                                super.writeLineBreak(null);
                                            }
                                            var6_49 = var11_81 == ' ';
                                            Intrinsics.checkNotNullExpressionValue((Object)var1_9.substring(var9_66, var10_77), (String)"substring(...)");
                                            Intrinsics.checkNotNullExpressionValue((Object)var12_86.toCharArray(), (String)"toCharArray(...)");
                                            for (int var9_66 : var13_92) {
                                                super.writeLineBreak(var9_66 == 10 ? null : String.valueOf((char)var9_66));
                                            }
                                            if (var11_81 != '\u0000') {
                                                super.writeIndent();
                                            }
                                            var9_66 = var10_77;
                                        }
                                    } else if (var7_54) {
                                        if (var11_81 != ' ') {
                                            if (var9_66 + 1 == var10_77 && var0_5.column > var0_5.bestWidth && var2_15) {
                                                super.writeIndent();
                                            } else {
                                                var12_87 = var10_77 - var9_66;
                                                var0_5.column += var12_87;
                                                var0_5.stream.write((String)var1_9, var9_66, var12_87);
                                            }
                                            var9_66 = var10_77;
                                        }
                                    } else if (CharConstants.LINEBR.has(var11_81, "\u0000 ")) {
                                        var12_88 = var10_77 - var9_66;
                                        var0_5.column += var12_88;
                                        var0_5.stream.write((String)var1_9, var9_66, var12_88);
                                        if (var11_81 == '\u0000') {
                                            var14_41 = true;
                                            var14_42 = null;
                                            var14_42 = var0_5;
                                            super.writeLineBreak(null);
                                        }
                                        var9_66 = var10_77;
                                    }
                                    if (var11_81 == '\u0000') continue;
                                    var8_61 = CharConstants.LINEBR.has(var11_81);
                                    var7_54 = var11_81 == ' ';
                                }
                                break;
                            }
                            case 5: {
                                v50 = var4_21;
                                v51 = v50.analysis;
                                Intrinsics.checkNotNull((Object)v51);
                                var1_9 = v51.getScalar();
                                var0_6 = v50;
                                var2_11 = super.determineBlockHints((String)var1_9);
                                Emitter.writeIndicator$default$39c64b9d((Emitter)var0_6, "|" + (String)var2_11, true, false, false, 12);
                                if (StringsKt.endsWith$default((CharSequence)((CharSequence)var2_11), (char)'+', (boolean)false, (int)2, null)) {
                                    var0_6.openEnded = true;
                                }
                                if (!super.writeInlineComments()) {
                                    var14_43 = true;
                                    var14_29 = null;
                                    var14_29 = var0_6;
                                    super.writeLineBreak(null);
                                }
                                var5_28 = true;
                                var6_50 = 0;
                                for (var7_55 = 0; var7_55 <= var1_9.length(); ++var7_55) {
                                    var8_62 = '\u0000';
                                    if (var7_55 < var1_9.length()) {
                                        var8_62 = var1_9.charAt(var7_55);
                                    }
                                    if (var5_28) {
                                        if (var8_62 == '\u0000' || CharConstants.LINEBR.hasNo(var8_62)) {
                                            Intrinsics.checkNotNullExpressionValue((Object)var1_9.substring(var6_50, var7_55), (String)"substring(...)");
                                            Intrinsics.checkNotNullExpressionValue((Object)var9_67.toCharArray(), (String)"toCharArray(...)");
                                            for (char var13_93 : var10_78) {
                                                if (var13_93 == '\n') {
                                                    var14_44 = true;
                                                    var14_29 = null;
                                                    var14_29 = var0_6;
                                                    super.writeLineBreak(null);
                                                    continue;
                                                }
                                                super.writeLineBreak(String.valueOf(var13_93));
                                            }
                                            if (var8_62 != '\u0000') {
                                                super.writeIndent();
                                            }
                                            var6_50 = var7_55;
                                        }
                                    } else if (var8_62 == '\u0000' || CharConstants.LINEBR.has(var8_62)) {
                                        var0_6.stream.write((String)var1_9, var6_50, var7_55 - var6_50);
                                        if (var8_62 == '\u0000') {
                                            var14_45 = true;
                                            var14_29 = null;
                                            var14_29 = var0_6;
                                            super.writeLineBreak(null);
                                        }
                                        var6_50 = var7_55;
                                    }
                                    if (var8_62 == '\u0000') continue;
                                    var5_28 = CharConstants.LINEBR.has(var8_62);
                                }
                                break;
                            }
                            default: {
                                throw new YamlEngineException("Unexpected scalarStyle: " + (Object)var4_21.scalarStyle);
                            }
                        }
                        var4_21.analysis = null;
                        var4_21.scalarStyle = null;
                        var3_18.indent = (Integer)var3_18.indents.removeLastOrNull();
                        var3_18.state = (EmitterState)var3_18.states.removeLast();
                        break block0;
                    }
                    case 3: {
                        if (var1_9.flowLevel != 0 || var1_9.canonical) ** GOTO lbl479
                        v52 = var1_9.event;
                        Intrinsics.checkNotNull((Object)v52, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.SequenceStartEvent");
                        if (!((SequenceStartEvent)v52).isFlow() && !var1_9.checkEmptySequence()) ** GOTO lbl489
lbl479:
                        // 2 sources

                        var3_18 = var1_9;
                        Emitter.writeIndicator$default$39c64b9d((Emitter)var3_18, "[", true, true, false, 8);
                        var4_19 = var3_18.flowLevel;
                        var3_18.flowLevel = var4_19 + 1;
                        Emitter.increaseIndent$default$65bc426f((Emitter)var3_18, true, false, 2);
                        if (var3_18.multiLineFlow) {
                            super.writeIndent();
                        }
                        var3_18.state = new ExpectFirstFlowSequenceItem((Emitter)var3_18);
                        break block0;
lbl489:
                        // 1 sources

                        var3_18 = var1_9;
                        var4_19 = var3_18.mappingContext != false && var3_18.indention == false ? 1 : 0;
                        Emitter.increaseIndent$default$65bc426f((Emitter)var3_18, false, (boolean)var4_19, 1);
                        var3_18.state = new ExpectFirstBlockSequenceItem((Emitter)var3_18);
                        break block0;
                    }
                    case 4: {
                        if (var1_9.flowLevel != 0 || var1_9.canonical) ** GOTO lbl499
                        v53 = var1_9.event;
                        Intrinsics.checkNotNull((Object)v53, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.MappingStartEvent");
                        if (!((MappingStartEvent)v53).isFlow() && !var1_9.checkEmptyMapping()) ** GOTO lbl509
lbl499:
                        // 2 sources

                        var3_18 = var1_9;
                        Emitter.writeIndicator$default$39c64b9d((Emitter)var3_18, "{", true, true, false, 8);
                        var4_19 = var3_18.flowLevel;
                        var3_18.flowLevel = var4_19 + 1;
                        Emitter.increaseIndent$default$65bc426f((Emitter)var3_18, true, false, 2);
                        if (var3_18.multiLineFlow) {
                            super.writeIndent();
                        }
                        var3_18.state = new ExpectFirstFlowMappingKey((Emitter)var3_18);
                        break block0;
lbl509:
                        // 1 sources

                        var3_18 = var1_9;
                        Emitter.increaseIndent$default$65bc426f((Emitter)var3_18, false, false, 3);
                        var3_18.state = new ExpectFirstBlockMappingKey((Emitter)var3_18);
                        break block0;
                    }
                }
                throw new IllegalStateException(("Unexpected Event.ID " + var2_11).toString());
            }
            default: {
                v54 = var0.event;
                throw new EmitterException("expected NodeEvent, but got " + (Object)(v54 != null ? v54.getEventId() : null));
            }
        }
    }

    private final boolean checkEmptySequence() {
        Event event = this.event;
        return (event != null ? event.getEventId() : null) == Event.ID.SequenceStart && !this.events.isEmpty() && ((Event)this.events.first()).getEventId() == Event.ID.SequenceEnd;
    }

    private final boolean checkEmptyMapping() {
        Event event = this.event;
        return (event != null ? event.getEventId() : null) == Event.ID.MappingStart && !this.events.isEmpty() && ((Event)this.events.first()).getEventId() == Event.ID.MappingEnd;
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnchorOrAlias(String indicator, boolean trailingWhitespace) {
        void var2_2;
        Event event = this.event;
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.NodeEvent");
        NodeEvent nodeEvent = (NodeEvent)event;
        Anchor anchor = nodeEvent.getAnchor();
        if (anchor != null) {
            void var1_1;
            if (this.preparedAnchor == null) {
                this.preparedAnchor = anchor;
            }
            Emitter.writeIndicator$default$39c64b9d(this, (String)var1_1 + nodeEvent, true, false, false, 12);
        }
        this.preparedAnchor = null;
        if (var2_2 != false) {
            this.writeWhitespace(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String prepareTag(String tag) {
        void var1_1;
        String suffix;
        String handle;
        Object v0;
        Iterator iterator;
        Iterable iterable;
        block6: {
            if (((CharSequence)tag).length() == 0) {
                throw new EmitterException("tag must not be empty");
            }
            if (Intrinsics.areEqual((Object)"!", (Object)tag)) {
                return tag;
            }
            iterable = this.tagPrefixes.keySet();
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String prefix = (String)element$iv;
                if (!(prefix != null && StringsKt.startsWith$default((String)tag, (String)prefix, (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)"!", (Object)prefix) || prefix.length() < tag.length()))) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        String matchedPrefix = v0;
        if (matchedPrefix != null) {
            handle = this.tagPrefixes.get(matchedPrefix);
            String string = tag.substring(((String)((Object)iterator)).length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            suffix = string;
        } else {
            handle = null;
        }
        if (handle != null) {
            return (String)((Object)iterable) + suffix;
        }
        return "!<" + (String)var1_1 + '>';
    }

    /*
     * WARNING - void declaration
     */
    private final ScalarAnalysis analyzeScalar(String scalar) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (((CharSequence)scalar).length() == 0) {
            return new ScalarAnalysis(scalar, true, false, false, true, true, false);
        }
        boolean blockIndicators = false;
        boolean flowIndicators = false;
        boolean lineBreaks = false;
        boolean specialCharacters = false;
        boolean leadingSpace = false;
        boolean leadingBreak = false;
        boolean trailingSpace = false;
        boolean trailingBreak = false;
        boolean breakSpace = false;
        boolean spaceBreak = false;
        if (StringsKt.startsWith$default((String)scalar, (String)"---", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)scalar, (String)"...", (boolean)false, (int)2, null)) {
            blockIndicators = true;
            flowIndicators = true;
        }
        boolean precededByWhitespace = true;
        boolean followedByWhitespace = scalar.length() == 1 || CharConstants.NULL_BL_T_LINEBR.has(CharSequenceExtensionsKt.codePointAt(scalar, 1));
        boolean previousSpace = false;
        boolean previousBreak = false;
        int index = 0;
        while (index < scalar.length()) {
            boolean isLineBreak;
            int c;
            block36: {
                block38: {
                    block37: {
                        c = CharSequenceExtensionsKt.codePointAt(scalar, index);
                        if (index == 0) {
                            if (StringsKt.contains$default((CharSequence)"#,[]{}&*!|>'\"%@`", (char)((char)c), (boolean)false, (int)2, null)) {
                                flowIndicators = true;
                                blockIndicators = true;
                            }
                            switch (c) {
                                case 58: 
                                case 63: {
                                    flowIndicators = true;
                                    if (!followedByWhitespace) break;
                                    blockIndicators = true;
                                }
                            }
                            if (c == 45 && followedByWhitespace) {
                                flowIndicators = true;
                                blockIndicators = true;
                            }
                        } else {
                            if (StringsKt.contains$default((CharSequence)",?[]{}", (char)((char)c), (boolean)false, (int)2, null)) {
                                flowIndicators = true;
                            }
                            if (c == 58) {
                                flowIndicators = true;
                                if (followedByWhitespace) {
                                    blockIndicators = true;
                                }
                            }
                            if (c == 35 && precededByWhitespace) {
                                flowIndicators = true;
                                blockIndicators = true;
                            }
                        }
                        if (isLineBreak = CharConstants.LINEBR.has(c)) {
                            lineBreaks = true;
                        }
                        if (c == 10) break block36;
                        if (32 <= c ? c < 127 : false) break block36;
                        if (c == 133) break block37;
                        if (160 <= c ? c < 55296 : false) break block37;
                        if (57344 <= c ? c < 65534 : false) break block37;
                        boolean bl = 65536 <= c ? c < 0x110000 : false;
                        if (!bl) break block38;
                    }
                    if (this.allowUnicode) break block36;
                }
                specialCharacters = true;
            }
            if (c == 32) {
                if (index == 0) {
                    leadingSpace = true;
                }
                if (index == scalar.length() - 1) {
                    trailingSpace = true;
                }
                if (previousBreak) {
                    breakSpace = true;
                }
                previousSpace = true;
                previousBreak = false;
            } else if (isLineBreak) {
                if (index == 0) {
                    leadingBreak = true;
                }
                if (index == scalar.length() - 1) {
                    trailingBreak = true;
                }
                if (previousSpace) {
                    spaceBreak = true;
                }
                previousSpace = false;
                previousBreak = true;
            } else {
                previousSpace = false;
                previousBreak = false;
            }
            precededByWhitespace = CharConstants.NULL_BL_T.has(c) || isLineBreak;
            followedByWhitespace = true;
            if ((index += dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.charCount$snakeyaml_engine_kmp(c)) + 1 >= scalar.length()) continue;
            int nextIndex = index + dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.charCount$snakeyaml_engine_kmp(CharSequenceExtensionsKt.codePointAt(scalar, index));
            if (nextIndex >= scalar.length()) continue;
            followedByWhitespace = CharConstants.NULL_BL_T.has(CharSequenceExtensionsKt.codePointAt(scalar, nextIndex)) || isLineBreak;
        }
        boolean allowFlowPlain = true;
        boolean allowBlockPlain = true;
        boolean allowSingleQuoted = true;
        boolean allowBlock = true;
        if (leadingSpace || leadingBreak || trailingSpace || trailingBreak) {
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (trailingSpace) {
            allowBlock = false;
        }
        if (breakSpace) {
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (spaceBreak || specialCharacters) {
            allowBlock = false;
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (lineBreaks) {
            allowFlowPlain = false;
        }
        if (var3_3 != false) {
            allowFlowPlain = false;
        }
        if (var2_2 != false) {
            allowBlockPlain = false;
        }
        return new ScalarAnalysis((String)var1_1, false, lineBreaks, allowFlowPlain, allowBlockPlain, allowSingleQuoted, allowBlock);
    }

    private final void flushStream() {
        this.stream.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeIndicator(String indicator, boolean needWhitespace, boolean whitespace, boolean indentation) {
        void var1_1;
        void var3_3;
        int n;
        if (!this.whitespace && n != 0) {
            n = this.column;
            this.column = n + 1;
            this.stream.write(" ");
        }
        this.whitespace = var3_3;
        this.indention = this.indention && indentation;
        this.column += indicator.length();
        this.openEnded = false;
        this.stream.write((String)var1_1);
    }

    static /* synthetic */ void writeIndicator$default$39c64b9d(Emitter emitter, String string, boolean bl, boolean bl2, boolean bl3, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        emitter.writeIndicator(string, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final int writeIndent() {
        void var1_1;
        int indentToWrite;
        Integer n = this.indent;
        int n2 = indentToWrite = n != null ? n : 0;
        if (!this.indention || this.column > indentToWrite || this.column == indentToWrite && !this.whitespace) {
            boolean bl = true;
            Emitter emitter = null;
            emitter = this;
            emitter.writeLineBreak(null);
        }
        int whitespaces = indentToWrite - this.column;
        this.writeWhitespace(whitespaces);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeWhitespace(int length) {
        void var1_1;
        if (length <= 0) {
            return;
        }
        this.whitespace = true;
        this.stream.write(StringsKt.repeat((CharSequence)" ", (int)length));
        this.column += var1_1;
    }

    private final void writeLineBreak(String data) {
        Emitter emitter;
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        Object object = emitter;
        if (object == null) {
            emitter = this;
            object = emitter.opts.bestLineBreak;
        }
        this.stream.write((String)object);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeVersionDirective(@NotNull String versionText) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)versionText, (String)"versionText");
        this.stream.write("%YAML " + (String)var1_1);
        boolean bl = true;
        Emitter emitter = null;
        emitter = this;
        emitter.writeLineBreak(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTagDirective(@NotNull String handleText, @NotNull String prefixText) {
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)handleText, (String)"handleText");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        this.stream.write("%TAG " + (String)var1_1 + ' ' + (String)var2_4);
        boolean bl = true;
        Emitter emitter = null;
        emitter = this;
        emitter.writeLineBreak(null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean writeCommentLines(List<CommentLine> commentLines) {
        boolean bl;
        boolean wroteComment = false;
        Emitter emitter = this;
        if (emitter.opts.dumpComments) {
            Iterator iterator;
            int indentColumns = 0;
            int prevColumns32 = 0;
            boolean firstComment = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object var2_5;
                CommentLine commentLine = (CommentLine)iterator.next();
                if (commentLine.commentType != CommentType.BLANK_LINE) {
                    void var2_3;
                    if (firstComment) {
                        firstComment = false;
                        Emitter.writeIndicator$default$39c64b9d(this, "#", commentLine.commentType == CommentType.IN_LINE, false, false, 12);
                        indentColumns = this.column > 0 ? this.column - 1 : 0;
                    } else {
                        this.writeWhitespace(indentColumns - prevColumns32);
                        Emitter.writeIndicator$default$39c64b9d(this, "#", false, false, false, 14);
                    }
                    this.stream.write(var2_3.value);
                    boolean bl2 = true;
                    var2_5 = null;
                    Emitter prevColumns32 = this;
                    prevColumns32.writeLineBreak(null);
                    prevColumns32 = 0;
                } else {
                    boolean bl3 = true;
                    var2_5 = null;
                    Emitter prevColumns32 = this;
                    prevColumns32.writeLineBreak(null);
                    prevColumns32 = this.writeIndent();
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean writeInlineComments() {
        Emitter emitter = this;
        return emitter.writeCommentLines(emitter.inlineCommentsCollector.consume());
    }

    /*
     * WARNING - void declaration
     */
    private final String determineBlockHints(String text) {
        void var2_2;
        block5: {
            StringBuilder hints;
            block6: {
                void var1_1;
                block4: {
                    void var3_3;
                    hints = new StringBuilder();
                    if (CharConstants.LINEBR.has(StringsKt.first((CharSequence)text), " ")) {
                        hints.append(this.bestIndent);
                    }
                    char ch1 = StringsKt.last((CharSequence)text);
                    if (!CharConstants.LINEBR.hasNo((int)var3_3)) break block4;
                    hints.append("-");
                    break block5;
                }
                if (text.length() == 1) break block6;
                void v0 = var1_1;
                if (!CharConstants.LINEBR.has(v0.charAt(v0.length() - 2))) break block5;
            }
            hints.append("+");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ void access$writeStreamStart(Emitter $this) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setState$p(Emitter $this, EmitterState emitterState) {
        void var1_1;
        $this.state = var1_1;
    }

    public static final /* synthetic */ void access$writeStreamEnd(Emitter $this) {
        Emitter emitter = $this;
        emitter.flushStream();
    }

    public static final /* synthetic */ void access$writeBlockComment(Emitter $this) {
        Emitter emitter = $this;
        if (!emitter.blockCommentsCollector.isEmpty()) {
            emitter.writeIndent();
            Emitter emitter2 = emitter;
            emitter2.writeCommentLines(emitter2.blockCommentsCollector.consume());
        }
    }

    public static final /* synthetic */ boolean access$getOpenEnded$p(Emitter $this) {
        return $this.openEnded;
    }

    public static final /* synthetic */ String access$prepareVersion(Emitter $this, SpecVersion version) {
        SpecVersion specVersion = version;
        if (specVersion.getMajor() != 1) {
            throw new EmitterException("unsupported YAML version: " + specVersion);
        }
        return specVersion.getRepresentation();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTagPrefixes$p(Emitter $this, Map map) {
        void var1_1;
        $this.tagPrefixes = var1_1;
    }

    public static final /* synthetic */ Map access$getDEFAULT_TAG_PREFIXES$cp() {
        return DEFAULT_TAG_PREFIXES;
    }

    public static final /* synthetic */ Map access$getTagPrefixes$p(Emitter $this) {
        return $this.tagPrefixes;
    }

    public static final /* synthetic */ Regex access$getHANDLE_FORMAT$cp() {
        return HANDLE_FORMAT;
    }

    public static final /* synthetic */ ArrayDeque access$getEvents$p(Emitter $this) {
        return $this.events;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setEvent$p(Emitter $this, Event event) {
        void var1_1;
        $this.event = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIndent$p(Emitter $this, Integer n) {
        void var1_1;
        $this.indent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setFlowLevel$p(Emitter $this, int n) {
        void var1_1;
        $this.flowLevel = var1_1;
    }

    public static final /* synthetic */ boolean access$getSplitLines(Emitter $this) {
        Emitter emitter = $this;
        return emitter.opts.isSplitLines();
    }

    public static final /* synthetic */ boolean access$checkSimpleKey(Emitter $this) {
        block14: {
            block15: {
                Emitter emitter;
                block16: {
                    Object object;
                    Object object2;
                    emitter = $this;
                    int n = 0;
                    if (emitter.event instanceof NodeEvent) {
                        Event event = emitter.event;
                        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.NodeEvent");
                        object2 = ((NodeEvent)event).getAnchor();
                        if (object2 != null) {
                            if (emitter.preparedAnchor == null) {
                                emitter.preparedAnchor = object2;
                            }
                            n = 0 + ((Anchor)object2).getValue().length();
                        }
                    }
                    Event event = emitter.event;
                    if ((event != null ? event.getEventId() : null) == Event.ID.Scalar) {
                        Event event2 = emitter.event;
                        Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                        object = ((ScalarEvent)event2).getTag();
                    } else if (emitter.event instanceof CollectionStartEvent) {
                        Event event3 = emitter.event;
                        Intrinsics.checkNotNull((Object)event3, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.CollectionStartEvent");
                        object = ((CollectionStartEvent)event3).getTag();
                    } else {
                        object = object2 = null;
                    }
                    if (object != null) {
                        if (emitter.preparedTag == null) {
                            emitter.preparedTag = emitter.prepareTag((String)object2);
                        }
                        String string = emitter.preparedTag;
                        Intrinsics.checkNotNull((Object)string);
                        n += string.length();
                    }
                    Event event4 = emitter.event;
                    if ((event4 != null ? event4.getEventId() : null) == Event.ID.Scalar) {
                        if (emitter.analysis == null) {
                            Event event5 = emitter.event;
                            Intrinsics.checkNotNull((Object)event5, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                            emitter.analysis = emitter.analyzeScalar(((ScalarEvent)event5).getValue());
                        }
                        ScalarAnalysis scalarAnalysis = emitter.analysis;
                        Intrinsics.checkNotNull((Object)scalarAnalysis);
                        n += scalarAnalysis.getScalar().length();
                    }
                    Emitter emitter2 = emitter;
                    if (n >= emitter2.opts.maxSimpleKeyLength) break block14;
                    Event event6 = emitter.event;
                    if ((event6 != null ? event6.getEventId() : null) == Event.ID.Alias) break block15;
                    Event event7 = emitter.event;
                    if ((event7 != null ? event7.getEventId() : null) != Event.ID.Scalar) break block16;
                    ScalarAnalysis scalarAnalysis = emitter.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    if (scalarAnalysis.getEmpty()) break block16;
                    ScalarAnalysis scalarAnalysis2 = emitter.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis2);
                    if (!scalarAnalysis2.getMultiline()) break block15;
                }
                if (!emitter.checkEmptySequence() && !emitter.checkEmptyMapping()) break block14;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$getIndentWithIndicator(Emitter $this) {
        Emitter emitter = $this;
        return emitter.opts.indentWithIndicator;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$writeWhitespace(Emitter $this, int length) {
        void var1_1;
        $this.writeWhitespace((int)var1_1);
    }

    public static final /* synthetic */ int access$getIndicatorIndent(Emitter $this) {
        Emitter emitter = $this;
        return emitter.opts.indicatorIndent;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAnalysis$p(Emitter $this, ScalarAnalysis scalarAnalysis) {
        void var1_1;
        $this.analysis = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ScalarAnalysis access$analyzeScalar(Emitter $this, String scalar) {
        void var1_1;
        return $this.analyzeScalar((String)var1_1);
    }

    static {
        new Companion(null);
        Pair[] pairArray = new Pair[13];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"0");
        pairArray2[1] = TuplesKt.to((Object)Character.valueOf('\u0007'), (Object)"a");
        pairArray2[2] = TuplesKt.to((Object)Character.valueOf('\b'), (Object)"b");
        pairArray2[3] = TuplesKt.to((Object)Character.valueOf('\t'), (Object)"t");
        pairArray2[4] = TuplesKt.to((Object)Character.valueOf('\n'), (Object)"n");
        pairArray2[5] = TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"v");
        pairArray2[6] = TuplesKt.to((Object)Character.valueOf('\f'), (Object)"f");
        pairArray2[7] = TuplesKt.to((Object)Character.valueOf('\r'), (Object)"r");
        pairArray2[8] = TuplesKt.to((Object)Character.valueOf('\u001b'), (Object)"e");
        pairArray2[9] = TuplesKt.to((Object)Character.valueOf('\"'), (Object)"\"");
        pairArray2[10] = TuplesKt.to((Object)Character.valueOf('\\'), (Object)"\\");
        pairArray2[11] = TuplesKt.to((Object)Character.valueOf('\u0085'), (Object)"N");
        pairArray2[12] = TuplesKt.to((Object)Character.valueOf('\u00a0'), (Object)"_");
        ESCAPE_REPLACEMENTS = MapsKt.mapOf((Pair[])pairArray2);
        Pair[] pairArray3 = new Pair[2];
        pairArray2 = pairArray3;
        pairArray3[0] = TuplesKt.to((Object)"!", (Object)"!");
        pairArray2[1] = TuplesKt.to((Object)"tag:yaml.org,2002:", (Object)"!!");
        DEFAULT_TAG_PREFIXES = MapsKt.mapOf((Pair[])pairArray2);
        VALID_INDENT_RANGE = new IntRange(1, 10);
        VALID_INDICATOR_INDENT_RANGE = RangesKt.until((int)(VALID_INDENT_RANGE.getFirst() - 1), (int)VALID_INDENT_RANGE.getLast());
        HANDLE_FORMAT = new Regex("^![-_\\w]*!$");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\bR\u0014\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Ldev/rvbsm/fsit/lib/snakeyaml-kmp/emitter/Emitter$Companion;", "", "<init>", "()V", "", "", "", "ESCAPE_REPLACEMENTS", "Ljava/util/Map;", "DEFAULT_TAG_PREFIXES", "Lkotlin/ranges/IntRange;", "VALID_INDENT_RANGE", "Lkotlin/ranges/IntRange;", "VALID_INDICATOR_INDENT_RANGE", "Lkotlin/text/Regex;", "HANDLE_FORMAT", "Lkotlin/text/Regex;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private final class ExpectBlockMappingKey
    implements EmitterState {
        private final boolean first;
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectBlockMappingKey(Emitter this$0, boolean first) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.first = var2_2;
        }

        @Override
        public final void expect() {
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Emitter.access$writeBlockComment(this.this$0);
            if (!this.first) {
                Event event = this.this$0.event;
                if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                    Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                    Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                    return;
                }
            }
            this.this$0.writeIndent();
            if (Emitter.access$checkSimpleKey(this.this$0)) {
                this.this$0.states.addLast((Object)new ExpectBlockMappingSimpleValue(this.this$0));
                Emitter.expectNode$default$52081599(this.this$0, false, true, true, 1);
                return;
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, "?", true, false, true, 4);
            this.this$0.states.addLast((Object)new ExpectBlockMappingValue(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
        }
    }

    private final class ExpectBlockMappingSimpleValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectBlockMappingSimpleValue(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ":", false, false, false, 14);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Event event = this.this$0.event;
            Intrinsics.checkNotNull((Object)event);
            Event event2 = event;
            if (!(event instanceof ScalarEvent && (((ScalarEvent)event2).getScalarStyle() == ScalarStyle.FOLDED || ((ScalarEvent)event2).getScalarStyle() == ScalarStyle.LITERAL)) && this.this$0.writeInlineComments()) {
                Emitter.increaseIndent$default$65bc426f(this.this$0, true, false, 2);
                this.this$0.writeIndent();
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
            }
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            if (!this.this$0.blockCommentsCollector.isEmpty()) {
                Emitter.increaseIndent$default$65bc426f(this.this$0, true, false, 2);
                Emitter.access$writeBlockComment(this.this$0);
                this.this$0.writeIndent();
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
            }
            this.this$0.states.addLast((Object)new ExpectBlockMappingKey(this.this$0, false));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
            this.this$0.inlineCommentsCollector.collectEvents();
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectBlockMappingValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectBlockMappingValue(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            this.this$0.writeIndent();
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ":", true, false, true, 4);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEventsAndPoll(this.this$0.event));
            this.this$0.writeInlineComments();
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Emitter.access$writeBlockComment(this.this$0);
            this.this$0.states.addLast((Object)new ExpectBlockMappingKey(this.this$0, false));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
            this.this$0.inlineCommentsCollector.collectEvents(this.this$0.event);
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectBlockSequenceItem
    implements EmitterState {
        private final boolean first;
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectBlockSequenceItem(Emitter this$0, boolean first) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.first = var2_2;
        }

        @Override
        public final void expect() {
            if (!this.first) {
                Event event = this.this$0.event;
                if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                    Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                    Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                    return;
                }
            }
            if (this.this$0.event instanceof CommentEvent) {
                this.this$0.blockCommentsCollector.collectEvents(this.this$0.event);
                return;
            }
            this.this$0.writeIndent();
            if (!Emitter.access$getIndentWithIndicator(this.this$0) || this.first) {
                Emitter.access$writeWhitespace(this.this$0, Emitter.access$getIndicatorIndent(this.this$0));
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, "-", true, false, true, 4);
            if (Emitter.access$getIndentWithIndicator(this.this$0) && this.first) {
                Integer n = this.this$0.indent;
                Intrinsics.checkNotNull((Object)n);
                Emitter.access$setIndent$p(this.this$0, n + Emitter.access$getIndicatorIndent(this.this$0));
            }
            if (!this.this$0.blockCommentsCollector.isEmpty()) {
                Emitter.increaseIndent$default$65bc426f(this.this$0, false, false, 3);
                Emitter.access$writeBlockComment(this.this$0);
                if (this.this$0.event instanceof ScalarEvent) {
                    Event event = this.this$0.event;
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                    Emitter.access$setAnalysis$p(this.this$0, Emitter.access$analyzeScalar(this.this$0, ((ScalarEvent)event).getValue()));
                    ScalarAnalysis scalarAnalysis = this.this$0.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    if (!scalarAnalysis.getEmpty()) {
                        this.this$0.writeIndent();
                    }
                }
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
            }
            this.this$0.states.addLast((Object)new ExpectBlockSequenceItem(this.this$0, false));
            Emitter.expectNode$default$52081599(this.this$0, false, false, false, 7);
            this.this$0.inlineCommentsCollector.collectEvents();
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectDocumentEnd
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectDocumentEnd(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Emitter.access$writeBlockComment(this.this$0);
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.DocumentEnd) {
                this.this$0.writeIndent();
                Event event2 = this.this$0.event;
                Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.DocumentEndEvent");
                if (((DocumentEndEvent)event2).isExplicit()) {
                    Emitter.writeIndicator$default$39c64b9d(this.this$0, "...", true, false, false, 12);
                    this.this$0.writeIndent();
                }
                this.this$0.flushStream();
                Emitter.access$setState$p(this.this$0, new ExpectDocumentStart(this.this$0, false));
                return;
            }
            throw new EmitterException("expected DocumentEndEvent, but got " + this.this$0.event);
        }
    }

    private final class ExpectDocumentRoot
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectDocumentRoot(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            if (!this.this$0.blockCommentsCollector.isEmpty()) {
                Emitter.access$writeBlockComment(this.this$0);
                if (this.this$0.event instanceof DocumentEndEvent) {
                    new ExpectDocumentEnd(this.this$0).expect();
                    return;
                }
            }
            this.this$0.states.addLast((Object)new ExpectDocumentEnd(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, true, false, false, 6);
        }
    }

    private final class ExpectDocumentStart
    implements EmitterState {
        private final boolean first;
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectDocumentStart(Emitter this$0, boolean first) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.first = var2_2;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public final void expect() {
            block18: {
                v0 = Emitter.access$getEvent$p(this.this$0);
                if ((v0 != null ? v0.getEventId() : null) != Event.ID.DocumentStart) break block18;
                v1 = Emitter.access$getEvent$p(this.this$0);
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.DocumentStartEvent");
                ev = (DocumentStartEvent)v1;
                var2_2 = var1_1;
                var1_1 = this;
                if ((var2_2.getSpecVersion() != null || var2_2.getTags().isEmpty() == false) && Emitter.access$getOpenEnded$p(var1_1.this$0)) {
                    Emitter.writeIndicator$default$39c64b9d(var1_1.this$0, "...", true, false, false, 12);
                    Emitter.access$writeIndent(var1_1.this$0);
                }
                if (var2_2.getSpecVersion() != null) {
                    var1_1.this$0.writeVersionDirective(Emitter.access$prepareVersion(var1_1.this$0, var2_2.getSpecVersion()));
                }
                Emitter.access$setTagPrefixes$p(var1_1.this$0, MapsKt.toMutableMap((Map)Emitter.access$getDEFAULT_TAG_PREFIXES$cp()));
                if (var2_2.getTags().isEmpty() == false) {
                    var4_4 = var2_2.getTags();
                    var3_5 = var1_1;
                    for (Object var5_6 : var4_4.entrySet()) {
                        var6_7 = (String)var5_6.getKey();
                        var5_6 = (String)var5_6.getValue();
                        Emitter.access$getTagPrefixes$p(var3_5.this$0).put(var5_6, var6_7);
                        var7_8 = var6_7;
                        if (((CharSequence)var7_8).length() == 0) {
                            throw new EmitterException("tag handle must not be empty");
                        }
                        if (!StringsKt.startsWith$default((CharSequence)((CharSequence)var7_8), (char)'!', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)((CharSequence)var7_8), (char)'!', (boolean)false, (int)2, null)) {
                            throw new EmitterException("tag handle must start and end with '!': " + (String)var7_8);
                        }
                        if (!Intrinsics.areEqual((Object)var7_8, (Object)"!") && !Emitter.access$getHANDLE_FORMAT$cp().matches((CharSequence)var7_8)) {
                            throw new EmitterException("invalid character in the tag handle: " + (String)var7_8);
                        }
                        var7_8 = var5_6;
                        if (((CharSequence)var7_8).length() == 0) {
                            throw new EmitterException("tag prefix must not be empty");
                        }
                        var3_5.this$0.writeTagDirective(var6_7, (String)var5_6);
                    }
                }
                if (!var1_1.first || var2_2.getExplicit() || Emitter.access$getCanonical$p(var1_1.this$0) || var2_2.getSpecVersion() != null || !var2_2.getTags().isEmpty()) ** GOTO lbl-1000
                var3_5 = var1_1;
                v2 = Emitter.access$getEvent$p(var3_5.this$0);
                if ((v2 != null ? v2.getEventId() : null) != Event.ID.DocumentStart || Emitter.access$getEvents$p(var3_5.this$0).isEmpty()) {
                    v3 = false;
                } else {
                    var4_4 = (Event)Emitter.access$getEvents$p(var3_5.this$0).first();
                    if (var4_4.getEventId() == Event.ID.Scalar) {
                        Intrinsics.checkNotNull((Object)var4_4, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
                        var4_4 = (ScalarEvent)var4_4;
                        v3 = var4_4.getAnchor() == null && var4_4.getTag() == null && ((CharSequence)var4_4.getValue()).length() == 0;
                    } else {
                        v3 = false;
                    }
                }
                if (!v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = var2_3 = false;
                }
                if (!v4) {
                    Emitter.access$writeIndent(var1_1.this$0);
                    Emitter.writeIndicator$default$39c64b9d(var1_1.this$0, "---", true, false, false, 12);
                    if (Emitter.access$getCanonical$p(var1_1.this$0)) {
                        Emitter.access$writeIndent(var1_1.this$0);
                    }
                }
                Emitter.access$setState$p(this.this$0, new ExpectDocumentRoot(this.this$0));
                return;
            }
            v5 = Emitter.access$getEvent$p(this.this$0);
            if ((v5 != null ? v5.getEventId() : null) == Event.ID.StreamEnd) {
                Emitter.access$writeStreamEnd(this.this$0);
                Emitter.access$setState$p(this.this$0, new ExpectNothing(this.this$0));
                return;
            }
            if (Emitter.access$getEvent$p(this.this$0) instanceof CommentEvent) {
                Emitter.access$getBlockCommentsCollector$p(this.this$0).collectEvents(Emitter.access$getEvent$p(this.this$0));
                Emitter.access$writeBlockComment(this.this$0);
                return;
            }
            throw new EmitterException("expected DocumentStartEvent, but got " + Emitter.access$getEvent$p(this.this$0));
        }
    }

    private final class ExpectFirstBlockMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFirstBlockMappingKey(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            new ExpectBlockMappingKey(this.this$0, true).expect();
        }
    }

    private final class ExpectFirstBlockSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFirstBlockSequenceItem(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            new ExpectBlockSequenceItem(this.this$0, true).expect();
        }
    }

    private final class ExpectFirstDocumentStart
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFirstDocumentStart(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            new ExpectDocumentStart(this.this$0, true).expect();
        }
    }

    private final class ExpectFirstFlowMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFirstFlowMappingKey(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Emitter.access$writeBlockComment(this.this$0);
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                int n = this.this$0.flowLevel;
                Emitter.access$setFlowLevel$p(this.this$0, n + -1);
                Emitter.writeIndicator$default$39c64b9d(this.this$0, "}", false, false, false, 14);
                this.this$0.inlineCommentsCollector.collectEvents();
                this.this$0.writeInlineComments();
                Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                return;
            }
            if (this.this$0.canonical || this.this$0.column > this.this$0.bestWidth && Emitter.access$getSplitLines(this.this$0) || this.this$0.multiLineFlow) {
                this.this$0.writeIndent();
            }
            if (!this.this$0.canonical && Emitter.access$checkSimpleKey(this.this$0)) {
                this.this$0.states.addLast((Object)new ExpectFlowMappingSimpleValue(this.this$0));
                Emitter.expectNode$default$52081599(this.this$0, false, true, true, 1);
                return;
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, "?", true, false, false, 12);
            this.this$0.states.addLast((Object)new ExpectFlowMappingValue(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
        }
    }

    private final class ExpectFirstFlowSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFirstFlowSequenceItem(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                int n = this.this$0.flowLevel;
                Emitter.access$setFlowLevel$p(this.this$0, n + -1);
                Emitter.writeIndicator$default$39c64b9d(this.this$0, "]", false, false, false, 14);
                this.this$0.inlineCommentsCollector.collectEvents();
                this.this$0.writeInlineComments();
                Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                return;
            }
            if (this.this$0.event instanceof CommentEvent) {
                this.this$0.blockCommentsCollector.collectEvents(this.this$0.event);
                Emitter.access$writeBlockComment(this.this$0);
                return;
            }
            if (this.this$0.canonical || this.this$0.column > this.this$0.bestWidth && Emitter.access$getSplitLines(this.this$0) || this.this$0.multiLineFlow) {
                this.this$0.writeIndent();
            }
            this.this$0.states.addLast((Object)new ExpectFlowSequenceItem(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, false, false, 7);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEvents(this.this$0.event));
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectFlowMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFlowMappingKey(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                int n = this.this$0.flowLevel;
                Emitter.access$setFlowLevel$p(this.this$0, n + -1);
                if (this.this$0.canonical) {
                    Emitter.writeIndicator$default$39c64b9d(this.this$0, ",", false, false, false, 14);
                    this.this$0.writeIndent();
                }
                if (this.this$0.multiLineFlow) {
                    this.this$0.writeIndent();
                }
                Emitter.writeIndicator$default$39c64b9d(this.this$0, "}", false, false, false, 14);
                this.this$0.inlineCommentsCollector.collectEvents();
                this.this$0.writeInlineComments();
                Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                return;
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ",", false, false, false, 14);
            Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEventsAndPoll(this.this$0.event));
            Emitter.access$writeBlockComment(this.this$0);
            if (this.this$0.canonical || this.this$0.column > this.this$0.bestWidth && Emitter.access$getSplitLines(this.this$0) || this.this$0.multiLineFlow) {
                this.this$0.writeIndent();
            }
            if (!this.this$0.canonical && Emitter.access$checkSimpleKey(this.this$0)) {
                this.this$0.states.addLast((Object)new ExpectFlowMappingSimpleValue(this.this$0));
                Emitter.expectNode$default$52081599(this.this$0, false, true, true, 1);
                return;
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, "?", true, false, false, 12);
            this.this$0.states.addLast((Object)new ExpectFlowMappingValue(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
        }
    }

    private final class ExpectFlowMappingSimpleValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFlowMappingSimpleValue(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ":", false, false, false, 14);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEventsAndPoll(this.this$0.event));
            this.this$0.writeInlineComments();
            this.this$0.states.addLast((Object)new ExpectFlowMappingKey(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
            this.this$0.inlineCommentsCollector.collectEvents(this.this$0.event);
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectFlowMappingValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFlowMappingValue(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            if (this.this$0.canonical || this.this$0.column > this.this$0.bestWidth || this.this$0.multiLineFlow) {
                this.this$0.writeIndent();
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ":", true, false, false, 12);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEventsAndPoll(this.this$0.event));
            this.this$0.writeInlineComments();
            this.this$0.states.addLast((Object)new ExpectFlowMappingKey(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, true, false, 5);
            this.this$0.inlineCommentsCollector.collectEvents(this.this$0.event);
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectFlowSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectFlowSequenceItem(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                Emitter.access$setIndent$p(this.this$0, (Integer)this.this$0.indents.removeLastOrNull());
                int n = this.this$0.flowLevel;
                Emitter.access$setFlowLevel$p(this.this$0, n + -1);
                if (this.this$0.canonical) {
                    Emitter.writeIndicator$default$39c64b9d(this.this$0, ",", false, false, false, 14);
                    this.this$0.writeIndent();
                } else if (this.this$0.multiLineFlow) {
                    this.this$0.writeIndent();
                }
                Emitter.writeIndicator$default$39c64b9d(this.this$0, "]", false, false, false, 14);
                this.this$0.inlineCommentsCollector.collectEvents();
                this.this$0.writeInlineComments();
                if (this.this$0.multiLineFlow) {
                    this.this$0.writeIndent();
                }
                Emitter.access$setState$p(this.this$0, (EmitterState)this.this$0.states.removeLast());
                return;
            }
            if (this.this$0.event instanceof CommentEvent) {
                Emitter.access$setEvent$p(this.this$0, this.this$0.blockCommentsCollector.collectEvents(this.this$0.event));
                return;
            }
            Emitter.writeIndicator$default$39c64b9d(this.this$0, ",", false, false, false, 14);
            Emitter.access$writeBlockComment(this.this$0);
            if (this.this$0.canonical || this.this$0.column > this.this$0.bestWidth && Emitter.access$getSplitLines(this.this$0) || this.this$0.multiLineFlow) {
                this.this$0.writeIndent();
            }
            this.this$0.states.addLast((Object)new ExpectFlowSequenceItem(this.this$0));
            Emitter.expectNode$default$52081599(this.this$0, false, false, false, 7);
            Emitter.access$setEvent$p(this.this$0, this.this$0.inlineCommentsCollector.collectEvents(this.this$0.event));
            this.this$0.writeInlineComments();
        }
    }

    private final class ExpectNothing
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectNothing(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            throw new EmitterException("expecting nothing, but got " + this.this$0.event);
        }
    }

    private final class ExpectStreamStart
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectStreamStart(Emitter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void expect() {
            Event event = this.this$0.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.StreamStart) {
                Emitter.access$writeStreamStart(this.this$0);
                Emitter.access$setState$p(this.this$0, new ExpectFirstDocumentStart(this.this$0));
                return;
            }
            throw new EmitterException("expected StreamStartEvent, but got " + this.this$0.event);
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Event.ID.values().length];
            try {
                nArray[Event.ID.Alias.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Event.ID.Scalar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Event.ID.SequenceStart.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Event.ID.MappingStart.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScalarStyle.values().length];
            try {
                nArray[ScalarStyle.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ScalarStyle.DOUBLE_QUOTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ScalarStyle.SINGLE_QUOTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ScalarStyle.FOLDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ScalarStyle.LITERAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

