/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner;

import dev.rvbsm.fsit.lib.okio.BufferedSource;
import dev.rvbsm.fsit.lib.okio.Okio;
import dev.rvbsm.fsit.lib.okio.Source;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.LoadSettings;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.CharConstants;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.Mark;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.ReaderException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.YamlEngineException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.CharSequenceExtensionsKt;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BufferedSourceExtensions.kt\nit/krzeminski/snakeyaml/engine/kmp/internal/utils/BufferedSourceExtensionsKt\n*L\n1#1,297:1\n1#2:298\n11#3,17:299\n86#3,2:316\n31#3,13:318\n86#3,2:331\n44#3,18:333\n86#3,2:351\n67#3,6:353\n95#3,11:359\n74#3,8:370\n*S KotlinDebug\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader\n*L\n202#1:299,17\n202#1:316,2\n202#1:318,13\n202#1:331,2\n202#1:333,18\n202#1:351,2\n202#1:353,6\n202#1:359,11\n202#1:370,8\n*E\n"})
public final class StreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource stream;
    @NotNull
    private final String name;
    private final boolean useMarks;
    private final long bufferReadSize;
    @NotNull
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer;
    private boolean eof;
    private int index;
    private int documentIndex;
    private int line;
    private int column;

    /*
     * WARNING - void declaration
     */
    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull Source stream) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)loadSettings, (String)"loadSettings");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (!(((LoadSettings)loadSettings).bufferSize >= 4)) {
            loadSettings = "buffer size must be at least 4 bytes to be able to read all Unicode codepoints";
            throw new IllegalArgumentException(loadSettings.toString());
        }
        this.stream = stream instanceof BufferedSource ? (BufferedSource)stream : Okio.buffer((Source)var2_2);
        this.name = ((LoadSettings)loadSettings).label;
        this.useMarks = ((LoadSettings)loadSettings).useMarks;
        this.bufferReadSize = var1_1.bufferSize;
        this.codePointsWindow = new int[0];
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getDocumentIndex() {
        return this.documentIndex;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @Nullable
    public final Mark getMark() {
        if (!this.useMarks) {
            return null;
        }
        return new Mark(this.name, this.index, this.line, this.column, ArraysKt.asList((int[])this.codePointsWindow), this.pointer);
    }

    @JvmOverloads
    public final void forward(int length) {
        for (int j = 0; j < length; ++j) {
            int n;
            block4: {
                int c;
                block3: {
                    boolean bl = true;
                    bl = false;
                    StreamReader streamReader = this;
                    if (!streamReader.ensureEnoughData(0)) continue;
                    n = this.pointer;
                    this.pointer = n + 1;
                    c = this.codePointsWindow[n];
                    this.moveIndices(1);
                    if (CharConstants.LINEBR.has(c)) break block3;
                    if (c != 13) break block4;
                    boolean bl2 = true;
                    bl2 = false;
                    streamReader = this;
                    if (!streamReader.ensureEnoughData(0) || this.codePointsWindow[this.pointer] == 10) break block4;
                }
                c = this.line;
                this.line = c + 1;
                this.column = 0;
                continue;
            }
            if (n == 65279) continue;
            n = this.column;
            this.column = n + 1;
        }
    }

    public static /* synthetic */ void forward$default$4375041d(StreamReader streamReader, int n, int n2) {
        streamReader.forward(1);
    }

    public final int peek() {
        boolean bl = true;
        bl = false;
        StreamReader streamReader = this;
        if (streamReader.ensureEnoughData(0)) {
            return this.codePointsWindow[this.pointer];
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int peek(int index) {
        if (this.ensureEnoughData(index)) {
            void var1_1;
            return this.codePointsWindow[this.pointer + var1_1];
        }
        return 0;
    }

    @NotNull
    public final String prefix(int length) {
        int n;
        StringBuilder stringBuilder;
        if (length == 0) {
            return "";
        }
        int stringLength = this.ensureEnoughData(length) ? length : RangesKt.coerceAtMost((int)length, (int)(this.dataLength - this.pointer));
        StringBuilder $this$prefix_u24lambda_u242 = stringBuilder = new StringBuilder(stringLength);
        n = this.pointer + n;
        for (int i2 = this.pointer; i2 < n; ++i2) {
            $this$prefix_u24lambda_u242.appendCodePoint(this.codePointsWindow[i2]);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String prefixForward(int length) {
        void var2_2;
        void var1_1;
        String prefix = this.prefix(length);
        this.pointer += length;
        this.moveIndices(length);
        this.column += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean ensureEnoughData(int size) {
        void var1_1;
        if (!this.eof && this.pointer + size >= this.dataLength) {
            this.update();
        }
        return this.pointer + var1_1 < this.dataLength;
    }

    /*
     * Unable to fully structure code
     */
    private final void update() {
        block10: {
            try {
                block12: {
                    block13: {
                        block11: {
                            var2_1 = this.stream;
                            limitBytes$iv = this.bufferReadSize;
                            $this$sizeOfFullValidUtf8String$iv$iv = $this$readUtf8WithLimit$iv;
                            var1_8 = $this$sizeOfFullValidUtf8String$iv$iv.request(limitBytes$iv);
                            originalSize$iv$iv = var1_8 != false ? limitBytes$iv : $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().size();
                            if (originalSize$iv$iv != 0L) break block11;
                            v0 = 0L;
                            break block12;
                        }
                        limitBytes$iv = byte$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(originalSize$iv$iv - 1L);
                        if ((byte$iv$iv & 192) == 128) break block13;
                        v0 = originalSize$iv$iv - (long)(byte$iv$iv < 0 ? 1 : 0);
                        break block12;
                    }
                    if (!$this$sizeOfFullValidUtf8String$iv$iv.request(originalSize$iv$iv + 1L)) ** GOTO lbl-1000
                    byte$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(originalSize$iv$iv);
                    byte$iv$iv = byte$iv$iv;
                    if ((v1 & 192) == 128) {
                        size$iv$iv = originalSize$iv$iv;
                        for (byte$iv$iv = 0; byte$iv$iv < 3; ++byte$iv$iv) {
                            it$iv$iv = byte$iv$iv;
                            if (--size$iv$iv == 0L) break;
                            var5_15 = byte$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(size$iv$iv - 1L);
                            if ((byte$iv$iv & 192) == 128) continue;
                            v0 = byte$iv$iv >= 0 ? originalSize$iv$iv : ((((asInt$iv$iv$iv = byte$iv$iv) & 224) == 192 ? 1 : ((asInt$iv$iv$iv & 240) == 224 ? 2 : ((asInt$iv$iv$iv & 248) == 240 ? 3 : 0))) < it$iv$iv + 1 ? originalSize$iv$iv : size$iv$iv - 1L);
                            break;
                        }
                    } else lbl-1000:
                    // 4 sources

                    {
                        v0 = originalSize$iv$iv;
                    }
                }
                fullUtf8Size$iv = v0;
                buffer = $this$sizeOfFullValidUtf8String$iv$iv = $this$readUtf8WithLimit$iv.readUtf8(fullUtf8Size$iv);
                read = $this$sizeOfFullValidUtf8String$iv$iv.length();
                if (read > 0) {
                    cpIndex = this.dataLength - this.pointer;
                    this.codePointsWindow = dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.StreamReader$Companion.access$copyOfRangeSafe(StreamReader.Companion, this.codePointsWindow, this.pointer, this.dataLength + read);
                    nonPrintable = null;
                    i = 0;
                    while (i < read) {
                        this.codePointsWindow[cpIndex] = codePoint = CharSequenceExtensionsKt.codePointAt(buffer, i);
                        if (dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.StreamReader$Companion.isPrintable(codePoint)) {
                            i += Character.charCount$snakeyaml_engine_kmp(codePoint);
                        } else {
                            nonPrintable = codePoint;
                            i = read;
                        }
                        ++cpIndex;
                    }
                    this.dataLength = cpIndex;
                    this.pointer = 0;
                    if (nonPrintable != null) {
                        throw new ReaderException(this.name, (int)(var3_5 - true), nonPrintable, "special characters are not allowed");
                    }
                    break block10;
                }
                this.eof = true;
                return;
            }
            catch (IOException ioe) {
                throw new YamlEngineException((Throwable)var1_10);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void moveIndices(int length) {
        void var1_1;
        this.index += length;
        this.documentIndex += var1_1;
    }

    public final void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Ldev/rvbsm/fsit/lib/snakeyaml-kmp/scanner/StreamReader$Companion;", "", "<init>", "()V", "", "c", "", "isPrintable", "(I)Z"})
    @SourceDebugExtension(value={"SMAP\nStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static boolean isPrintable(int c) {
            block4: {
                block3: {
                    int n;
                    if ((32 <= c ? c < 127 : false) || c == 9 || c == 10 || c == 13 || c == 133) break block3;
                    if (160 <= c ? c < 55296 : false) break block3;
                    if (57344 <= c ? c < 65534 : false) break block3;
                    boolean bl = 65536 <= c ? n < 0x110000 : false;
                    if (!bl) break block4;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ int[] access$copyOfRangeSafe(Companion $this, int[] $receiver, int fromIndex, int toIndex) {
            int n;
            int n2;
            void v0 = n2;
            n2 = n;
            void var1_2 = v0;
            Object object = $receiver;
            int[] nArray = new int[n2 -= var1_2];
            for (n = 0; n < n2; ++n) {
                Object object2;
                int n3 = n;
                int[] nArray2 = nArray;
                int n4 = n3;
                Object object3 = object;
                boolean bl = (n3 = var1_2 + n3) >= 0 ? n3 < ((Object)object3).length : false;
                if (bl) {
                    object2 = object3[n3];
                } else {
                    int[] nArray3;
                    int n5 = n4;
                    nArray2 = nArray3 = nArray2;
                    n4 = n5;
                    object2 = false;
                }
                nArray2[n4] = (int)object2;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

