package dev.rvbsm.fsit.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import dev.rvbsm.fsit.api.event.ClientCommandCallback;
import dev.rvbsm.fsit.api.event.PassedUseBlockCallback;
import dev.rvbsm.fsit.api.event.PassedUseEntityCallback;
import dev.rvbsm.fsit.api.network.RidingRequestHandler;
import dev.rvbsm.fsit.networking.payload.RidingResponseC2SPayload;

import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_2848;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin implements RidingRequestHandler {

    @Unique
    private final Map<UUID, CompletableFuture<Boolean>> pendingRidingRequests = new WeakHashMap<>();
    @Shadow
    public class_3222 player;

    @Inject(method = "onClientCommand", at = @At("TAIL"))
    public void onClientCommand(@NotNull class_2848 packet, CallbackInfo ci) {
        ClientCommandCallback.EVENT.invoker().process(this.player, packet.method_12365());
    }

    @ModifyVariable(method = "onPlayerInteractBlock", at = @At("STORE"))
    private class_1269 interactBlock(
        class_1269 interactionActionResult,
        @Local class_3218 world,
        @Local LocalRef<class_1268> handRef,
        @Local class_3965 blockHitResult
    ) {
        if (interactionActionResult == class_1269.field_5811 &&
            handRef.get() == class_1268.field_5810 &&
            player.method_5998(handRef.get()).method_7976().ordinal() == 0) {
            handRef.set(class_1268.field_5808);

            return PassedUseBlockCallback.EVENT.invoker().interact(player, world, blockHitResult);
        }

        return interactionActionResult;
    }

    @Inject(method = "onDisconnected", at = @At("TAIL"))
    public void purgePendingRequests(CallbackInfo ci) {
        this.pendingRidingRequests.forEach((uuid, future) -> future.complete(false));
        this.pendingRidingRequests.clear();
    }

    @Override
    public @NotNull CompletableFuture<Boolean> fsit$newRidingRequest(
        @NotNull UUID playerUUID,
        @NotNull Duration timeout
    ) {
        final CompletableFuture<Boolean> pendingFuture = this.pendingRidingRequests.get(playerUUID);
        if (pendingFuture != null && !pendingFuture.isDone()) {
            return CompletableFuture.completedFuture(false);
        }

        final CompletableFuture<Boolean> ridingResponse = new CompletableFuture<Boolean>().completeOnTimeout(
            false,
            timeout.toMillis(),
            TimeUnit.MILLISECONDS);
        this.pendingRidingRequests.put(playerUUID, ridingResponse);

        return ridingResponse;
    }

    @Override
    public void fsit$completeRidingRequest(@NotNull RidingResponseC2SPayload response) {
        final CompletableFuture<Boolean> future = this.pendingRidingRequests.remove(response.getUuid());
        if (future != null && !future.isDone()) {
            future.complete(response.getResponse().isAccepted());
        }
    }

    @Mixin(targets = "net.minecraft.server.network.ServerPlayNetworkHandler$1")
    public abstract static class PlayerInteractEntityC2SPacketHandler {
        @Shadow
        @Final
        class_3244 field_28963;

        @Shadow
        @Final
        class_1297 field_28962;

        @Shadow
        @Final
        class_3218 field_39991;

        @ModifyVariable(method = "processInteract", at = @At("STORE"))
        private class_1269 interactPlayer(
            class_1269 interactionActionResult,
            @Local(argsOnly = true) LocalRef<class_1268> handRef
        ) {
            if (interactionActionResult == class_1269.field_5811 &&
                handRef.get() == class_1268.field_5810 &&
                field_28963.field_14140.method_5998(handRef.get()).method_7976().ordinal() == 0) {
                handRef.set(class_1268.field_5808);

                return PassedUseEntityCallback.EVENT.invoker().interact(field_28963.field_14140, field_39991, field_28962);
            }

            return interactionActionResult;
        }
    }
}
