package dev.rvbsm.fsit.mixin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import dev.rvbsm.fsit.api.player.PlayerPose;
import dev.rvbsm.fsit.entity.ModPose;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_4050;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends LivingEntityMixin implements PlayerPose {

    @Unique
    protected @NotNull ModPose modPose = ModPose.Standing;

    @Unique
    private @Nullable ModPose prevModPose = null;

    @Shadow
    public abstract class_1656 getAbilities();

    @ModifyArg(
        method = "updatePose",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/player/PlayerEntity;setPose(Lnet/minecraft/entity/EntityPose;)V"))
    private class_4050 isCrawling(class_4050 pose) {
        return this.fsit$isInPose(ModPose.Crawling) ? class_4050.field_18079 : pose;
    }

    @Override
    public void fsit$setPose(@NotNull ModPose pose, @Nullable class_243 pos) {
        this.prevModPose = this.modPose;
        this.modPose = pose;
    }

    @Override
    public @NotNull ModPose fsit$getPose() {
        return this.modPose;
    }

    @Override
    public @Nullable ModPose fsit$getPrevPose() {
        return this.prevModPose;
    }
}
