/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.comments;

import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentLine;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentType;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.EventQueue;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.CommentEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.Event;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentEventsCollector {
    @NotNull
    private final EventQueue eventSource;
    @NotNull
    private final CommentType[] expectedCommentTypes;
    @NotNull
    private final List<CommentLine> commentLineList;

    /*
     * WARNING - void declaration
     */
    private CommentEventsCollector(EventQueue eventSource, CommentType[] expectedCommentTypes) {
        void var2_2;
        void var1_1;
        this.eventSource = var1_1;
        this.expectedCommentTypes = var2_2;
        this.commentLineList = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public CommentEventsCollector(@NotNull ArrayDeque<Event> eventSource, CommentType ... expectedCommentTypes) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)expectedCommentTypes, (String)"expectedCommentTypes");
        this(new EventQueue((ArrayDeque<Event>)var1_1), (CommentType[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEventExpected(Event event) {
        void var1_1;
        return event != null && event.getEventId() == Event.ID.Comment && event instanceof CommentEvent && ArraysKt.contains((Object[])this.expectedCommentTypes, (Object)((Object)((CommentEvent)var1_1).getCommentType()));
    }

    @NotNull
    public final CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Event collectEvents(@Nullable Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.commentLineList.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (true) {
            void var1_1;
            CommentEventsCollector commentEventsCollector = this;
            if (!commentEventsCollector.isEventExpected(commentEventsCollector.eventSource.peek())) break;
            Event e = this.eventSource.poll();
            Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.CommentEvent");
            this.commentLineList.add(new CommentLine((CommentEvent)var1_1));
        }
        return null;
    }

    @NotNull
    public final Event collectEventsAndPoll(@Nullable Event event) {
        Event event2;
        Event event3 = event2 = this.collectEvents(event2);
        if (event2 == null) {
            event3 = this.eventSource.poll();
        }
        return event3;
    }

    @NotNull
    public final List<CommentLine> consume() {
        List list;
        try {
            list = CollectionsKt.toList((Iterable)this.commentLineList);
        }
        finally {
            this.commentLineList.clear();
        }
        return list;
    }

    public final boolean isEmpty() {
        return this.commentLineList.isEmpty();
    }
}

