/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.okio;

import dev.rvbsm.fsit.lib.okio.-SegmentedByteString;
import dev.rvbsm.fsit.lib.okio.BufferedSink;
import dev.rvbsm.fsit.lib.okio.BufferedSource;
import dev.rvbsm.fsit.lib.okio.ByteString;
import dev.rvbsm.fsit.lib.okio.Segment;
import dev.rvbsm.fsit.lib.okio.SegmentPool;
import dev.rvbsm.fsit.lib.okio.SegmentedByteString;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nokio/Buffer\n+ 2 Util.kt\nokio/-SegmentedByteString\n+ 3 Buffer.kt\nokio/internal/-Buffer\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BufferedSource.kt\nokio/internal/-BufferedSource\n*L\n1#1,649:1\n88#2:650\n85#2:683\n85#2:685\n73#2:745\n73#2:771\n82#2:810\n76#2:821\n88#2:1014\n73#2:1029\n85#2:1133\n242#3,32:651\n277#3,10:686\n290#3,18:696\n412#3,2:714\n110#3:716\n414#3:717\n112#3,18:718\n311#3,9:736\n320#3,15:746\n338#3,10:761\n348#3,3:772\n346#3,25:775\n374#3,10:800\n384#3:811\n382#3,9:812\n391#3,7:822\n389#3,20:829\n652#3,60:849\n715#3,56:909\n773#3:965\n776#3:966\n777#3,6:968\n787#3,7:974\n797#3,6:984\n805#3,5:990\n837#3,6:995\n847#3:1001\n848#3,11:1003\n859#3,5:1015\n868#3,9:1020\n878#3,61:1030\n603#3:1091\n606#3:1092\n607#3,5:1094\n614#3:1099\n617#3,7:1100\n626#3,20:1107\n418#3:1127\n421#3,5:1128\n426#3,10:1134\n437#3,7:1144\n442#3,2:1151\n943#3:1153\n944#3,87:1155\n1034#3,48:1242\n573#3:1290\n580#3,21:1291\n1085#3,7:1312\n1095#3,7:1319\n1105#3,4:1326\n1112#3,8:1330\n1123#3,10:1338\n1136#3,14:1348\n447#3,35:1362\n513#3,40:1397\n556#3:1437\n558#3,13:1439\n1153#3:1452\n1204#3:1453\n1205#3,39:1455\n1246#3,2:1494\n1248#3,4:1497\n1255#3,3:1501\n1259#3,4:1505\n110#3:1509\n1263#3,22:1510\n112#3,18:1532\n1338#3,2:1550\n1341#3:1553\n110#3:1554\n1342#3,50:1555\n112#3,18:1605\n1401#3,12:1623\n1416#3,32:1635\n1451#3,12:1667\n1466#3,18:1679\n1488#3:1697\n1489#3:1699\n1494#3,34:1700\n1#4:684\n1#4:967\n1#4:1002\n1#4:1093\n1#4:1154\n1#4:1438\n1#4:1454\n1#4:1496\n1#4:1504\n1#4:1552\n1#4:1698\n26#5,3:981\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nokio/Buffer\n*L\n167#1:650\n197#1:683\n235#1:685\n261#1:745\n264#1:771\n267#1:810\n267#1:821\n337#1:1014\n340#1:1029\n376#1:1133\n181#1:651,32\n252#1:686,10\n255#1:696,18\n258#1:714,2\n258#1:716\n258#1:717\n258#1:718,18\n261#1:736,9\n261#1:746,15\n264#1:761,10\n264#1:772,3\n264#1:775,25\n267#1:800,10\n267#1:811\n267#1:812,9\n267#1:822,7\n267#1:829,20\n279#1:849,60\n282#1:909,56\n284#1:965\n287#1:966\n287#1:968,6\n289#1:974,7\n294#1:984,6\n297#1:990,5\n331#1:995,6\n337#1:1001\n337#1:1003,11\n337#1:1015,5\n340#1:1020,9\n340#1:1030,61\n342#1:1091\n345#1:1092\n345#1:1094,5\n347#1:1099\n350#1:1100,7\n353#1:1107,20\n373#1:1127\n376#1:1128,5\n376#1:1134,10\n378#1:1144,7\n381#1:1151,2\n386#1:1153\n386#1:1155,87\n389#1:1242,48\n412#1:1290\n418#1:1291,21\n439#1:1312,7\n443#1:1319,7\n445#1:1326,4\n447#1:1330,8\n451#1:1338,10\n455#1:1348,14\n459#1:1362,35\n462#1:1397,40\n465#1:1437\n465#1:1439,13\n467#1:1452\n467#1:1453\n467#1:1455,39\n469#1:1494,2\n469#1:1497,4\n480#1:1501,3\n480#1:1505,4\n480#1:1509\n480#1:1510,22\n480#1:1532,18\n496#1:1550,2\n496#1:1553\n496#1:1554\n496#1:1555,50\n496#1:1605,18\n506#1:1623,12\n576#1:1635,32\n578#1:1667,12\n586#1:1679,18\n594#1:1697\n594#1:1699\n596#1:1700,34\n287#1:967\n337#1:1002\n345#1:1093\n386#1:1154\n465#1:1438\n467#1:1454\n469#1:1496\n480#1:1504\n496#1:1552\n594#1:1698\n291#1:981,3\n*E\n"})
public final class Buffer
implements BufferedSink,
BufferedSource,
Cloneable,
ByteChannel {
    @JvmField
    @Nullable
    public Segment head;
    private long size;

    @JvmName(name="size")
    public final long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSize$okio(long l) {
        void var1_1;
        this.size = var1_1;
    }

    @Override
    @NotNull
    public final Buffer getBuffer() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean request(long byteCount) {
        void var1_1;
        return this.size >= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="getByte")
    public final byte getByte(long pos) {
        void offset$iv;
        void var1_1;
        void var3_2;
        long nextOffset$iv$iv;
        Segment s$iv;
        Buffer $this$commonGet$iv;
        Buffer buffer = $this$commonGet$iv = this;
        -SegmentedByteString.checkOffsetAndCount($this$commonGet$iv.size, pos, 1L);
        Buffer $this$seek$iv$iv = $this$commonGet$iv;
        Segment segment = $this$seek$iv$iv.head;
        if (segment == null) {
            Intrinsics.checkNotNull(null);
            return null.data[(int)((long)null.pos + pos - -1L)];
        }
        Segment s$iv$iv = segment;
        buffer = $this$seek$iv$iv;
        if (buffer.size - pos < pos) {
            void offset$iv2;
            long offset$iv$iv;
            buffer = $this$seek$iv$iv;
            for (offset$iv$iv = buffer.size; offset$iv$iv > pos; offset$iv$iv -= (long)(s$iv$iv.limit - s$iv$iv.pos)) {
                Intrinsics.checkNotNull((Object)s$iv$iv.prev);
            }
            long l = offset$iv$iv;
            s$iv = s$iv$iv;
            Intrinsics.checkNotNull((Object)s$iv);
            return s$iv.data[(int)((long)s$iv.pos + pos - offset$iv2)];
        }
        long offset$iv$iv = 0L;
        while ((nextOffset$iv$iv = offset$iv$iv + (long)(s$iv$iv.limit - s$iv$iv.pos)) <= pos) {
            Intrinsics.checkNotNull((Object)s$iv$iv.next);
            offset$iv$iv = nextOffset$iv$iv;
        }
        long l = offset$iv$iv;
        s$iv = s$iv$iv;
        Intrinsics.checkNotNull((Object)s$iv);
        return s$iv.data[(int)((long)var3_2.pos + var1_1 - offset$iv)];
    }

    @NotNull
    public final String readUtf8() {
        Buffer buffer = this;
        return buffer.readString(buffer.size, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final String readUtf8(long byteCount) throws EOFException {
        void var1_1;
        return this.readString((long)var1_1, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private String readString(long byteCount, @NotNull Charset charset) throws EOFException {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            charset = "byteCount: " + byteCount;
            throw new IllegalArgumentException(charset.toString());
        }
        if (this.size < byteCount) {
            throw new EOFException();
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        if ((long)segment.pos + byteCount > (long)s.limit) {
            return new String(this.readByteArray(byteCount), (Charset)charset);
        }
        String result = new String(s.data, s.pos, (int)byteCount, (Charset)charset);
        s.pos += (int)byteCount;
        this.size -= var1_1;
        if (s.pos == s.limit) {
            this.head = s.pop();
            SegmentPool.recycle(s);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readByteArray() {
        void var1_1;
        Buffer $this$commonReadByteArray$iv = this;
        return $this$commonReadByteArray$iv.readByteArray(var1_1.size);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private byte[] readByteArray(long byteCount22) throws EOFException {
        void var1_3;
        void var3_4;
        long byteCount22;
        Buffer $this$commonReadByteArray$iv = this;
        if (!(byteCount22 >= 0L && byteCount22 <= Integer.MAX_VALUE)) {
            String byteCount22 = "byteCount: " + byteCount22;
            throw new IllegalArgumentException(byteCount22.toString());
        }
        Buffer buffer = $this$commonReadByteArray$iv;
        if (buffer.size < byteCount22) {
            throw new EOFException();
        }
        byte[] result$iv = new byte[(int)byteCount22];
        var3_4.readFully(result$iv);
        return var1_3;
    }

    private void readFully(@NotNull byte[] sink) throws EOFException {
        int read$iv;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Buffer $this$commonReadFully$iv = this;
        for (int offset$iv = 0; offset$iv < sink.length; offset$iv += read$iv) {
            read$iv = $this$commonReadFully$iv.read(sink, offset$iv, sink.length - offset$iv);
            if (read$iv != -1) continue;
            throw new EOFException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int read(@NotNull byte[] sink, int offset, int byteCount) {
        void var3_3;
        void var2_2;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Buffer $this$commonRead$iv = this;
        -SegmentedByteString.checkOffsetAndCount(sink.length, offset, byteCount);
        Segment segment = $this$commonRead$iv.head;
        if (segment == null) {
            return -1;
        }
        Segment s$iv = segment;
        int toCopy$iv = Math.min(byteCount, s$iv.limit - s$iv.pos);
        ArraysKt.copyInto((byte[])s$iv.data, (byte[])buffer, (int)var2_2, (int)s$iv.pos, (int)(s$iv.pos + toCopy$iv));
        s$iv.pos += toCopy$iv;
        Buffer buffer2 = $this$commonRead$iv;
        buffer = buffer2;
        long l = buffer2.size - (long)toCopy$iv;
        buffer = buffer2;
        buffer2.size = l;
        if (s$iv.pos == s$iv.limit) {
            $this$commonRead$iv.head = s$iv.pop();
            SegmentPool.recycle(s$iv);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(@NotNull ByteBuffer sink) throws IOException {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(sink.remaining(), s.limit - s.pos);
        var1_1.put(s.data, s.pos, toCopy);
        s.pos += toCopy;
        this.size -= (long)toCopy;
        if (s.pos == s.limit) {
            void var2_2;
            this.head = s.pop();
            SegmentPool.recycle((Segment)var2_2);
        }
        return (int)var3_3;
    }

    public final void clear() {
        Buffer buffer;
        Buffer $this$commonClear$iv = this;
        Buffer buffer2 = buffer;
        long l = buffer2.size;
        buffer = $this$commonClear$iv;
        buffer = $this$commonClear$iv;
        long l2 = l;
        while (l2 > 0L) {
            Segment segment;
            if (buffer.head == null) {
                throw new EOFException();
            }
            int n = segment.limit - segment.pos;
            n = (int)Math.min(l2, (long)n);
            Buffer buffer3 = buffer;
            buffer2 = buffer3;
            long l3 = buffer3.size - (long)n;
            buffer2 = buffer3;
            buffer3.size = l3;
            l2 -= (long)n;
            segment.pos += n;
            if (segment.pos != segment.limit) continue;
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    private Buffer writeUtf8(@NotNull String string, int beginIndex22, int endIndex) {
        int beginIndex22;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Buffer $this$commonWriteUtf8$iv = this;
        if (!(beginIndex22 >= 0)) {
            String beginIndex22 = "beginIndex < 0: " + beginIndex22;
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        if (!(endIndex >= beginIndex22)) {
            String beginIndex22 = "endIndex < beginIndex: " + endIndex + " < " + beginIndex22;
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        if (!(endIndex <= string.length())) {
            String beginIndex22 = "endIndex > string.length: " + endIndex + " > " + string.length();
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        int i$iv = beginIndex22;
        while (i$iv < endIndex) {
            char low$iv;
            long l;
            void var2_2;
            block12: {
                block11: {
                    char c$iv = string.charAt(i$iv);
                    if (c$iv < '\u0080') {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(1);
                        byte[] data$iv = ((Segment)tail$iv).data;
                        int segmentOffset$iv = ((Segment)tail$iv).limit - i$iv;
                        int runLimit$iv = Math.min(endIndex, 8192 - segmentOffset$iv);
                        data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        while (i$iv < runLimit$iv && (c$iv = string.charAt(i$iv)) < '\u0080') {
                            data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        }
                        int runSize$iv = i$iv + segmentOffset$iv - ((Segment)tail$iv).limit;
                        ((Segment)tail$iv).limit += runSize$iv;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + (long)var2_2;
                        tail$iv = buffer;
                        buffer.size = l;
                        continue;
                    }
                    if (var2_2 < 2048) {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(2);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit] = (byte)(var2_2 >> 6 | 0xC0);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 1] = (byte)(var2_2 & 0x3F | 0x80);
                        ((Segment)tail$iv).limit += 2;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + 2L;
                        tail$iv = buffer;
                        buffer.size = l;
                        ++i$iv;
                        continue;
                    }
                    if (var2_2 < 55296 || var2_2 > 57343) {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(3);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit] = (byte)(var2_2 >> 12 | 0xE0);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 1] = (byte)(var2_2 >> 6 & 0x3F | 0x80);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 2] = (byte)(var2_2 & 0x3F | 0x80);
                        ((Segment)tail$iv).limit += 3;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + 3L;
                        tail$iv = buffer;
                        buffer.size = l;
                        ++i$iv;
                        continue;
                    }
                    char c = low$iv = i$iv + 1 < endIndex ? string.charAt(i$iv + 1) : (char)'\u0000';
                    if (var2_2 > 56319) break block11;
                    if ('\udc00' <= low$iv ? low$iv < '\ue000' : false) break block12;
                }
                $this$commonWriteUtf8$iv.writeByte(63);
                ++i$iv;
                continue;
            }
            int codePoint$iv = 65536 + ((var2_2 & 0x3FF) << 10 | low$iv & 0x3FF);
            Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(4);
            tail$iv.data[tail$iv.limit] = (byte)(codePoint$iv >> 18 | 0xF0);
            tail$iv.data[tail$iv.limit + 1] = (byte)(codePoint$iv >> 12 & 0x3F | 0x80);
            tail$iv.data[tail$iv.limit + 2] = (byte)(codePoint$iv >> 6 & 0x3F | 0x80);
            tail$iv.data[tail$iv.limit + 3] = (byte)(codePoint$iv & 0x3F | 0x80);
            tail$iv.limit += 4;
            Buffer buffer = $this$commonWriteUtf8$iv;
            Buffer buffer2 = buffer;
            l = buffer.size + 4L;
            buffer2 = buffer;
            buffer.size = l;
            i$iv += 2;
        }
        return $this$commonWriteUtf8$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Buffer write(@NotNull byte[] source, int offset, int byteCount) {
        void var3_3;
        void offset$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer $this$commonWrite$iv = this;
        -SegmentedByteString.checkOffsetAndCount(source.length, (long)offset$iv, byteCount);
        void limit$iv = offset$iv + byteCount;
        while (offset$iv < limit$iv) {
            Segment tail$iv = $this$commonWrite$iv.writableSegment$okio(1);
            int toCopy$iv = Math.min((int)(limit$iv - offset$iv), 8192 - tail$iv.limit);
            void v0 = offset$iv;
            ArraysKt.copyInto((byte[])source, (byte[])tail$iv.data, (int)tail$iv.limit, (int)v0, (int)(v0 + toCopy$iv));
            offset$iv += toCopy$iv;
            tail$iv.limit += toCopy$iv;
        }
        Buffer buffer = $this$commonWrite$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + (long)var3_3;
        buffer2 = buffer;
        buffer.size = l;
        return $this$commonWrite$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int write(@NotNull ByteBuffer source) throws IOException {
        void var2_2;
        int byteCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int remaining = byteCount = source.remaining();
        while (remaining > 0) {
            Segment tail = this.writableSegment$okio(1);
            int toCopy = Math.min(remaining, 8192 - tail.limit);
            source.get(tail.data, tail.limit, toCopy);
            remaining -= toCopy;
            tail.limit += toCopy;
        }
        this.size += (long)byteCount;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Buffer writeByte(int b) {
        void var2_3;
        void var1_1;
        Buffer $this$commonWriteByte$iv = this;
        Segment tail$iv = $this$commonWriteByte$iv.writableSegment$okio(1);
        int n = tail$iv.limit;
        var3_4.limit = n + 1;
        tail$iv.data[n] = (byte)var1_1;
        Buffer buffer = $this$commonWriteByte$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + 1L;
        buffer2 = buffer;
        buffer.size = l;
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Segment writableSegment$okio(int minimumCapacity2) {
        void var3_4;
        Buffer $this$commonWritableSegment$iv = this;
        if (!(minimumCapacity2 > 0 && minimumCapacity2 <= 8192)) {
            String minimumCapacity2 = "unexpected capacity";
            throw new IllegalArgumentException(minimumCapacity2.toString());
        }
        if ($this$commonWritableSegment$iv.head == null) {
            Segment result$iv;
            $this$commonWritableSegment$iv.head = result$iv = SegmentPool.take();
            result$iv.prev = result$iv;
            result$iv.next = result$iv;
        } else {
            void var1_1;
            void var2_3;
            Segment segment = var2_3.head;
            Intrinsics.checkNotNull((Object)segment);
            Segment tail$iv = segment.prev;
            Intrinsics.checkNotNull((Object)tail$iv);
            if (tail$iv.limit + var1_1 > 8192 || !tail$iv.owner) {
                tail$iv = tail$iv.push(SegmentPool.take());
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(@NotNull Buffer sink, long byteCount) {
        long l;
        void var13_10;
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Buffer $this$commonRead$iv = this;
        long byteCount$iv = var2_2;
        if (!(byteCount$iv >= 0L)) {
            sink = "byteCount < 0: " + byteCount$iv;
            throw new IllegalArgumentException(sink.toString());
        }
        Object object = $this$commonRead$iv;
        if (((Buffer)object).size == 0L) {
            return -1L;
        }
        object = $this$commonRead$iv;
        if (byteCount$iv > ((Buffer)object).size) {
            object = $this$commonRead$iv;
            byteCount$iv = ((Buffer)object).size;
        }
        void var10_9 = byteCount$iv;
        Buffer buffer = $this$commonRead$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"source");
        if (!(buffer != string)) {
            string = "source == this";
            throw new IllegalArgumentException(string.toString());
        }
        object = buffer;
        -SegmentedByteString.checkOffsetAndCount(((Buffer)object).size, 0L, (long)var13_10);
        for (var13_10 = var10_9; var13_10 > 0L; var13_10 -= l) {
            Object object2;
            long l2;
            Segment segment = buffer.head;
            Intrinsics.checkNotNull((Object)segment);
            int n = segment.limit;
            Segment segment2 = buffer.head;
            Intrinsics.checkNotNull((Object)segment2);
            if (var13_10 < (long)(n - segment2.pos)) {
                Object object3;
                if (((Buffer)((Object)string)).head != null) {
                    Segment segment3 = ((Buffer)((Object)string)).head;
                    Intrinsics.checkNotNull((Object)segment3);
                    object3 = segment3.prev;
                } else {
                    object3 = object = null;
                }
                if (object3 != null && ((Segment)object).owner && var13_10 + (long)((Segment)object).limit - (long)(((Segment)object).shared ? 0 : ((Segment)object).pos) <= 8192L) {
                    Segment segment4 = buffer.head;
                    Intrinsics.checkNotNull((Object)segment4);
                    segment4.writeTo((Segment)object, (int)var13_10);
                    Buffer buffer2 = buffer;
                    object = buffer2;
                    l2 = buffer2.size - var13_10;
                    object = buffer2;
                    buffer2.size = l2;
                    String string2 = string;
                    object = string2;
                    l2 = ((Buffer)((Object)string2)).size + var13_10;
                    object = string2;
                    ((Buffer)((Object)string2)).size = l2;
                    break;
                }
                Segment segment5 = buffer.head;
                Intrinsics.checkNotNull((Object)segment5);
                int n2 = (int)var13_10;
                object = segment5;
                if (!(n2 > 0 && n2 <= ((Segment)object).limit - ((Segment)object).pos)) {
                    string = "byteCount out of range";
                    throw new IllegalArgumentException(string.toString());
                }
                if (n2 >= 1024) {
                    object2 = ((Segment)object).sharedCopy();
                } else {
                    object2 = SegmentPool.take();
                    ArraysKt.copyInto$default((byte[])((Segment)object).data, (byte[])((Segment)object2).data, (int)0, (int)((Segment)object).pos, (int)(((Segment)object).pos + n2), (int)2, null);
                }
                ((Segment)object2).limit = ((Segment)object2).pos + n2;
                ((Segment)object).pos += n2;
                Segment segment6 = ((Segment)object).prev;
                Intrinsics.checkNotNull((Object)segment6);
                segment6.push((Segment)object2);
                buffer.head = object2;
            }
            object = buffer.head;
            Intrinsics.checkNotNull((Object)object);
            l = ((Segment)object).limit - ((Segment)object).pos;
            buffer.head = ((Segment)object).pop();
            if (((Buffer)((Object)string)).head == null) {
                ((Buffer)((Object)string)).head = object;
                ((Segment)object).prev = object;
                ((Segment)object).next = ((Segment)object).prev;
            } else {
                Segment segment7 = ((Buffer)((Object)string)).head;
                Intrinsics.checkNotNull((Object)segment7);
                Segment segment8 = segment7.prev;
                Intrinsics.checkNotNull((Object)segment8);
                segment8 = segment8.push((Segment)object);
                object = segment8;
                if (!(segment8.prev != object)) {
                    object2 = "cannot compact";
                    throw new IllegalStateException(object2.toString());
                }
                Segment segment9 = ((Segment)object).prev;
                Intrinsics.checkNotNull((Object)segment9);
                if (segment9.owner) {
                    int n3;
                    int n4 = ((Segment)object).limit - ((Segment)object).pos;
                    Segment segment10 = ((Segment)object).prev;
                    Intrinsics.checkNotNull((Object)segment10);
                    int n5 = 8192 - segment10.limit;
                    Segment segment11 = ((Segment)object).prev;
                    Intrinsics.checkNotNull((Object)segment11);
                    if (segment11.shared) {
                        n3 = 0;
                    } else {
                        Segment segment12 = ((Segment)object).prev;
                        Intrinsics.checkNotNull((Object)segment12);
                        n3 = segment12.pos;
                    }
                    int n6 = n5 + n3;
                    if (n4 <= n6) {
                        Object object4 = object;
                        Segment segment13 = ((Segment)object4).prev;
                        Intrinsics.checkNotNull((Object)segment13);
                        ((Segment)object4).writeTo(segment13, n4);
                        ((Segment)object).pop();
                        SegmentPool.recycle((Segment)object);
                    }
                }
            }
            Buffer buffer3 = buffer;
            object = buffer3;
            l2 = buffer3.size - l;
            object = buffer3;
            buffer3.size = l2;
            String string3 = string;
            object = string3;
            l2 = ((Buffer)((Object)string3)).size + l;
            object = string3;
            ((Buffer)((Object)string3)).size = l2;
        }
        return byteCount$iv;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final void close() {
    }

    public final boolean equals(@Nullable Object other) {
        Buffer $this$commonEquals$iv = this;
        if ($this$commonEquals$iv != other) {
            if (!(other instanceof Buffer)) {
                return false;
            }
            Buffer buffer = $this$commonEquals$iv;
            Buffer buffer2 = buffer;
            buffer2 = (Buffer)other;
            if (buffer.size != buffer2.size) {
                return false;
            }
            buffer2 = $this$commonEquals$iv;
            if (buffer2.size != 0L) {
                Segment segment = $this$commonEquals$iv.head;
                Intrinsics.checkNotNull((Object)segment);
                Segment sa$iv = segment;
                Segment segment2 = ((Buffer)other).head;
                Intrinsics.checkNotNull((Object)segment2);
                Segment sb$iv = segment2;
                int posA$iv = sa$iv.pos;
                int posB$iv = sb$iv.pos;
                long pos$iv = 0L;
                while (true) {
                    buffer2 = $this$commonEquals$iv;
                    if (pos$iv >= buffer2.size) break;
                    long count$iv = Math.min(sa$iv.limit - posA$iv, sb$iv.limit - posB$iv);
                    long l = count$iv;
                    for (long i$iv = 0L; i$iv < l; ++i$iv) {
                        if (sa$iv.data[posA$iv++] == sb$iv.data[posB$iv++]) continue;
                        return false;
                    }
                    if (posA$iv == sa$iv.limit) {
                        Intrinsics.checkNotNull((Object)sa$iv.next);
                        posA$iv = sa$iv.pos;
                    }
                    if (posB$iv == sb$iv.limit) {
                        Intrinsics.checkNotNull((Object)sb$iv.next);
                        posB$iv = sb$iv.pos;
                    }
                    pos$iv += count$iv;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        Buffer $this$commonHashCode$iv = this;
        Segment segment = $this$commonHashCode$iv.head;
        if (segment == null) {
            return 0;
        }
        Segment s$iv = segment;
        int result$iv = 1;
        do {
            int limit$iv = s$iv.limit;
            for (int pos$iv = s$iv.pos; pos$iv < limit$iv; ++pos$iv) {
                result$iv = result$iv * 31 + s$iv.data[pos$iv];
            }
            Intrinsics.checkNotNull((Object)s$iv.next);
        } while (s$iv != $this$commonHashCode$iv.head);
        return (int)var3_3;
    }

    @NotNull
    public final String toString() {
        ByteString byteString;
        Buffer buffer = this;
        Object object = buffer;
        object = buffer;
        Object object2 = buffer;
        if (!(buffer.size <= Integer.MAX_VALUE)) {
            object2 = object;
            object = "size > Int.MAX_VALUE: " + ((Buffer)object2).size;
            throw new IllegalStateException(object.toString());
        }
        object2 = object;
        int n = (int)((Buffer)object2).size;
        object = object2;
        object = object2;
        if (n == 0) {
            byteString = ByteString.EMPTY;
        } else {
            object2 = object;
            -SegmentedByteString.checkOffsetAndCount(((Buffer)object2).size, 0L, n);
            int n2 = 0;
            int n3 = 0;
            Segment segment = ((Buffer)object).head;
            while (n2 < n) {
                Segment segment2 = segment;
                Intrinsics.checkNotNull((Object)segment2);
                if (segment2.limit == segment.pos) {
                    throw new AssertionError((Object)"s.limit == s.pos");
                }
                n2 += segment.limit - segment.pos;
                ++n3;
                segment = segment.next;
            }
            byte[][] byArrayArray = new byte[n3][];
            int[] nArray = new int[n3 << 1];
            n2 = 0;
            n3 = 0;
            segment = ((Buffer)object).head;
            while (n2 < n) {
                Segment segment3 = segment;
                Intrinsics.checkNotNull((Object)segment3);
                byArrayArray[n3] = segment3.data;
                nArray[n3] = Math.min(n2 += segment.limit - segment.pos, n);
                nArray[n3 + ((Object[])byArrayArray).length] = segment.pos;
                segment.shared = true;
                ++n3;
                segment = segment.next;
            }
            byteString = new SegmentedByteString(byArrayArray, nArray);
        }
        return byteString.toString();
    }

    @SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nokio/Buffer$UnsafeCursor\n+ 2 Buffer.kt\nokio/internal/-Buffer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,649:1\n1549#2:650\n1550#2:652\n1554#2:653\n1555#2,68:655\n1626#2:723\n1627#2,32:725\n1659#2,18:758\n1680#2:776\n1681#2,18:778\n1703#2:796\n1705#2,7:798\n1#3:651\n1#3:654\n1#3:724\n1#3:777\n1#3:797\n85#4:757\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nokio/Buffer$UnsafeCursor\n*L\n636#1:650\n636#1:652\n638#1:653\n638#1:655,68\n640#1:723\n640#1:725,32\n640#1:758,18\n642#1:776\n642#1:778,18\n645#1:796\n645#1:798,7\n636#1:651\n638#1:654\n640#1:724\n642#1:777\n645#1:797\n640#1:757\n*E\n"})
    public static final class UnsafeCursor
    implements Closeable {
        @JvmField
        @Nullable
        private Buffer buffer;
        @JvmField
        private long offset = -1L;
        @JvmField
        private int start = -1;
        @JvmField
        private int end = -1;

        @Override
        public final void close() {
            Object object = this;
            Buffer cfr_ignored_0 = ((UnsafeCursor)object).buffer;
            object = "not attached to a buffer";
            throw new IllegalStateException(object.toString());
        }
    }
}

