/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner;

import dev.rvbsm.fsit.lib.okio.Buffer;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.LoadSettings;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.comments.CommentType;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.Anchor;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.CharConstants;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.ScalarStyle;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.UriEncoder;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.Mark;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.ScannerException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.YamlEngineException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.BreakIntentHolder;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.Chomping;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.Scanner;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.ScannerImplKt;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.SimpleKey;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.scanner.StreamReader;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.AliasToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.AnchorToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.BlockEndToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.BlockEntryToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.BlockMappingStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.BlockSequenceStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.CommentToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.DirectiveToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.DocumentEndToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.DocumentStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.FlowEntryToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.FlowMappingEndToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.FlowMappingStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.FlowSequenceEndToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.FlowSequenceStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.KeyToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.ScalarToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.StreamEndToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.StreamStartToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.TagToken;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.TagTuple;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.Token;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.tokens.ValueToken;
import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nScannerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScannerImpl.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2308:1\n774#2:2309\n865#2,2:2310\n*S KotlinDebug\n*F\n+ 1 ScannerImpl.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl\n*L\n2205#1:2309\n2205#1:2310,2\n*E\n"})
public final class ScannerImpl
implements Scanner {
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final StreamReader reader;
    @NotNull
    private final ArrayDeque<Token> tokens;
    @NotNull
    private final ArrayDeque<Integer> indents;
    @NotNull
    private final Map<Integer, SimpleKey> possibleSimpleKeys;
    private boolean done;
    private int flowLevel;
    @Nullable
    private Token lastToken;
    private int tokensTaken;
    private int indent;
    private boolean allowSimpleKey;
    @NotNull
    private static final Regex NOT_HEXA;

    public ScannerImpl(@NotNull LoadSettings settings, @NotNull StreamReader reader) {
        Object object;
        ScannerImpl scannerImpl;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.settings = scannerImpl;
        this.reader = object;
        this.tokens = new ArrayDeque(100);
        this.indents = new ArrayDeque(10);
        this.possibleSimpleKeys = new LinkedHashMap();
        this.indent = -1;
        this.allowSimpleKey = true;
        scannerImpl = this;
        object = scannerImpl.reader.getMark();
        Mark mark = object;
        object = new StreamStartToken(mark, mark);
        scannerImpl.addToken((Token)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean checkToken(@NotNull Token.ID choice) {
        Intrinsics.checkNotNullParameter((Object)((Object)choice), (String)"choice");
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            void var1_1;
            return ((Token)this.tokens.get(0)).getTokenId() == var1_1;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean checkToken(Token.ID ... choices) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)choices, (String)"choices");
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        Token token = (Token)this.tokens.firstOrNull();
        Token.ID firstTokenId = token != null ? token.getTokenId() : null;
        return firstTokenId != null && (choices.length == 0 || ArraysKt.contains((Object[])var1_1, (Object)var2_2));
    }

    @Override
    @NotNull
    public final Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return (Token)this.tokens.first();
    }

    @Override
    public final boolean hasNext() {
        return this.checkToken(new Token.ID[0]);
    }

    @Override
    @NotNull
    public final Token next() {
        int n = this.tokensTaken;
        this.tokensTaken = n + 1;
        Token token = (Token)this.tokens.removeFirstOrNull();
        if (token == null) {
            throw new NoSuchElementException("No more Tokens found.");
        }
        return token;
    }

    @Override
    public final void resetDocumentIndex() {
        this.reader.resetDocumentIndex();
    }

    /*
     * WARNING - void declaration
     */
    private final void addToken(Token token) {
        void var1_1;
        this.lastToken = token;
        this.tokens.addLast((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void addToken(int index, Token token) {
        void var2_2;
        void var1_1;
        if (index == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add((int)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addAllTokens(List<? extends Token> tokens) {
        void var1_1;
        this.lastToken = (Token)CollectionsKt.last(tokens);
        CollectionsKt.addAll((Collection)((Collection)this.tokens), (Iterable)((Iterable)var1_1));
    }

    private final boolean isBlockContext() {
        return this.flowLevel == 0;
    }

    private final boolean isFlowContext() {
        return !this.isBlockContext();
    }

    private final boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        Integer n = this.nextPossibleSimpleKey();
        int n2 = this.tokensTaken;
        return n != null && n == n2;
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchMoreTokens() {
        Mark mark;
        void var1_1;
        if (this.reader.getDocumentIndex() > this.settings.codePointLimit) {
            throw new YamlEngineException("The incoming YAML document exceeds the limit: " + this.settings.codePointLimit + " code points.");
        }
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        ScannerImpl scannerImpl = this;
        scannerImpl.unwindIndent(scannerImpl.reader.getColumn());
        int c2 = this.reader.peek();
        if (c2 == 0) {
            this.fetchStreamEnd();
            return;
        }
        switch ((char)c2) {
            case '%': {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case '-': {
                if (this.checkDocumentStart()) {
                    ScannerImpl c2 = this;
                    c2.fetchDocumentIndicator(true);
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case '.': {
                if (!this.checkDocumentEnd()) break;
                ScannerImpl c2 = this;
                c2.fetchDocumentIndicator(false);
                return;
            }
            case '[': {
                ScannerImpl c2 = this;
                c2.fetchFlowCollectionStart(false);
                return;
            }
            case '{': {
                ScannerImpl c2 = this;
                c2.fetchFlowCollectionStart(true);
                return;
            }
            case ']': {
                ScannerImpl c2 = this;
                c2.fetchFlowCollectionEnd(false);
                return;
            }
            case '}': {
                ScannerImpl c2 = this;
                c2.fetchFlowCollectionEnd(true);
                return;
            }
            case ',': {
                this.fetchFlowEntry();
                return;
            }
            case '?': {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case ':': {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case '*': {
                this.fetchAlias();
                return;
            }
            case '&': {
                this.fetchAnchor();
                return;
            }
            case '!': {
                this.fetchTag();
                return;
            }
            case '|': {
                if (!this.isBlockContext()) break;
                ScannerImpl c2 = this;
                c2.fetchBlockScalar(ScalarStyle.LITERAL);
                return;
            }
            case '>': {
                if (!this.isBlockContext()) break;
                ScannerImpl c2 = this;
                c2.fetchBlockScalar(ScalarStyle.FOLDED);
                return;
            }
            case '\'': {
                ScannerImpl c2 = this;
                c2.fetchFlowScalar(ScalarStyle.SINGLE_QUOTED);
                return;
            }
            case '\"': {
                ScannerImpl c2 = this;
                c2.fetchFlowScalar(ScalarStyle.DOUBLE_QUOTED);
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String chRepresentation = CharConstants.Companion.escapeChar(ArraysKt.first((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c2)));
        if (var1_1 == 9) {
            chRepresentation = chRepresentation + "(TAB)";
        }
        String string = "found character '" + chRepresentation + "' that cannot start any token. (Do not use " + (String)((Object)mark) + " for indentation)";
        mark = this.reader.getMark();
        throw new ScannerException(string, mark, "while scanning for the next token", null, null, 16);
    }

    private final Integer nextPossibleSimpleKey() {
        SimpleKey simpleKey = (SimpleKey)CollectionsKt.firstOrNull((Iterable)this.possibleSimpleKeys.values());
        if (simpleKey != null) {
            return simpleKey.getTokenNumber();
        }
        return null;
    }

    private final void stalePossibleSimpleKeys() {
        Object iterator = this.possibleSimpleKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            SimpleKey key = iterator.next().getValue();
            if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
            if (key.isRequired()) {
                Mark mark;
                iterator = ((SimpleKey)((Object)mark)).getMark();
                mark = this.reader.getMark();
                throw new ScannerException("could not find expected ':'", mark, "while scanning a simple key", (Mark)iterator, null, 16);
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.isBlockContext() && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new YamlEngineException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            void var1_2;
            void var2_3;
            this.removePossibleSimpleKey();
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey((int)var2_3, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, (SimpleKey)var1_2);
        }
    }

    private final void removePossibleSimpleKey() {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            Mark mark;
            mark = ((SimpleKey)((Object)mark)).getMark();
            Mark mark2 = this.reader.getMark();
            throw new ScannerException("could not find expected ':'", mark2, "while scanning a simple key", mark, null, 16);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void unwindIndent(int col) {
        if (this.isFlowContext()) {
            return;
        }
        while (this.indent > col) {
            void var2_2;
            Mark mark = this.reader.getMark();
            this.indent = ((Number)this.indents.removeLast()).intValue();
            void v0 = var2_2;
            this.addToken(new BlockEndToken((Mark)v0, (Mark)v0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addIndent(int column) {
        void var1_1;
        if (this.indent >= column) {
            return false;
        }
        this.indents.addLast((Object)this.indent);
        this.indent = var1_1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchStreamEnd() {
        void var1_1;
        Mark mark;
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        Mark mark2 = mark = this.reader.getMark();
        Token token = new StreamEndToken(mark2, mark2);
        this.addToken((Token)var1_1);
        this.done = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchDirective() {
        void var1_1;
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        List<Token> tok = this.scanDirective();
        this.addAllTokens((List<? extends Token>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchDocumentIndicator(boolean isDocumentStart) {
        void var1_2;
        void var3_4;
        void var2_3;
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        this.reader.forward(3);
        Mark endMark = this.reader.getMark();
        Token token = isDocumentStart ? (Token)new DocumentStartToken(startMark, endMark) : (Token)new DocumentEndToken((Mark)var2_3, (Mark)var3_4);
        this.addToken((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchFlowCollectionStart(boolean isMappingStart) {
        void var1_2;
        void var3_5;
        void var2_4;
        this.savePossibleSimpleKey();
        int n = this.flowLevel;
        this.flowLevel = n + 1;
        this.allowSimpleKey = true;
        Mark startMark = this.reader.getMark();
        this.reader.forward(1);
        Mark endMark = this.reader.getMark();
        Token token = isMappingStart ? (Token)new FlowMappingStartToken(startMark, endMark) : (Token)new FlowSequenceStartToken((Mark)var2_4, (Mark)var3_5);
        this.addToken((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchFlowCollectionEnd(boolean isMappingEnd) {
        void var1_2;
        void var3_5;
        void var2_4;
        this.removePossibleSimpleKey();
        int n = this.flowLevel;
        this.flowLevel = n + -1;
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        Token token = isMappingEnd ? (Token)new FlowMappingEndToken(startMark, endMark) : (Token)new FlowSequenceEndToken((Mark)var2_4, (Mark)var3_5);
        this.addToken((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchFlowEntry() {
        void var1_1;
        void var2_2;
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        FlowEntryToken token = new FlowEntryToken(startMark, (Mark)var2_2);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchBlockEntry() {
        void var1_1;
        void var2_2;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("", null, "sequence entries are not allowed here", this.reader.getMark(), null, 16);
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                Mark mark;
                Mark mark2 = mark = this.reader.getMark();
                this.addToken(new BlockSequenceStartToken(mark2, mark2));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        Token token = new BlockEntryToken(startMark, (Mark)var2_2);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchKey() {
        void var1_1;
        void var2_2;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("mapping keys are not allowed here", this.reader.getMark(), null, null, null, 28);
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                Mark mark;
                Mark mark2 = mark = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(mark2, mark2));
            }
        }
        this.allowSimpleKey = this.isBlockContext();
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        Token token = new KeyToken(startMark, (Mark)var2_2);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchValue() {
        void var1_1;
        void var2_2;
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null) {
            this.addToken(key.getTokenNumber() - this.tokensTaken, new KeyToken(key.getMark(), key.getMark()));
            if (this.isBlockContext() && this.addIndent(key.getColumn())) {
                this.addToken(key.getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(key.getMark(), key.getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.isBlockContext() && !this.allowSimpleKey) {
                throw new ScannerException("mapping values are not allowed here", this.reader.getMark(), null, null, null, 28);
            }
            if (this.isBlockContext()) {
                ScannerImpl scannerImpl = this;
                if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                    Mark mark;
                    Mark mark2 = mark = this.reader.getMark();
                    this.addToken(new BlockMappingStartToken(mark2, mark2));
                }
            }
            this.allowSimpleKey = this.isBlockContext();
            this.removePossibleSimpleKey();
        }
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        Token token = new ValueToken(startMark, (Mark)var2_2);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchAlias() {
        void var1_1;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(false);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchAnchor() {
        void var1_1;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(true);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchTag() {
        void var1_1;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchBlockScalar(ScalarStyle style) {
        void var1_1;
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        List<Token> tok = this.scanBlockScalar(style);
        this.addAllTokens((List<? extends Token>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchFlowScalar(ScalarStyle style) {
        void var1_1;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        ScalarStyle scalarStyle = style;
        Intrinsics.checkNotNull((Object)((Object)scalarStyle));
        Token tok = this.scanFlowScalar(scalarStyle);
        this.addToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchPlain() {
        void var1_1;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.addToken((Token)var1_1);
    }

    private final boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private final boolean checkDocumentStart() {
        return this.checkDirective() && Intrinsics.areEqual((Object)"---", (Object)this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private final boolean checkDocumentEnd() {
        return this.checkDirective() && Intrinsics.areEqual((Object)"...", (Object)this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private final boolean checkBlockEntry() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private final boolean checkKey() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private final boolean checkValue() {
        return this.isFlowContext() || CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkPlain() {
        void var1_1;
        int c = this.reader.peek();
        boolean bl = CharConstants.NULL_BL_T_LINEBR.hasNo(c, "-?:,[]{}#&*!|>'\"%@`");
        if (bl) {
            return true;
        }
        if (this.isBlockContext()) {
            return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && StringsKt.contains$default((CharSequence)"-?:", (char)((char)c), (boolean)false, (int)2, null);
        }
        return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1), ",]") && StringsKt.contains$default((CharSequence)"-?", (char)((char)var1_1), (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void scanToNextToken() {
        found = false;
        inlineStartColumn = -1;
        while (!found) {
            block10: {
                startMark = this.reader.getMark();
                columnBeforeComment = this.reader.getColumn();
                commentSeen = false;
                ff = 0;
                while (this.reader.peek(ff) == 32) {
                    ++ff;
                }
                if (ff > 0) {
                    this.reader.forward(ff);
                }
                if (this.reader.peek() != 35) break block10;
                commentSeen = true;
                if (columnBeforeComment == 0) ** GOTO lbl-1000
                if (this.lastToken == null) ** GOTO lbl-1000
                v0 = this.lastToken;
                if ((v0 != null ? v0.getTokenId() : null) != Token.ID.BlockEntry) lbl-1000:
                // 2 sources

                {
                    type = CommentType.IN_LINE;
                    inlineStartColumn = this.reader.getColumn();
                } else if (inlineStartColumn == this.reader.getColumn()) {
                    type = CommentType.IN_LINE;
                } else {
                    inlineStartColumn = -1;
                    type = CommentType.BLOCK;
                }
                token = this.scanComment(type);
                if (this.settings.parseComments) {
                    this.addToken(token);
                }
            }
            if ((breaksOpt = this.scanLineBreak()) != null) {
                if (this.settings.parseComments && !commentSeen && columnBeforeComment == 0) {
                    this.addToken(new CommentToken(CommentType.BLANK_LINE, breaksOpt, (Mark)var3_3, this.reader.getMark()));
                }
                if (!this.isBlockContext()) continue;
                this.allowSimpleKey = true;
                continue;
            }
            found = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CommentToken scanComment(CommentType type) {
        void var2_2;
        void var3_4;
        void var1_1;
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        int length = 0;
        while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(length))) {
            ++length;
        }
        String value = this.reader.prefixForward(length);
        Mark endMark = this.reader.getMark();
        return new CommentToken((CommentType)var1_1, (String)var3_4, (Mark)var2_2, endMark);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Token> scanDirective() {
        void var1_1;
        Token[] tokenArray;
        void var3_3;
        Mark endMark;
        DirectiveToken.TokenValue value;
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        String name = this.scanDirectiveName(startMark);
        if (Intrinsics.areEqual((Object)"YAML", (Object)name)) {
            value = this.scanYamlDirectiveValue(startMark);
            endMark = this.reader.getMark();
        } else if (Intrinsics.areEqual((Object)"TAG", (Object)endMark)) {
            value = this.scanTagDirectiveValue(startMark);
            endMark = this.reader.getMark();
        } else {
            endMark = this.reader.getMark();
            int ff = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(ff))) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
            value = null;
        }
        CommentToken commentToken = this.scanDirectiveIgnoredLine(startMark);
        DirectiveToken token = new DirectiveToken((DirectiveToken.TokenValue)var3_3, startMark, (Mark)tokenArray);
        Token[] tokenArray2 = new Token[2];
        tokenArray = tokenArray2;
        tokenArray2[0] = var1_1;
        tokenArray[1] = commentToken;
        return this.makeTokenList(tokenArray);
    }

    /*
     * WARNING - void declaration
     */
    private final String scanDirectiveName(Mark startMark) {
        void var2_4;
        void s2;
        int length = 0;
        int c = this.reader.peek(0);
        while (CharConstants.ALPHA.has(c)) {
            c = this.reader.peek(++length);
        }
        if (length == 0) {
            String s2 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", startMark, "expected alphabetic or numeric character, but found " + s2 + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        String value = this.reader.prefixForward((int)s2);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            void var3_5;
            void var1_1;
            String s3 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected alphabetic or numeric character, but found " + (String)var2_4 + '(' + (int)var3_5 + ')', this.reader.getMark(), null, 16);
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    private final DirectiveToken.YamlDirective scanYamlDirectiveValue(Mark startMark) {
        void var2_2;
        while (this.reader.peek() == 32) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        int major = this.scanYamlDirectiveNumber(startMark);
        int c = this.reader.peek();
        if (c != 46) {
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", startMark, "expected a digit or '.', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        int minor = this.scanYamlDirectiveNumber(startMark);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            void var3_4;
            void var2_3;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected a digit or ' ', but found " + (String)var2_3 + '(' + (int)var3_4 + ')', this.reader.getMark(), null, 16);
        }
        return new DirectiveToken.YamlDirective((int)var2_2, minor);
    }

    /*
     * WARNING - void declaration
     */
    private final int scanYamlDirectiveNumber(Mark startMark) {
        void var2_3;
        void var3_5;
        int c = this.reader.peek();
        if (!Character.isDigit((char)c)) {
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", startMark, "expected a digit, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        int length = 0;
        while (Character.isDigit((char)this.reader.peek(length))) {
            ++length;
        }
        String number = this.reader.prefixForward(length);
        if (var3_5 > 3) {
            void var1_1;
            throw new ScannerException("while scanning a YAML directive", (Mark)var1_1, "found a number which cannot represent a valid version: " + number, this.reader.getMark(), null, 16);
        }
        return Integer.parseInt((String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final DirectiveToken.TagDirective scanTagDirectiveValue(Mark startMark) {
        void var1_1;
        void var2_2;
        while (this.reader.peek() == 32) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        String handle = this.scanTagDirectiveHandle(startMark);
        while (this.reader.peek() == 32) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        String prefix = this.scanTagDirectivePrefix(startMark);
        return new DirectiveToken.TagDirective((String)var2_2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final String scanTagDirectiveHandle(Mark startMark) {
        void var2_2;
        String value = this.scanTagHandle("directive", startMark);
        int c = this.reader.peek();
        if (c != 32) {
            void var3_3;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected ' ', but found " + (String)var2_2 + '(' + (int)var3_3 + ')', this.reader.getMark(), null, 16);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final String scanTagDirectivePrefix(Mark startMark) {
        void var2_2;
        String value = this.scanTagUri("directive", CharConstants.URI_CHARS_FOR_TAG_PREFIX, startMark);
        int c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            void var3_3;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected ' ', but found " + (String)var2_2 + '(' + (int)var3_3 + ')', this.reader.getMark(), null, 16);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final CommentToken scanDirectiveIgnoredLine(Mark startMark) {
        void var2_2;
        while (this.reader.peek() == 32) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        CommentToken commentToken = null;
        if (this.reader.peek() == 35) {
            CommentToken comment = this.scanComment(CommentType.IN_LINE);
            if (this.settings.parseComments) {
                commentToken = comment;
            }
        }
        int c = this.reader.peek();
        if (this.scanLineBreak() == null && c != 0) {
            void var3_4;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected a comment or a line break, but found " + (String)var2_2 + '(' + (int)var3_4 + ')', this.reader.getMark(), null, 16);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Token scanAnchor(boolean isAnchor) {
        void var2_2;
        void var1_1;
        void s2;
        Mark startMark = this.reader.getMark();
        int n = this.reader.peek();
        String name = n == 42 ? "alias" : "anchor";
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        int length = 0;
        int c = this.reader.peek(0);
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(c, ",[]{}/.*&")) {
            c = this.reader.peek(++length);
        }
        if (length == 0) {
            String s2 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning an " + name, startMark, "unexpected character found " + s2 + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        String value = this.reader.prefixForward((int)s2);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_T_LINEBR.hasNo(c, "?:,]}%@`")) {
            void var3_4;
            String s3 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning an " + (String)var3_4, startMark, "unexpected character found " + s3 + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        Mark endMark = this.reader.getMark();
        if (var1_1 != false) {
            return new AnchorToken(new Anchor(value), startMark, endMark);
        }
        return new AliasToken(new Anchor(value), (Mark)var2_2, endMark);
    }

    /*
     * WARNING - void declaration
     */
    private final Token scanTag() {
        void var1_1;
        void var3_6;
        String s;
        String useHandle22;
        Object handle;
        String suffix;
        Mark startMark = this.reader.getMark();
        int c = this.reader.peek(1);
        if (c == 60) {
            this.reader.forward(2);
            suffix = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_PREFIX, startMark);
            c = this.reader.peek();
            if (c != 62) {
                String s2 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
                throw new ScannerException("while scanning a tag", startMark, "expected '>', but found '" + s2 + "' (" + c + ')', this.reader.getMark(), null, 16);
            }
            handle = null;
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        } else if (CharConstants.NULL_BL_T_LINEBR.has(c)) {
            suffix = "!";
            handle = null;
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        } else {
            String length2;
            int length2 = 1;
            boolean useHandle22 = false;
            while (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
                if (c == 33) {
                    useHandle22 = true;
                    break;
                }
                c = this.reader.peek(++length2);
            }
            if (useHandle22) {
                length2 = this.scanTagHandle("tag", startMark);
            } else {
                length2 = "!";
                StreamReader.forward$default$4375041d(this.reader, 0, 1);
            }
            useHandle22 = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_SUFFIX, startMark);
        }
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            void var2_2;
            s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a tag", startMark, "expected ' ', but found '" + s + "' (" + (int)var2_2 + ')', this.reader.getMark(), null, 16);
        }
        TagTuple value = new TagTuple(s, useHandle22);
        Mark endMark = this.reader.getMark();
        return new TagToken((TagTuple)var3_6, (Mark)var1_1, endMark);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Token> scanBlockScalar(ScalarStyle style) {
        void var1_1;
        void var3_3;
        void var2_2;
        Mark mark;
        Object object;
        int blockIndent;
        Mark endMark;
        String breaks;
        BreakIntentHolder brme;
        StringBuilder stringBuilder = new StringBuilder();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Chomping chomping = this.scanBlockScalarIndicators(startMark);
        CommentToken commentToken = this.scanBlockScalarIgnoredLine(startMark);
        int minIndent = RangesKt.coerceAtLeast((int)(this.indent + 1), (int)1);
        Integer chompingIncrement = chomping.getIncrement();
        if (chompingIncrement == null) {
            brme = this.scanBlockScalarIndentation();
            breaks = brme.getBreaks();
            int maxIndent = brme.getMaxIndent();
            endMark = brme.getEndMark();
            blockIndent = RangesKt.coerceAtLeast((int)minIndent, (int)maxIndent);
        } else {
            void maxIndent;
            blockIndent = blockIndent + maxIndent.intValue() - true;
            brme = this.scanBlockScalarBreaks(blockIndent);
            breaks = brme.getBreaks();
            endMark = brme.getEndMark();
        }
        String lineBreak = null;
        if (this.reader.getColumn() < blockIndent && this.indent != this.reader.getColumn()) {
            throw new ScannerException("while scanning a block scalar", startMark, " the leading empty lines contain more spaces (" + blockIndent + ") than the first non-empty line.", this.reader.getMark(), null, 16);
        }
        while (this.reader.getColumn() == blockIndent && this.reader.peek() != 0) {
            stringBuilder.append(breaks);
            boolean leadingNonSpace = !StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek()), (boolean)false, (int)2, null);
            int length = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(length))) {
                ++length;
            }
            stringBuilder.append(this.reader.prefixForward(length));
            lineBreak = this.scanLineBreak();
            BreakIntentHolder brme2 = this.scanBlockScalarBreaks(blockIndent);
            object = brme2.getBreaks();
            mark = brme2.getEndMark();
            if (this.reader.getColumn() != blockIndent || this.reader.peek() == 0) break;
            if (style == ScalarStyle.FOLDED && Intrinsics.areEqual((Object)"\n", (Object)lineBreak) && leadingNonSpace && !StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek()), (boolean)false, (int)2, null)) {
                if (!(((CharSequence)object).length() == 0)) continue;
                stringBuilder.append(' ');
                continue;
            }
            String string = lineBreak;
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
        }
        if (chomping.getAddExistingFinalLineBreak()) {
            String string = lineBreak;
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
        }
        if (chomping.getRetainTrailingEmptyLines()) {
            stringBuilder.append((String)object);
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ScalarToken scalarToken = new ScalarToken(string, false, (Mark)var3_3, mark, (ScalarStyle)var1_1);
        Token[] tokenArray = new Token[2];
        object = tokenArray;
        tokenArray[0] = commentToken;
        object[1] = scalarToken;
        return this.makeTokenList((Token)object);
    }

    /*
     * WARNING - void declaration
     */
    private final Chomping scanBlockScalarIndicators(Mark startMark) {
        void var3_5;
        Integer incr22;
        Integer indicator;
        int c = this.reader.peek();
        if (c == 45 || c == 43) {
            Integer increment;
            indicator = c;
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
            c = this.reader.peek();
            if (Character.isDigit((char)c)) {
                int incr = Integer.parseInt(StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c)));
                if (incr == 0) {
                    throw new ScannerException("while scanning a block scalar", startMark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark(), null, 16);
                }
                increment = incr;
                StreamReader.forward$default$4375041d(this.reader, 0, 1);
            } else {
                increment = null;
            }
        } else if (Character.isDigit((char)c)) {
            int incr22 = Integer.parseInt(StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c)));
            if (incr22 == 0) {
                throw new ScannerException("while scanning a block scalar", startMark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark(), null, 16);
            }
            incr22 = incr22;
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
            c = this.reader.peek();
            switch (c) {
                case 43: 
                case 45: {
                    indicator = c;
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                    break;
                }
                default: {
                    indicator = null;
                    break;
                }
            }
        } else {
            incr22 = null;
            indicator = null;
        }
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a block scalar", (Mark)var1_1, "expected chomping or indentation indicators, but found " + (String)var3_5 + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        Chomping chomping = ScannerImplKt.access$Chomping(indicator, (Integer)var3_5);
        if (chomping == null) {
            void var2_3;
            throw new IllegalArgumentException("Unexpected block chomping indicator: " + var2_3);
        }
        return chomping;
    }

    /*
     * WARNING - void declaration
     */
    private final CommentToken scanBlockScalarIgnoredLine(Mark startMark) {
        void var2_2;
        while (this.reader.peek() == 32) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        CommentToken commentToken = this.reader.peek() == 35 ? this.scanComment(CommentType.IN_LINE) : null;
        int c = this.reader.peek();
        if (this.scanLineBreak() == null && c != 0) {
            void var3_3;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a block scalar", (Mark)var1_1, "expected a comment or a line break, but found " + (String)var2_2 + '(' + (int)var3_3 + ')', this.reader.getMark(), null, 16);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final BreakIntentHolder scanBlockScalarIndentation() {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder chunks = new StringBuilder();
        int maxIndent = 0;
        Mark endMark = this.reader.getMark();
        while (CharConstants.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                String string = this.scanLineBreak();
                if (string == null) {
                    string = "";
                }
                chunks.append(string);
                endMark = this.reader.getMark();
                continue;
            }
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
            if (this.reader.getColumn() <= maxIndent) continue;
            maxIndent = this.reader.getColumn();
        }
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new BreakIntentHolder(string, (int)var2_2, (Mark)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final BreakIntentHolder scanBlockScalarBreaks(int indent) {
        void var2_2;
        Mark mark;
        int col;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = this.reader.getMark();
        for (col = this.reader.getColumn(); col < indent && this.reader.peek() == 32; ++col) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
        }
        while (this.scanLineBreak() != null) {
            chunks.append((String)((Object)mark));
            mark = this.reader.getMark();
            for (col = this.reader.getColumn(); col < indent && this.reader.peek() == 32; ++col) {
                StreamReader.forward$default$4375041d(this.reader, 0, 1);
            }
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new BreakIntentHolder(string, -1, mark);
    }

    /*
     * WARNING - void declaration
     */
    private final Token scanFlowScalar(ScalarStyle style) {
        void var1_1;
        void var3_4;
        void var2_3;
        StringBuilder stringBuilder;
        boolean doubleValue = style == ScalarStyle.DOUBLE_QUOTED;
        Mark startMark = this.reader.getMark();
        int quote = this.reader.peek();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        StringBuilder $this$scanFlowScalar_u24lambda_u240 = stringBuilder = new StringBuilder();
        this.scanFlowScalarNonSpaces(doubleValue, startMark, $this$scanFlowScalar_u24lambda_u240);
        while (this.reader.peek() != quote) {
            this.scanFlowScalarSpaces(startMark, $this$scanFlowScalar_u24lambda_u240);
            this.scanFlowScalarNonSpaces(doubleValue, startMark, $this$scanFlowScalar_u24lambda_u240);
        }
        String chunks = stringBuilder.toString();
        StreamReader.forward$default$4375041d(this.reader, 0, 1);
        Mark endMark = this.reader.getMark();
        return new ScalarToken((String)var2_3, false, (Mark)var3_4, endMark, (ScalarStyle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void scanFlowScalarNonSpaces(boolean doubleQuoted, Mark startMark, StringBuilder chunks) {
        block10: {
            void var2_2;
            int c;
            while (true) {
                int length = 0;
                while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length), "'\"\\")) {
                    ++length;
                }
                if (length != 0) {
                    chunks.append(this.reader.prefixForward(length));
                }
                c = this.reader.peek();
                if (!doubleQuoted && c == 39 && this.reader.peek(1) == 39) {
                    chunks.append('\'');
                    this.reader.forward(2);
                    continue;
                }
                if (doubleQuoted && c == 39 || !doubleQuoted && StringsKt.contains$default((CharSequence)"\"\\", (char)((char)c), (boolean)false, (int)2, null)) {
                    chunks.appendCodePoint(c);
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                    continue;
                }
                if (!doubleQuoted || c != 92) break block10;
                StreamReader.forward$default$4375041d(this.reader, 0, 1);
                c = this.reader.peek();
                if (!dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.isSupplementaryCodePoint$snakeyaml_engine_kmp(c) && CharConstants.ESCAPE_REPLACEMENTS.containsKey(Character.valueOf((char)c))) {
                    chunks.append(CharConstants.ESCAPE_REPLACEMENTS.get(Character.valueOf((char)c)));
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                    continue;
                }
                if (!dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.isSupplementaryCodePoint$snakeyaml_engine_kmp(c) && CharConstants.ESCAPE_CODES.containsKey(Character.valueOf((char)c))) {
                    Integer n = CharConstants.ESCAPE_CODES.get(Character.valueOf((char)c));
                    Intrinsics.checkNotNull((Object)n);
                    c = ((Number)n).intValue();
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                    String hex = this.reader.prefix(c);
                    if (NOT_HEXA.containsMatchIn((CharSequence)hex)) {
                        throw new ScannerException("while scanning a double-quoted scalar", startMark, "expected escape sequence of " + c + " hexadecimal numbers, but found: " + hex, this.reader.getMark(), null, 16);
                    }
                    try {
                        int decimal = Integer.parseInt(hex, CharsKt.checkRadix((int)16));
                        chunks.appendCodePoint(decimal);
                        this.reader.forward(c);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ScannerException("while scanning a double-quoted scalar", startMark, "found unknown escape character " + hex, this.reader.getMark(), null, 16);
                    }
                }
                if (this.scanLineBreak() == null) break;
                chunks.append(this.scanFlowScalarBreaks(startMark));
            }
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a double-quoted scalar", (Mark)var2_2, "found unknown escape character " + s + '(' + c + ')', this.reader.getMark(), null, 16);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void scanFlowScalarSpaces(Mark startMark, StringBuilder chunks) {
        void var3_4;
        void var2_2;
        int length = 0;
        while (StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek(length)), (boolean)false, (int)2, null)) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        if (this.reader.peek() == 0) {
            throw new ScannerException("found unexpected end of stream", this.reader.getMark(), "while scanning a quoted scalar", startMark, null, 16);
        }
        String lineBreakOpt = this.scanLineBreak();
        StringBuilder $this$scanFlowScalarSpaces_u24lambda_u241 = chunks;
        if (lineBreakOpt != null) {
            void var1_1;
            String breaks = this.scanFlowScalarBreaks(startMark);
            if (!Intrinsics.areEqual((Object)"\n", (Object)lineBreakOpt)) {
                $this$scanFlowScalarSpaces_u24lambda_u241.append(lineBreakOpt);
            } else if (((CharSequence)breaks).length() == 0) {
                $this$scanFlowScalarSpaces_u24lambda_u241.append(' ');
            }
            $this$scanFlowScalarSpaces_u24lambda_u241.append((String)var1_1);
            return;
        }
        var2_2.append((String)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private final String scanFlowScalarBreaks(Mark startMark) {
        void var2_2;
        StringBuilder chunks = new StringBuilder();
        while (true) {
            void var3_3;
            String prefix;
            if ((Intrinsics.areEqual((Object)"---", (Object)(prefix = this.reader.prefix(3))) || Intrinsics.areEqual((Object)"...", (Object)prefix)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", startMark, "found unexpected document separator", this.reader.getMark(), null, 16);
            }
            while (StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek()), (boolean)false, (int)2, null)) {
                StreamReader.forward$default$4375041d(this.reader, 0, 1);
            }
            if (this.scanLineBreak() == null) break;
            chunks.append((String)var3_3);
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Token scanPlain() {
        void var3_3;
        void var2_2;
        void var1_1;
        Mark startMark;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = startMark = this.reader.getMark();
        int plainIndent = this.indent + 1;
        String spaces = "";
        do {
            int c;
            int length = 0;
            if (this.reader.peek() == 35) break;
            while (!(CharConstants.NULL_BL_T_LINEBR.has(c = this.reader.peek(length)) || c == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(length + 1), this.isFlowContext() ? ",[]{}" : "") || this.isFlowContext() && StringsKt.contains$default((CharSequence)",[]{}", (char)((char)c), (boolean)false, (int)2, null))) {
                ++length;
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            chunks.append(this.reader.prefixForward(length));
            endMark = this.reader.getMark();
        } while (!(((CharSequence)(spaces = this.scanPlainSpaces())).length() == 0) && this.reader.peek() != 35 && (!this.isBlockContext() || this.reader.getColumn() >= plainIndent));
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new ScalarToken(string, true, (Mark)var2_2, (Mark)var3_3, null, 16);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean atEndOfPlain() {
        int c;
        int wsLength = 0;
        int wsColumn = this.reader.getColumn();
        while ((c = this.reader.peek(wsLength)) != 0 && CharConstants.NULL_BL_T_LINEBR.has(c)) {
            if (!(CharConstants.LINEBR.has(c) || c == 13 && this.reader.peek(++wsLength + 1) == 10 || c == 65279)) {
                ++wsColumn;
                continue;
            }
            wsColumn = 0;
        }
        if (this.reader.peek(wsLength) == 35 || this.reader.peek(wsLength + 1) == 0 || this.isBlockContext() && wsColumn < this.indent) {
            return true;
        }
        if (this.isBlockContext()) {
            int c2;
            int extra = 1;
            while ((c2 = this.reader.peek(wsLength + extra)) != 0 && !CharConstants.NULL_BL_T_LINEBR.has(c2)) {
                if (c2 == 58) {
                    void var2_2;
                    int nextC = this.reader.peek(wsLength + extra + 1);
                    if (CharConstants.NULL_BL_T_LINEBR.has((int)var2_2)) {
                        return true;
                    }
                }
                ++extra;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String scanPlainSpaces() {
        void var3_4;
        StringBuilder breaks;
        String lineBreak;
        block8: {
            int length = 0;
            while (StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek(length)), (boolean)false, (int)2, null)) {
                ++length;
            }
            String whitespaces = this.reader.prefixForward(length);
            String string = this.scanLineBreak();
            if (string == null) {
                return whitespaces;
            }
            lineBreak = string;
            this.allowSimpleKey = true;
            String prefix = this.reader.prefix(3);
            if (Intrinsics.areEqual((Object)"---", (Object)prefix) || Intrinsics.areEqual((Object)"...", (Object)prefix) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                return "";
            }
            if (this.settings.parseComments && this.atEndOfPlain()) {
                return "";
            }
            breaks = new StringBuilder();
            while (true) {
                String string2;
                if (StringsKt.contains$default((CharSequence)" \t", (char)((char)this.reader.peek()), (boolean)false, (int)2, null)) {
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                    continue;
                }
                String lbOpt = this.scanLineBreak();
                if (lbOpt == null) break block8;
                breaks.append(string2);
                string2 = this.reader.prefix(3);
                if (Intrinsics.areEqual((Object)"---", (Object)string2) || Intrinsics.areEqual((Object)"...", (Object)string2) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
            }
            return "";
        }
        if (!Intrinsics.areEqual((Object)"\n", (Object)lineBreak)) {
            void var1_2;
            return (String)var1_2 + breaks;
        }
        if (((CharSequence)breaks).length() == 0) {
            return " ";
        }
        String string = var3_4.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String scanTagHandle(String name, Mark startMark) {
        void var4_5;
        int c = this.reader.peek();
        if (c != 33) {
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a " + name, startMark, "expected '!', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        int length = 1;
        c = this.reader.peek(1);
        if (c != 32) {
            while (CharConstants.ALPHA.has(c)) {
                c = this.reader.peek(++length);
            }
            if (c != 33) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.reader.forward(length);
                String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
                throw new ScannerException("while scanning a " + (String)var1_1, (Mark)var2_2, "expected '!', but found " + s + '(' + (int)var3_3 + ')', this.reader.getMark(), null, 16);
            }
            ++var4_5;
        }
        return this.reader.prefixForward((int)var4_5);
    }

    /*
     * WARNING - void declaration
     */
    private final String scanTagUri(String name, CharConstants range, Mark startMark) {
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        int c = this.reader.peek(0);
        while (range.has(c)) {
            if (c == 37) {
                chunks.append(this.reader.prefixForward(length));
                length = 0;
                Serializable cfr_ignored_0 = chunks.append(this.scanUriEscapes(name, startMark));
            } else {
                Serializable cfr_ignored_1 = Integer.valueOf(length++);
            }
            c = this.reader.peek(length);
        }
        if (length != 0) {
            chunks.append(this.reader.prefixForward(length));
        }
        if (((CharSequence)chunks).length() == 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            String s = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a " + (String)var1_1, (Mark)var3_3, "expected URI, but found " + (String)var2_2 + '(' + c + ')', this.reader.getMark(), null, 16);
        }
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String scanUriEscapes(String name, Mark startMark) {
        String s1;
        int length = 1;
        while (this.reader.peek(length * 3) == 37) {
            ++length;
        }
        Mark beginningMark = this.reader.getMark();
        Buffer buff = new Buffer();
        while (this.reader.peek() == 37) {
            StreamReader.forward$default$4375041d(this.reader, 0, 1);
            try {
                int code = Integer.parseInt(this.reader.prefix(2), CharsKt.checkRadix((int)16));
                buff.writeByte(code);
            }
            catch (NumberFormatException numberFormatException) {
                void var3_5;
                int c1 = this.reader.peek();
                s1 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c1));
                int c2 = this.reader.peek(1);
                String s2 = StringsKt.concatToString((char[])dev.rvbsm.fsit.lib.snakeyaml-kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c2));
                throw new ScannerException("while scanning a " + name, startMark, "expected URI escape sequence of 2 hexadecimal numbers, but found " + s1 + '(' + (int)var3_5 + ") and " + s2 + '(' + c2 + ')', this.reader.getMark(), null, 16);
            }
            this.reader.forward(2);
        }
        ((Buffer)((Object)s1)).flush();
        try {
            return UriEncoder.decode((Buffer)((Object)s1));
        }
        catch (CharacterCodingException e) {
            void var3_4;
            void var2_2;
            void var1_1;
            throw new ScannerException("while scanning a " + (String)var1_1, (Mark)var2_2, "expected URI in UTF-8: " + e.getMessage(), (Mark)var3_4, null, 16);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String scanLineBreak() {
        int c = this.reader.peek();
        switch (c) {
            case 10: 
            case 13: 
            case 133: {
                void var1_1;
                if (var1_1 == 13 && 10 == this.reader.peek(1)) {
                    this.reader.forward(2);
                } else {
                    StreamReader.forward$default$4375041d(this.reader, 0, 1);
                }
                return "\n";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Token> makeTokenList(Token ... tokens) {
        Iterator iterator;
        Iterable notNullTokens = ArraysKt.filterNotNull((Object[])tokens);
        if (!this.settings.parseComments) {
            void var2_2;
            notNullTokens = notNullTokens;
            Collection destination$iv$iv = new ArrayList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element$iv$iv = iterator.next();
                Token token = (Token)element$iv$iv;
                if (!(!(token instanceof CommentToken))) continue;
                destination$iv$iv.add(var3_3);
            }
            return (List)var2_2;
        }
        return iterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    static {
        new Companion(null);
        NOT_HEXA = new Regex("[^0-9A-Fa-f]");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Ldev/rvbsm/fsit/lib/snakeyaml-kmp/scanner/ScannerImpl$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "NOT_HEXA", "Lkotlin/text/Regex;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

