/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.rvbsm.fsit.api.event.ClientCommandCallback;
import dev.rvbsm.fsit.api.event.PassedUseBlockCallback;
import dev.rvbsm.fsit.api.event.PassedUseEntityCallback;
import dev.rvbsm.fsit.api.network.RidingRequestHandler;
import dev.rvbsm.fsit.networking.payload.RidingResponseC2SPayload;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2848;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerPlayNetworkHandlerMixin
implements RidingRequestHandler {
    @Unique
    private final Map<UUID, CompletableFuture<Boolean>> pendingRidingRequests = new WeakHashMap<UUID, CompletableFuture<Boolean>>();
    @Shadow
    public class_3222 field_14140;

    /*
     * WARNING - void declaration
     */
    @Inject(method={"onClientCommand"}, at={@At(value="TAIL")})
    public void onClientCommand(class_2848 packet, CallbackInfo ci) {
        void var1_1;
        ((ClientCommandCallback)ClientCommandCallback.EVENT.invoker()).process(this.field_14140, var1_1.method_12365());
    }

    /*
     * WARNING - void declaration
     */
    @ModifyVariable(method={"onPlayerInteractBlock"}, at=@At(value="STORE"))
    private class_1269 interactBlock(class_1269 interactionActionResult, @Local class_3218 world, @Local LocalRef<class_1268> handRef, @Local class_1799 itemStack, @Local class_3965 blockHitResult) {
        void var2_2;
        if (interactionActionResult != class_1269.field_5811 || itemStack.method_7976().ordinal() != 0) {
            return interactionActionResult;
        }
        switch ((class_1268)handRef.get()) {
            case field_5808: {
                void var1_1;
                if (this.field_14140.method_6079().method_7960()) break;
                return var1_1;
            }
            case field_5810: {
                void var3_3;
                var3_3.set((Object)class_1268.field_5808);
            }
        }
        return ((PassedUseBlockCallback)PassedUseBlockCallback.EVENT.invoker()).interact(this.field_14140, (class_1937)var2_2, blockHitResult);
    }

    @Inject(method={"onDisconnected"}, at={@At(value="TAIL")})
    public void purgePendingRequests(CallbackInfo ci) {
        this.pendingRidingRequests.forEach((uuid, future) -> future.complete(Boolean.FALSE));
        this.pendingRidingRequests.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<Boolean> fsit$newRidingRequest(@NotNull UUID playerUUID, @NotNull Duration timeout) {
        void var2_2;
        void var1_1;
        void var3_3;
        CompletableFuture<Boolean> pendingFuture = this.pendingRidingRequests.get(playerUUID);
        if (pendingFuture != null && !var3_3.isDone()) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        CompletableFuture<Boolean> ridingResponse = new CompletableFuture<Boolean>().completeOnTimeout(Boolean.FALSE, timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.pendingRidingRequests.put((UUID)var1_1, ridingResponse);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fsit$completeRidingRequest(@NotNull RidingResponseC2SPayload response2) {
        CompletableFuture<Boolean> future = this.pendingRidingRequests.remove(response2.getUuid());
        if (future != null && !future.isDone()) {
            void var1_1;
            void var2_2;
            var2_2.complete(var1_1.getResponse().isAccepted());
        }
    }

    @Mixin(targets={"net.minecraft.server.network.ServerPlayNetworkHandler$1"})
    public static abstract class PlayerInteractEntityC2SPacketHandler {
        @Shadow
        @Final
        class_3244 field_28963;
        @Shadow
        @Final
        class_1297 field_28962;
        @Shadow
        @Final
        class_3218 field_39991;

        /*
         * WARNING - void declaration
         */
        @ModifyVariable(method={"processInteract"}, at=@At(value="STORE"))
        private class_1269 interactPlayer(class_1269 interactionActionResult, @Local(argsOnly=true) LocalRef<class_1268> handRef) {
            void var1_1;
            if (interactionActionResult == class_1269.field_5811 && handRef.get() == class_1268.field_5810 && this.field_28963.field_14140.method_5998((class_1268)handRef.get()).method_7976().ordinal() == 0) {
                void var2_2;
                var2_2.set((Object)class_1268.field_5808);
                return ((PassedUseEntityCallback)PassedUseEntityCallback.EVENT.invoker()).interact(this.field_28963.field_14140, this.field_39991, this.field_28962);
            }
            return var1_1;
        }
    }
}

