/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.UserListTabCompletable;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.desertwell.about.AboutMenu;
import net.william278.huskhomes.libraries.desertwell.util.UpdateChecker;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.libraries.paginedown.PaginatedList;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.StatusLine;

public class HuskHomesCommand
extends Command
implements UserListTabCompletable {
    private static final Map<String, Boolean> SUB_COMMANDS = Map.of("about", false, "help", false, "reload", true, "status", true, "dump", true, "homeslots", true, "import", true, "delete", true, "update", true);
    private final UpdateChecker updateChecker;
    private final AboutMenu aboutMenu;

    protected HuskHomesCommand(@NotNull HuskHomes plugin) {
        super(List.of("huskhomes"), "[" + String.join((CharSequence)"|", SUB_COMMANDS.keySet()) + "]", plugin);
        this.addAdditionalPermissions(SUB_COMMANDS);
        this.updateChecker = plugin.getUpdateChecker();
        this.aboutMenu = AboutMenu.builder().title(Component.text("HuskHomes")).description(Component.text("The powerful & intuitive homes, warps, and teleportation suite")).version(plugin.getPluginVersion()).credits("Author", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net")).credits("Contributors", AboutMenu.Credit.of("imDaniX").description("Code, refactoring"), AboutMenu.Credit.of("Log1x").description("Code")).credits("Translators", AboutMenu.Credit.of("SnivyJ").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("ApliNi").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("Wtq_").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("TonyPak").description("Traditional Chinese (zh-tw)"), AboutMenu.Credit.of("davgo0103").description("Traditional Chinese (zh-tw)"), AboutMenu.Credit.of("Villag3r_").description("Italian (it-it)"), AboutMenu.Credit.of("ReferTV").description("Polish (pl)"), AboutMenu.Credit.of("anchelthe").description("Spanish (es-es)"), AboutMenu.Credit.of("Chiquis2005").description("Spanish (es-es)"), AboutMenu.Credit.of("Funasitien").description("French, (fr-fr)"), AboutMenu.Credit.of("Ceddix").description("German, (de-de)"), AboutMenu.Credit.of("Pukejoy_1").description("Bulgarian (bg-bg)"), AboutMenu.Credit.of("WinTone01").description("Turkish, (tr-tr)"), AboutMenu.Credit.of("EmanuelFNC").description("Brazilian Portuguese, (pt-br)"), AboutMenu.Credit.of("xMattNice_").description("Brazilian Portuguese, (pt-br)"), AboutMenu.Credit.of("Iamsad_VN").description("Vietnamese, (vi-vn)")).buttons(AboutMenu.Link.of("https://william278.net/docs/huskhomes").text("Documentation").icon("\u26cf"), AboutMenu.Link.of("https://github.com/WiIIiam278/HuskHomes/issues").text("Issues").icon("\u274c").color(TextColor.color(0xFF9F0F)), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color(6779893))).build();
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        String action = this.parseStringArg(args, 0).orElse("about");
        if (SUB_COMMANDS.containsKey(action) && !executor.hasPermission(this.getPermission(action))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        block11 : switch (action.toLowerCase()) {
            case "about": {
                executor.sendMessage(this.aboutMenu.toComponent());
                break;
            }
            case "help": {
                executor.sendMessage(this.getCommandList(executor).getNearestValidPage(this.parseIntArg(args, 1).orElse(1)));
                break;
            }
            case "status": {
                this.getPlugin().getLocales().getLocale("system_status_header").ifPresent(executor::sendMessage);
                executor.sendMessage(Component.join(JoinConfiguration.newlines(), Arrays.stream(StatusLine.values()).map(s -> s.get(this.plugin)).toList()));
                break;
            }
            case "dump": {
                if (!this.parseStringArg(args, 1).map(s -> s.equals("confirm")).orElse(false).booleanValue()) {
                    this.getPlugin().getLocales().getLocale("system_dump_confirm").ifPresent(executor::sendMessage);
                    return;
                }
                this.getPlugin().getLocales().getLocale("system_dump_started").ifPresent(executor::sendMessage);
                this.plugin.runAsync(() -> {
                    String url = this.plugin.createDump(executor);
                    this.getPlugin().getLocales().getLocale("system_dump_ready").ifPresent(executor::sendMessage);
                    executor.sendMessage(((TextComponent)((TextComponent)Component.text(url).clickEvent(ClickEvent.openUrl(url))).decorate(TextDecoration.UNDERLINED)).color(NamedTextColor.GRAY));
                });
                break;
            }
            case "homeslots": {
                if (!this.plugin.isUsingEconomy() || args.length <= 1) {
                    this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                    return;
                }
                this.manageHomeSlots(executor, this.removeFirstArg(args));
                break;
            }
            case "import": {
                if (this.plugin.getImporters().isEmpty()) {
                    this.plugin.getLocales().getLocale("error_no_importers_available").ifPresent(executor::sendMessage);
                    return;
                }
                this.importData(executor, this.removeFirstArg(args));
                break;
            }
            case "reload": {
                this.plugin.runSync(() -> {
                    try {
                        this.plugin.unloadHooks(PluginHook.Register.ON_ENABLE, PluginHook.Register.AFTER_LOAD);
                        this.plugin.loadConfigs();
                        this.plugin.loadHooks(PluginHook.Register.ON_ENABLE, PluginHook.Register.AFTER_LOAD);
                        this.plugin.registerHooks(PluginHook.Register.ON_ENABLE, PluginHook.Register.AFTER_LOAD);
                        this.plugin.getLocales().getLocale("reload_complete").ifPresent(executor::sendMessage);
                    }
                    catch (Throwable e) {
                        executor.sendMessage(new MineDown("[Error:](#ff3300) [Failed to reload the plugin. Check console for errors.](#ff7e5e)"));
                        this.plugin.log(Level.SEVERE, "Failed to reload the plugin", e);
                    }
                });
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                    return;
                }
                String[] deletionArgs = this.removeFirstArg(args);
                switch (deletionArgs[0].toLowerCase(Locale.ENGLISH)) {
                    case "player": {
                        this.deletePlayerData(executor, this.removeFirstArg(deletionArgs));
                        break block11;
                    }
                    case "homes": {
                        this.deleteHomes(executor, this.removeFirstArg(deletionArgs));
                        break block11;
                    }
                    case "warps": {
                        this.deleteWarps(executor, this.removeFirstArg(deletionArgs));
                        break block11;
                    }
                }
                this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete <player|homes|warps> [args]").ifPresent(executor::sendMessage);
                break;
            }
            case "update": {
                this.updateChecker.check().thenAccept(checked -> {
                    if (checked.isUpToDate()) {
                        this.plugin.getLocales().getLocale("up_to_date", this.plugin.getPluginVersion().toString()).ifPresent(executor::sendMessage);
                        return;
                    }
                    this.plugin.getLocales().getLocale("update_available", checked.getLatestVersion().toString(), this.plugin.getPluginVersion().toString()).ifPresent(executor::sendMessage);
                });
                break;
            }
            default: {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            }
        }
    }

    private void manageHomeSlots(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional savedUser = this.parseStringArg(args, 0).flatMap(u -> this.plugin.getDatabase().getUser((String)u));
        String actionArg = this.parseStringArg(args, 1).orElse("view").toLowerCase(Locale.ENGLISH);
        Optional<Integer> valueArg = this.parseIntArg(args, 2);
        if (savedUser.isEmpty()) {
            this.plugin.getLocales().getLocale("error_player_not_found", args[0]).ifPresent(executor::sendMessage);
            return;
        }
        SavedUser user = (SavedUser)savedUser.get();
        switch (actionArg) {
            case "view": {
                List<Home> homes = this.plugin.getDatabase().getHomes(user.getUser());
                this.plugin.getLocales().getLocale("user_home_slots_status", user.getUsername(), Integer.toString(user.getHomeSlots()), Integer.toString(homes.size())).ifPresent(executor::sendMessage);
                break;
            }
            case "set": 
            case "add": 
            case "remove": {
                if (valueArg.isEmpty()) {
                    this.plugin.getLocales().getLocale("error_invalid_syntax", "/%s homeslots <set|add|remove> <value>".formatted(this.getName())).ifPresent(executor::sendMessage);
                    return;
                }
                int value = valueArg.orElseThrow();
                if (actionArg.equals("add")) {
                    value = user.getHomeSlots() + value;
                } else if (actionArg.equals("remove")) {
                    value = user.getHomeSlots() - value;
                }
                if (value < 0) {
                    this.plugin.getLocales().getLocale("error_invalid_syntax", "/%s homeslots [view|set|add|remove]".formatted(this.getName())).ifPresent(executor::sendMessage);
                    return;
                }
                user.setHomeSlots(value);
                this.plugin.getDatabase().updateUserData(user);
                this.plugin.getLocales().getLocale("user_home_slots_updated", user.getUsername(), Integer.toString(user.getHomeSlots())).ifPresent(executor::sendMessage);
                break;
            }
            default: {
                this.plugin.getLocales().getLocale("error_invalid_syntax", "/%s homeslots [view|set|add|remove]".formatted(this.getName())).ifPresent(executor::sendMessage);
            }
        }
    }

    private void importData(@NotNull CommandUser executor, @NotNull String[] args) {
        switch (this.parseStringArg(args, 0).orElse("list")) {
            case "start": {
                this.parseStringArg(args, 1).ifPresentOrElse(name -> {
                    Optional<Importer> importer = this.plugin.getImporterByName((String)name);
                    if (importer.isEmpty()) {
                        this.plugin.getLocales().getLocale("error_invalid_importer").ifPresent(executor::sendMessage);
                        return;
                    }
                    importer.get().start(executor);
                }, () -> this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " import start <importer>").ifPresent(executor::sendMessage));
                break;
            }
            case "list": {
                executor.sendMessage(this.getImporterList().getNearestValidPage(this.parseIntArg(args, 1).orElse(1)));
                break;
            }
            default: {
                this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " import <start|list>").ifPresent(executor::sendMessage);
            }
        }
    }

    private void deletePlayerData(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<String> nameOrUuid = this.parseStringArg(args, 0);
        if (nameOrUuid.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete player <player> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            Optional<SavedUser> savedUser;
            try {
                savedUser = this.plugin.getDatabase().getUser(UUID.fromString((String)nameOrUuid.get()));
            }
            catch (IllegalArgumentException e) {
                savedUser = this.plugin.getDatabase().getUser((String)nameOrUuid.get());
            }
            if (savedUser.isEmpty()) {
                this.plugin.getLocales().getLocale("error_player_not_found", (String)nameOrUuid.get()).ifPresent(executor::sendMessage);
                return;
            }
            User user = savedUser.get().getUser();
            if (!this.parseStringArg(args, 1).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
                this.plugin.getLocales().getLocale("delete_player_confirm", savedUser.get().getUser().getName()).ifPresent(executor::sendMessage);
                return;
            }
            int homesDeleted = this.plugin.getManager().homes().deleteAllHomes(user);
            this.plugin.getDatabase().deleteUser(user.getUuid());
            this.plugin.getLocales().getLocale("delete_player_success", savedUser.get().getUser().getName(), Integer.toString(homesDeleted)).ifPresent(executor::sendMessage);
        });
    }

    private void deleteHomes(@NotNull CommandUser executor, @NotNull String[] args) {
        Map<String, String> filters;
        try {
            filters = this.getBulkDeleteFilters(args);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete homes <world> <server> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        if (!this.parseStringArg(args, 2).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
            this.plugin.getLocales().getLocale("bulk_delete_homes_confirm", filters.get("world"), filters.get("server")).ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            int homesDeleted = this.plugin.getManager().homes().deleteAllHomes((String)filters.get("world"), (String)filters.get("server"));
            this.plugin.getLocales().getLocale("bulk_delete_homes_success", Integer.toString(homesDeleted), (String)filters.get("world"), (String)filters.get("server")).ifPresent(executor::sendMessage);
        });
    }

    private void deleteWarps(@NotNull CommandUser executor, @NotNull String[] args) {
        Map<String, String> filters;
        try {
            filters = this.getBulkDeleteFilters(args);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete warps <world> <server> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        if (!this.parseStringArg(args, 2).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
            this.plugin.getLocales().getLocale("bulk_delete_warps_confirm", filters.get("world"), filters.get("server")).ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            int homesDeleted = this.plugin.getManager().warps().deleteAllWarps((String)filters.get("world"), (String)filters.get("server"));
            this.plugin.getLocales().getLocale("bulk_delete_warps_success", Integer.toString(homesDeleted), (String)filters.get("world"), (String)filters.get("server")).ifPresent(executor::sendMessage);
        });
    }

    @NotNull
    private Map<String, String> getBulkDeleteFilters(@NotNull String[] args) throws IllegalArgumentException {
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put("world", this.parseStringArg(args, 0).orElseThrow(() -> new IllegalArgumentException("World not specified")));
        filters.put("server", this.parseStringArg(args, 1).orElse(this.plugin.getServerName()));
        return filters;
    }

    @NotNull
    private PaginatedList getCommandList(@NotNull CommandUser user) {
        return PaginatedList.of(this.plugin.getCommands().stream().filter(command -> user.hasPermission(command.getPermission(new String[0]))).map(command -> this.plugin.getLocales().getRawLocale("command_list_item", Locales.escapeText(command.getName()), Locales.escapeText(this.plugin.getLocales().truncateText(command.getDescription(), 50)), Locales.escapeText(String.format("%s\n\n%s", command.getUsage(), command.getDescription()))).orElse(command.getName())).collect(Collectors.toList()), this.plugin.getLocales().getBaseList(Math.min(this.plugin.getSettings().getGeneral().getListItemsPerPage(), 6)).setHeaderFormat(this.plugin.getLocales().getRawLocale("command_list_title").orElse("")).setItemSeparator("\n").setCommand("/huskhomes:huskhomes help").build());
    }

    @NotNull
    private PaginatedList getImporterList() {
        return PaginatedList.of(this.plugin.getImporters().stream().map(importer -> this.plugin.getLocales().getRawLocale("importer_list_item", Locales.escapeText(importer.getName()), Locales.escapeText(importer.getSupportedImportData().stream().map(Importer.ImportData::getName).collect(Collectors.joining(", ")))).orElse(importer.getName())).collect(Collectors.toList()), this.plugin.getLocales().getBaseList(Math.min(this.plugin.getSettings().getGeneral().getListItemsPerPage(), 6)).setHeaderFormat(this.plugin.getLocales().getRawLocale("importer_list_title").orElse("")).setItemSeparator("\n").setCommand("/huskhomes:huskhomes import list").build());
    }

    @Override
    @Nullable
    public List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> SUB_COMMANDS.keySet().stream().sorted().toList();
            case 2 -> {
                switch (args[0].toLowerCase()) {
                    case "help": {
                        yield IntStream.rangeClosed(1, this.getCommandList(user).getTotalPages()).mapToObj(Integer::toString).toList();
                    }
                    case "dump": {
                        yield List.of("confirm");
                    }
                    case "homeslots": {
                        yield UserListTabCompletable.super.getUsernameList();
                    }
                    case "import": {
                        yield List.of("start", "list");
                    }
                    case "delete": {
                        yield List.of("player", "homes", "warps");
                    }
                }
                yield null;
            }
            case 3 -> {
                switch (args[0].toLowerCase()) {
                    case "homeslots": {
                        yield List.of("view", "add", "remove", "set");
                    }
                    case "import": {
                        if (!args[1].equalsIgnoreCase("start")) {
                            yield null;
                        }
                        yield this.plugin.getImporters().stream().map(Hook::getName).toList();
                    }
                }
                yield null;
            }
            default -> null;
        };
    }
}

