/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Executable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public abstract class Node
implements Executable {
    protected static final String PERMISSION_PREFIX = "huskhomes.command";
    protected final HuskHomes plugin;
    private final List<String> aliases;
    private boolean operatorCommand = false;

    protected Node(@NotNull List<String> aliases, @NotNull HuskHomes plugin) {
        if (aliases.isEmpty()) {
            throw new IllegalArgumentException("Command name cannot be blank");
        }
        this.aliases = aliases;
        this.plugin = plugin;
    }

    @NotNull
    public String getPermission(String ... child) {
        StringJoiner joiner = new StringJoiner(".").add(PERMISSION_PREFIX).add(this.getName());
        for (String node : child) {
            joiner.add(node);
        }
        return joiner.toString().trim();
    }

    public boolean hasPermission(@NotNull CommandUser executor, String ... child) {
        return executor.hasPermission(this.getPermission(child)) || executor.hasPermission(this.getPermission("*"));
    }

    @NotNull
    public String getName() {
        if (this.aliases.isEmpty()) {
            throw new IllegalStateException("Primary alias of command node is blank");
        }
        return this.aliases.get(0);
    }

    protected Optional<User> resolveUser(@NotNull CommandUser executor, @NotNull String[] args) {
        return this.parseStringArg(args, 0).flatMap(a -> this.plugin.getDatabase().getUser((String)a)).map(SavedUser::getUser).or(() -> {
            if (executor instanceof OnlineUser) {
                OnlineUser online = (OnlineUser)executor;
                return Optional.of(online);
            }
            return Optional.empty();
        });
    }

    protected Optional<Integer> parseIntArg(@NotNull String[] args, int index) {
        try {
            if (args.length > index) {
                return Optional.of(Integer.parseInt(args[index]));
            }
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected Optional<Float> parseFloatArg(@NotNull String[] args, int index) {
        try {
            if (args.length > index) {
                return Optional.of(Float.valueOf(Float.parseFloat(args[index])));
            }
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected Optional<Double> parseCoordinateArg(@NotNull String[] args, int index, double relativeTo) {
        try {
            if (args.length > index) {
                String arg = args[index];
                if (arg.startsWith("~")) {
                    String coordinate = arg.substring(1);
                    if (coordinate.isBlank()) {
                        return Optional.of(relativeTo);
                    }
                    return Optional.of(relativeTo + Double.parseDouble(coordinate));
                }
                return Optional.of(Double.parseDouble(arg));
            }
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected Optional<String> parseStringArg(@NotNull String[] args, int index) {
        if (args.length > index) {
            return Optional.of(args[index]);
        }
        return Optional.empty();
    }

    protected Optional<World> parseWorldArg(@NotNull String[] args, int index) {
        if (args.length > index) {
            String worldName = args[index];
            World.Environment environment = worldName.endsWith("_the_end") ? World.Environment.THE_END : (worldName.endsWith("nether") ? World.Environment.NETHER : World.Environment.OVERWORLD);
            return Optional.of(this.plugin.getWorlds().stream().filter(world -> world.getName().equalsIgnoreCase(worldName)).findFirst().orElse(World.from(worldName, new UUID(0L, 0L), environment)));
        }
        return Optional.empty();
    }

    protected Optional<String> parseGreedyArguments(@NotNull String[] args) {
        if (args.length > 1) {
            StringJoiner sentence = new StringJoiner(" ");
            for (int i = 1; i < args.length; ++i) {
                sentence.add(args[i]);
            }
            return Optional.of(sentence.toString().trim());
        }
        return Optional.empty();
    }

    @NotNull
    protected Position getBasePosition(@NotNull CommandUser executor) {
        Position position;
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            position = user.getPosition();
        } else {
            position = this.plugin.getSpawn().orElse(Position.at(0.0, 0.0, 0.0, 0.0f, 0.0f, this.plugin.getWorlds().get(0), this.plugin.getServerName()));
        }
        return position;
    }

    protected Optional<Position> parsePositionArgs(@NotNull Position basePosition, @NotNull String[] args, int from) {
        Optional<Double> x = this.parseCoordinateArg(args, from, basePosition.getX());
        Optional<Double> y = this.parseCoordinateArg(args, from + 1, basePosition.getY());
        Optional<Double> z = this.parseCoordinateArg(args, from + 2, basePosition.getZ());
        if (x.isEmpty() || y.isEmpty() || z.isEmpty()) {
            return Optional.empty();
        }
        Optional<World> world = this.parseWorldArg(args, from + 3);
        Optional<String> server = this.parseStringArg(args, from + 4);
        int angleStartIndex = world.isEmpty() ? 3 : (server.isEmpty() ? 4 : 5);
        Optional<Float> yaw = this.parseFloatArg(args, from + angleStartIndex);
        Optional<Float> pitch = this.parseFloatArg(args, from + angleStartIndex + 1);
        return Optional.of(Position.at(x.get(), y.get(), z.get(), yaw.orElse(Float.valueOf(basePosition.getYaw())).floatValue(), pitch.orElse(Float.valueOf(basePosition.getPitch())).floatValue(), world.orElse(basePosition.getWorld()), server.orElse(basePosition.getServer())));
    }

    protected Optional<Teleportable> resolveTeleporter(@NotNull CommandUser executor, @NotNull String[] args) {
        return this.parseStringArg(args, 0).map(Teleportable::username).or(() -> executor instanceof Teleportable ? Optional.of((Teleportable)((Object)executor)) : Optional.empty());
    }

    protected Optional<Boolean> parseBooleanArg(@NotNull String[] args, int index) {
        if (args.length <= index) {
            return Optional.empty();
        }
        String arg = args[index].toLowerCase(Locale.ENGLISH);
        if (arg.equals("true") || arg.equals("enable") || arg.equals("on")) {
            return Optional.of(true);
        }
        if (arg.equals("false") || arg.equals("disable") || arg.equals("off")) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public boolean isOperatorCommand() {
        return this.operatorCommand;
    }

    @Generated
    public void setOperatorCommand(boolean operatorCommand) {
        this.operatorCommand = operatorCommand;
    }
}

