/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SetPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class SetHomeCommand
extends SetPositionCommand {
    protected SetHomeCommand(@NotNull HuskHomes plugin) {
        super(List.of("sethome"), plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            if (args.length == 0 && this.createDefaultHome(user)) {
                return;
            }
        }
        super.execute(executor, args);
    }

    @Override
    protected void execute(@NotNull OnlineUser setter, @NotNull String name) {
        this.plugin.fireEvent(this.plugin.getHomeCreateEvent(setter, name, setter.getPosition(), setter), event -> {
            try {
                this.plugin.getManager().homes().createHome(setter, event.getName(), event.getPosition());
            }
            catch (ValidationException e) {
                e.dispatchHomeError(setter, false, this.plugin, event.getName());
                return;
            }
            this.plugin.getLocales().getLocale("set_home_success", event.getName()).ifPresent(setter::sendMessage);
        });
    }

    private boolean createDefaultHome(@NotNull OnlineUser user) {
        Optional<String> name;
        List<Home> homes = this.plugin.getDatabase().getHomes(user);
        Optional<String> optional = homes.isEmpty() ? Optional.of("home") : (name = homes.size() == 1 && this.plugin.getSettings().getGeneral().getNames().isOverwriteExisting() ? Optional.of(homes.get(0).getName()) : Optional.empty());
        if (name.isPresent()) {
            this.execute(user, "home");
            return true;
        }
        return false;
    }
}

