/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class SetSpawnCommand
extends InGameCommand {
    protected SetSpawnCommand(@NotNull HuskHomes plugin) {
        super(List.of("setspawn"), "", plugin);
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull OnlineUser executor, @NotNull String[] args) {
        Position position = executor.getPosition();
        Settings.CrossServerSettings.GlobalSpawnSettings global = this.plugin.getSettings().getCrossServer().getGlobalSpawn();
        try {
            if (this.plugin.getSettings().getCrossServer().isEnabled() && global.isEnabled()) {
                String warpName = global.getWarpName();
                this.plugin.getManager().warps().createWarp(warpName, position, true);
                this.plugin.getLocales().getRawLocale("spawn_warp_default_description").ifPresent(description -> this.plugin.getManager().warps().setWarpDescription(warpName, (String)description));
            } else {
                this.plugin.setServerSpawn(position);
            }
            this.plugin.runSync(() -> this.plugin.setWorldSpawn(position));
        }
        catch (ValidationException e) {
            e.dispatchWarpError(executor, this.plugin, global.getWarpName());
            return;
        }
        this.plugin.getLocales().getLocale("set_spawn_success").ifPresent(executor::sendMessage);
    }
}

