/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.hook.BlueMapHook;
import net.william278.huskhomes.hook.DynmapHook;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.LuckPermsHook;
import net.william278.huskhomes.hook.MapHookProvider;
import net.william278.huskhomes.hook.Pl3xMapHook;
import net.william278.huskhomes.hook.PlanHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Unmodifiable;

public interface HookProvider
extends MapHookProvider {
    @Override
    @NotNull
    public Set<Hook> getHooks();

    default public <H extends Hook> Optional<H> getHook(@NotNull Class<H> hookClass) {
        return this.getHooks().stream().filter(hook -> hookClass.isAssignableFrom(hook.getClass())).map(hookClass::cast).findFirst();
    }

    @NotNull
    default public @Unmodifiable Set<Importer> getImporters() {
        return this.getHooks().stream().filter(hook -> hook instanceof Importer).map(hook -> (Importer)hook).collect(Collectors.toSet());
    }

    default public Optional<Importer> getImporterByName(@NotNull String name) {
        return this.getImporters().stream().filter(i -> i.getName().toLowerCase(Locale.ENGLISH).equals(name.toLowerCase(Locale.ENGLISH))).findFirst();
    }

    public void setHooks(@NotNull Set<Hook> var1);

    default public void loadHooks(PluginHook.Register ... register) {
        Set registers = Arrays.stream(register).collect(Collectors.toSet());
        List<Hook> load = this.getAvailableHooks().stream().filter(h -> registers.contains((Object)h.getRegister())).toList();
        this.getHooks().addAll(load);
    }

    default public void registerHooks(PluginHook.Register ... register) {
        Set registers = Arrays.stream(register).collect(Collectors.toSet());
        this.getHooks().removeIf(hook -> {
            if (!registers.contains((Object)hook.getRegister())) {
                return false;
            }
            try {
                hook.load();
                return false;
            }
            catch (Throwable e) {
                this.getPlugin().log(Level.SEVERE, "Failed to register the %s hook".formatted(hook.getName()), e);
                return true;
            }
        });
        this.getPlugin().log(Level.INFO, "Registered '%s' hooks".formatted(registers.stream().map(h -> h.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" & "))), new Throwable[0]);
    }

    default public void loadAfterLoadHooks() {
        this.getPlugin().runAsyncDelayed(() -> {
            this.loadHooks(PluginHook.Register.AFTER_LOAD);
            this.registerHooks(PluginHook.Register.AFTER_LOAD);
        }, 100L);
    }

    default public void unloadHooks(PluginHook.Register ... register) {
        Set registers = Arrays.stream(register).collect(Collectors.toSet());
        this.getHooks().removeIf(hook -> {
            if (!registers.contains((Object)hook.getRegister())) {
                return false;
            }
            try {
                hook.unload();
            }
            catch (Throwable e) {
                this.getPlugin().log(Level.SEVERE, "Failed to unload the %s hook".formatted(hook.getName()), e);
            }
            return true;
        });
    }

    @NotNull
    default public List<Hook> getAvailableHooks() {
        ArrayList hooks = Lists.newArrayList();
        Settings settings = this.getPlugin().getSettings();
        if (this.isDependencyAvailable("Plan") && settings.getPlan().isEnabled()) {
            hooks.add(new PlanHook(this.getPlugin()));
        }
        if (this.isDependencyAvailable("LuckPerms") && settings.getLuckperms().isEnabled()) {
            hooks.add(new LuckPermsHook(this.getPlugin()));
        }
        if (settings.getMapHook().isEnabled()) {
            if (this.isDependencyAvailable("Dynmap")) {
                hooks.add(new DynmapHook(this.getPlugin()));
            } else if (this.isDependencyAvailable("BlueMap")) {
                hooks.add(new BlueMapHook(this.getPlugin()));
            } else if (this.isDependencyAvailable("Pl3xMap")) {
                hooks.add(new Pl3xMapHook(this.getPlugin()));
            }
        }
        return hooks;
    }

    public boolean isDependencyAvailable(@NotNull String var1);

    @NotNull
    public HuskHomes getPlugin();
}

