/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Map;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.william278.huskhomes.FabricHuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabCompletable;
import net.william278.huskhomes.user.CommandUser;
import org.jetbrains.annotations.NotNull;

public class FabricCommand {
    private final FabricHuskHomes plugin;
    private final Command command;

    public FabricCommand(@NotNull Command command, @NotNull FabricHuskHomes plugin) {
        this.command = command;
        this.plugin = plugin;
    }

    public void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Predicate predicate = Permissions.require((String)this.command.getPermission(new String[0]), (int)(this.command.isOperatorCommand() ? 3 : 0));
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.command.getName()).requires(predicate)).executes(this.getBrigadierExecutor());
        this.plugin.getPermissions().put(this.command.getPermission(new String[0]), this.command.isOperatorCommand());
        if (!this.command.getRawUsage().isBlank()) {
            builder.then((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)this.command.getRawUsage().replaceAll("[<>\\[\\]]", ""), (ArgumentType)StringArgumentType.greedyString()).executes(this.getBrigadierExecutor())).suggests(this.getBrigadierSuggester()));
        }
        Map permissions = this.command.getAdditionalPermissions();
        permissions.forEach((permission, isOp) -> this.plugin.getPermissions().put((String)permission, (Boolean)isOp));
        PermissionCheckEvent.EVENT.register((player, node) -> {
            if (permissions.containsKey(node) && ((Boolean)permissions.get(node)).booleanValue() && player.method_9259(3)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        LiteralCommandNode node2 = dispatcher.register(builder);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"huskhomes:%s".formatted(this.command.getName())).requires(predicate)).executes(this.getBrigadierExecutor())).redirect((CommandNode)node2));
        this.command.getAliases().forEach(alias -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)alias).requires(predicate)).executes(this.getBrigadierExecutor())).redirect((CommandNode)node2));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"huskhomes:%s".formatted(alias)).requires(predicate)).executes(this.getBrigadierExecutor())).redirect((CommandNode)node2));
        });
    }

    private com.mojang.brigadier.Command<class_2168> getBrigadierExecutor() {
        return context -> {
            this.command.onExecuted(this.resolveExecutor((class_2168)context.getSource()), this.command.removeFirstArg(context.getInput().split(" ")));
            return 1;
        };
    }

    private SuggestionProvider<class_2168> getBrigadierSuggester() {
        Command command = this.command;
        if (!(command instanceof TabCompletable)) {
            return (context, builder) -> Suggestions.empty();
        }
        TabCompletable provider = (TabCompletable)command;
        return (context, builder) -> {
            String[] args = this.command.removeFirstArg(context.getInput().split(" ", -1));
            provider.getSuggestions(this.resolveExecutor((class_2168)context.getSource()), args).stream().map(suggestion -> {
                String completedArgs = String.join((CharSequence)" ", args);
                int lastIndex = completedArgs.lastIndexOf(" ");
                if (lastIndex == -1) {
                    return suggestion;
                }
                return completedArgs.substring(0, lastIndex + 1) + suggestion;
            }).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    private CommandUser resolveExecutor(@NotNull class_2168 source) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return this.plugin.getOnlineUser(player);
        }
        return this.plugin.getConsole();
    }
}

