/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2404;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.william278.huskhomes.FabricHuskHomes;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.util.SavePositionProvider;
import org.jetbrains.annotations.NotNull;

public interface FabricSavePositionProvider
extends SavePositionProvider {
    default public CompletableFuture<Optional<Location>> findSafeGroundLocation(@NotNull Location location) {
        MinecraftServer server = ((FabricHuskHomes)this.getPlugin()).getMinecraftServer();
        class_2960 worldId = class_2960.method_12829((String)location.getWorld().getName());
        Optional<class_3218> locationWorld = server.method_29435().stream().filter(key -> key.method_29177().equals((Object)worldId)).findFirst().map(arg_0 -> ((MinecraftServer)server).method_3847(arg_0));
        if (locationWorld.isEmpty()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        class_3218 world = locationWorld.get();
        if (!world.method_8621().method_35317(location.getX(), location.getZ())) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return CompletableFuture.completedFuture(this.findSafeLocationNear(location, world, location.getWorld().getName()));
    }

    private Optional<Location> findSafeLocationNear(@NotNull Location location, @NotNull class_3218 world, @NotNull String worldName) {
        class_2338.class_2339 blockPos = new class_2338.class_2339(location.getX(), location.getY(), location.getZ());
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                blockPos.method_10102(location.getX() + (double)x, location.getY(), location.getZ() + (double)z);
                int highestY = Math.max(this.getMinHeight(world, worldName), Math.min(this.getHighestYAt((class_1922)world, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) + 1, this.getMaxHeight(world, worldName)));
                class_2248 block = world.method_8320(blockPos.method_33096(highestY - 1)).method_26204();
                class_2960 id = class_7923.field_41175.method_10221((Object)block);
                class_2248 bodyBlockType = world.method_8320(blockPos.method_33096(highestY)).method_26204();
                class_2960 bodyBlockId = class_7923.field_41175.method_10221((Object)bodyBlockType);
                class_2248 headBlockType = world.method_8320(blockPos.method_33096(highestY + 1)).method_26204();
                class_2960 headBlockId = class_7923.field_41175.method_10221((Object)headBlockType);
                if (block instanceof class_2404 || block instanceof class_2358 || !this.isBlockSafeForStanding(id.toString()) || !this.isBlockSafeForOccupation(bodyBlockId.toString()) || !this.isBlockSafeForOccupation(headBlockId.toString())) continue;
                double locx = blockPos.method_10263();
                locx = locx < 0.0 ? (locx += 1.5) : (locx += 0.5);
                double locz = blockPos.method_10260();
                locz = locz < 0.0 ? (locz += 1.5) : (locz += 0.5);
                return Optional.of(Location.at((double)locx, (double)highestY, (double)locz, (World)location.getWorld()));
            }
        }
        return Optional.empty();
    }

    private int getHighestYAt(@NotNull class_1922 blockView, int x, int y, int z) {
        class_2338.class_2339 cursor = new class_2338.class_2339(x, y, z);
        while (blockView.method_8320((class_2338)cursor).method_26215() && cursor.method_10264() > blockView.method_31607()) {
            cursor.method_10098(class_2350.field_11033);
        }
        return cursor.method_10264();
    }

    private int getMinHeight(class_3218 world, String worldName) {
        int minHeight = world.method_8597().comp_651();
        for (String pair : this.getPlugin().getSettings().getRtp().getMinHeight()) {
            String settingsWorldName = pair.split(":")[0];
            int settingsHeight = Integer.parseInt(pair.split(":")[1]);
            if (!(settingsWorldName.equals(worldName) & settingsHeight >= minHeight)) continue;
            minHeight = settingsHeight;
        }
        return minHeight;
    }

    private int getMaxHeight(class_3218 world, String worldName) {
        int maxHeight = world.method_8597().comp_652() + world.method_8597().comp_651();
        for (String pair : this.getPlugin().getSettings().getRtp().getMaxHeight()) {
            String settingsWorldName = pair.split(":")[0];
            int settingsHeight = Integer.parseInt(pair.split(":")[1]);
            if (!(settingsWorldName.equals(worldName) & settingsHeight >= maxHeight)) continue;
            maxHeight = settingsHeight;
        }
        return maxHeight;
    }
}

