/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.List;
import net.minecraft.class_2960;
import net.william278.huskhomes.FabricHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.user.FabricUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import org.jetbrains.annotations.NotNull;

@PluginHook(name="Fabric PlaceholderAPI", register=PluginHook.Register.ON_ENABLE)
public class FabricPlaceholderAPIHook
extends Hook {
    public FabricPlaceholderAPIHook(@NotNull FabricHuskHomes plugin) {
        super((HuskHomes)plugin);
    }

    @NotNull
    private class_2960 createIdentifier(@NotNull String name) {
        return class_2960.method_60655((String)"huskhomes", (String)name);
    }

    public void load() {
        Placeholders.register((class_2960)this.createIdentifier("player"), (ctx, arg) -> {
            String response;
            if (!ctx.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            if (arg == null) {
                return PlaceholderResult.invalid((String)"No argument for player!");
            }
            assert (ctx.player() != null);
            FabricUser player = ((FabricHuskHomes)this.plugin).getOnlineUser(ctx.player());
            switch (arg) {
                case "homes_count": {
                    String string = String.valueOf(this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getName(), List.of()).size());
                    break;
                }
                case "max_homes": {
                    String string = String.valueOf(this.plugin.getManager().homes().getMaxHomes((User)player));
                    break;
                }
                case "max_public_homes": {
                    String string = String.valueOf(this.plugin.getManager().homes().getMaxPublicHomes((User)player));
                    break;
                }
                case "free_home_slots": {
                    String string = String.valueOf(this.plugin.getManager().homes().getFreeHomes((User)player));
                    break;
                }
                case "home_slots": {
                    String string = String.valueOf(this.plugin.getSavedUser((User)player).map(SavedUser::getHomeSlots).orElse(0));
                    break;
                }
                case "homes_list": {
                    String string = String.join((CharSequence)", ", this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getName(), List.of()));
                    break;
                }
                case "public_homes_count": {
                    String string = String.valueOf(this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getName(), List.of()).size());
                    break;
                }
                case "public_homes_list": {
                    String string = String.join((CharSequence)", ", this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getName(), List.of()));
                    break;
                }
                case "ignoring_tp_requests": {
                    String string = String.valueOf(this.plugin.getManager().requests().isIgnoringRequests((User)player));
                    break;
                }
                default: {
                    String string = response = null;
                }
            }
            if (response == null) {
                return PlaceholderResult.invalid((String)"Invaild argument for player!");
            }
            return PlaceholderResult.value(response);
        });
    }

    public void unload() {
        Placeholders.remove((class_2960)this.createIdentifier("player"));
    }
}

