/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.math.BigDecimal;
import java.util.concurrent.ExecutionException;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.EconomyHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.user.OnlineUser;
import org.jetbrains.annotations.NotNull;

@PluginHook(name="Impactor Economy", register=PluginHook.Register.ON_LOAD)
public class FabricImpactorEconomyHook
extends EconomyHook {
    private EconomyService economyService;
    private Currency currency;

    public FabricImpactorEconomyHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    public void load() {
        this.economyService = EconomyService.instance();
        if (this.economyService == null) {
            throw new IllegalStateException("Impactor API is not available, No economy service has been registered!");
        }
        this.currency = this.economyService.currencies().primary();
    }

    public void unload() {
        this.economyService = null;
    }

    public double getPlayerBalance(@NotNull OnlineUser player) {
        try {
            Account account = (Account)this.economyService.account(player.getUuid()).get();
            return account.balance().doubleValue();
        }
        catch (InterruptedException | ExecutionException e) {
            return BigDecimal.ZERO.doubleValue();
        }
    }

    public void changePlayerBalance(@NotNull OnlineUser player, double amount) {
        Account account;
        if (amount == 0.0) {
            return;
        }
        try {
            account = (Account)this.economyService.account(player.getUuid()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        double currentBalance = account.balance().doubleValue();
        double amountToChange = Math.abs(currentBalance - Math.max(0.0, currentBalance + amount));
        if (amount < 0.0) {
            account.withdraw(BigDecimal.valueOf(amountToChange));
        } else {
            account.deposit(BigDecimal.valueOf(amountToChange));
        }
    }

    public String formatCurrency(double amount) {
        return PlainTextComponentSerializer.plainText().serialize(this.currency.format(BigDecimal.valueOf(amount)));
    }
}

