/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.william278.huskhomes.FabricHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FabricTask
extends Task {
    public static final ScheduledExecutorService ASYNC_EXEC = Executors.newScheduledThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HuskHomes-ThreadPool").build());

    public static interface Supplier
    extends Task.Supplier {
        @NotNull
        default public Task.Sync getSyncTask(@NotNull Runnable runnable, @Nullable OnlineUser user, long delayTicks) {
            return new Sync(this.getPlugin(), runnable, user, delayTicks);
        }

        @NotNull
        default public Task.Async getAsyncTask(@NotNull Runnable runnable, long delayTicks) {
            return new Async(this.getPlugin(), runnable, delayTicks);
        }

        @NotNull
        default public Task.Repeating getRepeatingTask(@NotNull Runnable runnable, long repeatingTicks) {
            return new Repeating(this.getPlugin(), runnable, repeatingTicks);
        }

        default public void cancelTasks() {
            ASYNC_EXEC.shutdownNow();
        }
    }

    public static class Repeating
    extends Task.Repeating
    implements FabricTask {
        private ScheduledFuture<?> task;

        protected Repeating(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long repeatingTicks) {
            super(plugin, runnable, repeatingTicks);
        }

        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel(true);
            }
            super.cancel();
        }

        public void run() {
            if (!this.cancelled) {
                this.task = ASYNC_EXEC.scheduleAtFixedRate(this.runnable, 0L, this.repeatingTicks * 50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class Async
    extends Task.Async
    implements FabricTask {
        private CompletableFuture<Void> task;

        protected Async(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long delayTicks) {
            super(plugin, runnable, delayTicks);
        }

        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel(true);
            }
            super.cancel();
        }

        public void run() {
            if (!this.cancelled) {
                this.task = CompletableFuture.runAsync(this.runnable, ASYNC_EXEC);
            }
        }
    }

    public static class Sync
    extends Task.Sync
    implements FabricTask {
        protected Sync(@NotNull HuskHomes plugin, @NotNull Runnable runnable, @Nullable OnlineUser user, long delayTicks) {
            super(plugin, runnable, delayTicks);
        }

        public void cancel() {
            super.cancel();
        }

        public void run() {
            if (!this.cancelled) {
                ASYNC_EXEC.schedule(() -> ((FabricHuskHomes)this.getPlugin()).getMinecraftServer().method_40000(this.runnable), this.delayTicks * 50L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

