/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.pokeskies.fabricpluginmessaging.PluginMessageEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import lombok.Generated;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.william278.desertwell.util.Version;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.api.FabricHuskHomesAPI;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.FabricCommand;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.config.Spawn;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.event.FabricEventDispatcher;
import net.william278.huskhomes.hook.FabricHookProvider;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.listener.EventListener;
import net.william278.huskhomes.listener.FabricEventListener;
import net.william278.huskhomes.manager.Manager;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportEngine;
import net.william278.huskhomes.user.ConsoleUser;
import net.william278.huskhomes.user.FabricUserProvider;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.FabricSavePositionProvider;
import net.william278.huskhomes.util.FabricTask;
import net.william278.huskhomes.util.UnsafeBlocks;
import net.william278.toilet.DumpOptions;
import net.william278.toilet.Toilet;
import net.william278.toilet.fabric.FabricToilet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;

public class FabricHuskHomes
implements DedicatedServerModInitializer,
HuskHomes,
FabricTask.Supplier,
FabricEventDispatcher,
FabricSavePositionProvider,
FabricUserProvider,
FabricHookProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"HuskHomes");
    private final ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("huskhomes").orElseThrow(() -> new RuntimeException("Failed to get Mod Container"));
    private final Map<String, Boolean> permissions = Maps.newHashMap();
    private FabricServerAudiences audiences;
    private MinecraftServer minecraftServer;
    private Toilet toilet;
    private final Set<SavedUser> savedUsers = Sets.newHashSet();
    private final Set<UUID> currentlyOnWarmup = Sets.newConcurrentHashSet();
    private final Map<UUID, OnlineUser> onlineUserMap = Maps.newHashMap();
    private final Map<String, List<User>> globalUserList = Maps.newConcurrentMap();
    private final List<Command> commands = Lists.newArrayList();
    private Set<Hook> hooks = Sets.newHashSet();
    private Settings settings;
    private Locales locales;
    private Database database;
    private Manager manager;
    private EventListener eventListener;
    private RandomTeleportEngine randomTeleportEngine;
    private Spawn serverSpawn;
    private UnsafeBlocks unsafeBlocks;
    @Nullable
    private Broker broker;
    @Nullable
    private Server serverName;

    public void onInitializeServer() {
        this.load();
        this.loadCommands();
        ServerLifecycleEvents.SERVER_STARTING.register(this::onEnable);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onDisable);
    }

    private void onEnable(@NotNull MinecraftServer server) {
        this.minecraftServer = server;
        this.toilet = FabricToilet.create((DumpOptions)this.getDumpOptions(), (MinecraftServer)server);
        this.audiences = FabricServerAudiences.of((MinecraftServer)this.minecraftServer);
        this.enable();
    }

    private void onDisable(@NotNull MinecraftServer server) {
        this.shutdown();
        if (this.audiences != null) {
            this.audiences.close();
            this.audiences = null;
        }
    }

    public void loadAPI() {
        FabricHuskHomesAPI.register(this);
    }

    public void loadMetrics() {
    }

    public void disablePlugin() {
        this.onDisable(this.minecraftServer);
    }

    @NotNull
    public ConsoleUser getConsole() {
        return new ConsoleUser(this.audiences.console());
    }

    @NotNull
    public Audience getAudience(@NotNull UUID user) {
        return this.audiences.player(user);
    }

    public void setWorldSpawn(@NotNull Position position) {
        class_3218 world = Adapter.adapt(position, this.minecraftServer);
        if (world != null) {
            world.method_8554(class_2338.method_49637((double)position.getX(), (double)position.getY(), (double)position.getZ()), position.getYaw());
        }
    }

    public Optional<Spawn> getServerSpawn() {
        return Optional.ofNullable(this.serverSpawn);
    }

    @NotNull
    public String getServerName() {
        return this.serverName == null ? "server" : this.serverName.getName();
    }

    @Override
    public boolean isDependencyAvailable(@NotNull String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }

    @Nullable
    public InputStream getResource(@NotNull String name) {
        return this.modContainer.findPath(name).map(path -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                this.log(Level.WARNING, "Failed to load resource: " + name, e);
                return null;
            }
        }).orElse(this.getClass().getClassLoader().getResourceAsStream(name));
    }

    @NotNull
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir().resolve("huskhomes");
    }

    @NotNull
    public List<World> getWorlds() {
        ArrayList worlds = Lists.newArrayList();
        this.minecraftServer.method_3738().forEach(world -> worlds.add(Adapter.adapt((class_1937)world)));
        return worlds;
    }

    @NotNull
    public Version getPluginVersion() {
        return Version.fromString((String)this.modContainer.getMetadata().getVersion().getFriendlyString(), (String)"-");
    }

    @NotNull
    public String getServerType() {
        return String.format("fabric %s/%s", FabricLoader.getInstance().getModContainer("fabricloader").map(l -> l.getMetadata().getVersion().getFriendlyString()).orElse("unknown"), this.minecraftServer.method_3827());
    }

    @NotNull
    public Version getMinecraftVersion() {
        return Version.fromString((String)this.minecraftServer.method_3827());
    }

    public void registerCommands(@NotNull List<Command> toRegister) {
        CommandRegistrationCallback.EVENT.register((dispatcher, i1, i2) -> toRegister.stream().peek(this.commands::add).forEach(command -> new FabricCommand((Command)command, this).register((CommandDispatcher<class_2168>)dispatcher)));
    }

    @NotNull
    public EventListener createListener() {
        return new FabricEventListener(this);
    }

    public Optional<Broker> getBroker() {
        return Optional.ofNullable(this.broker);
    }

    public void setupPluginMessagingChannels() {
        PluginMessageEvent.EVENT.register((payload, context) -> {
            Broker patt0$temp = this.broker;
            if (patt0$temp instanceof PluginMessageBroker) {
                PluginMessageBroker messenger = (PluginMessageBroker)patt0$temp;
                if (this.getSettings().getCrossServer().getBrokerType() == Broker.Type.PLUGIN_MESSAGE) {
                    messenger.onReceive("BungeeCord", (OnlineUser)this.getOnlineUser(context.player()), payload.getData());
                }
            }
        });
    }

    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        LoggingEventBuilder logEvent = LOGGER.makeLoggingEventBuilder(switch (level.getName()) {
            case "WARNING" -> org.slf4j.event.Level.WARN;
            case "SEVERE" -> org.slf4j.event.Level.ERROR;
            default -> org.slf4j.event.Level.INFO;
        });
        if (exceptions.length >= 1) {
            logEvent = logEvent.setCause(exceptions[0]);
        }
        logEvent.log(message);
    }

    public void closeDatabase() {
        if (this.database != null) {
            this.database.close();
        }
    }

    public void closeBroker() {
        if (this.broker != null) {
            this.broker.close();
        }
    }

    @Override
    @NotNull
    public FabricHuskHomes getPlugin() {
        return this;
    }

    @Generated
    public ModContainer getModContainer() {
        return this.modContainer;
    }

    @Generated
    public Map<String, Boolean> getPermissions() {
        return this.permissions;
    }

    @Generated
    public FabricServerAudiences getAudiences() {
        return this.audiences;
    }

    @Generated
    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    @Generated
    public Toilet getToilet() {
        return this.toilet;
    }

    @Generated
    public Set<SavedUser> getSavedUsers() {
        return this.savedUsers;
    }

    @Generated
    public Set<UUID> getCurrentlyOnWarmup() {
        return this.currentlyOnWarmup;
    }

    @Generated
    public Map<UUID, OnlineUser> getOnlineUserMap() {
        return this.onlineUserMap;
    }

    @Generated
    public Map<String, List<User>> getGlobalUserList() {
        return this.globalUserList;
    }

    @Generated
    public List<Command> getCommands() {
        return this.commands;
    }

    @Generated
    public Set<Hook> getHooks() {
        return this.hooks;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public Locales getLocales() {
        return this.locales;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public Manager getManager() {
        return this.manager;
    }

    @Generated
    public EventListener getEventListener() {
        return this.eventListener;
    }

    @Generated
    public RandomTeleportEngine getRandomTeleportEngine() {
        return this.randomTeleportEngine;
    }

    @Generated
    public UnsafeBlocks getUnsafeBlocks() {
        return this.unsafeBlocks;
    }

    @Generated
    public FabricHuskHomes() {
    }

    @Generated
    public void setHooks(Set<Hook> hooks) {
        this.hooks = hooks;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Generated
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Generated
    public void setManager(Manager manager) {
        this.manager = manager;
    }

    @Generated
    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Generated
    public void setRandomTeleportEngine(RandomTeleportEngine randomTeleportEngine) {
        this.randomTeleportEngine = randomTeleportEngine;
    }

    @Generated
    public void setServerSpawn(Spawn serverSpawn) {
        this.serverSpawn = serverSpawn;
    }

    @Generated
    public void setUnsafeBlocks(UnsafeBlocks unsafeBlocks) {
        this.unsafeBlocks = unsafeBlocks;
    }

    @Generated
    public void setBroker(@Nullable Broker broker) {
        this.broker = broker;
    }

    @Generated
    public void setServerName(@Nullable Server serverName) {
        this.serverName = serverName;
    }

    public static class Adapter {
        @NotNull
        public static Location adapt(@NotNull class_243 pos, @NotNull class_1937 world, float yaw, float pitch) {
            return Position.at((double)pos.method_10216(), (double)pos.method_10214(), (double)pos.method_10215(), (float)yaw, (float)pitch, (World)Adapter.adapt(world));
        }

        @NotNull
        public static Position adapt(@NotNull class_243 pos, @NotNull class_1937 world, float yaw, float pitch, @NotNull String server) {
            return Position.at((Location)Adapter.adapt(pos, world, yaw, pitch), (String)server);
        }

        @NotNull
        public static class_5454 adapt(@NotNull Location location, @NotNull MinecraftServer server, @NotNull Consumer<class_1297> runAfterTeleport) {
            return new class_5454(Adapter.adapt(location.getWorld(), server), new class_243(location.getX(), location.getY(), location.getZ()), class_243.field_1353, location.getYaw(), location.getPitch(), runAfterTeleport::accept);
        }

        @Nullable
        public static class_3218 adapt(@NotNull World world, @NotNull MinecraftServer server) {
            return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)world.getName())));
        }

        @Nullable
        public static class_3218 adapt(@NotNull Position position, @NotNull MinecraftServer server) {
            return Adapter.adapt(position.getWorld(), server);
        }

        @NotNull
        public static World adapt(@NotNull class_1937 world) {
            return World.from((String)world.method_27983().method_29177().asMinimalString(), (UUID)UUID.nameUUIDFromBytes(world.method_27983().method_29177().asString().getBytes()));
        }
    }
}

