/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import com.pokeskies.fabricpluginmessaging.PluginMessagePacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.kyori.adventure.audience.Audience;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.william278.huskhomes.FabricHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FabricUser
extends OnlineUser {
    private final String INVULNERABLE_TAG;
    private final class_3222 player;

    private FabricUser(@NotNull class_3222 player, @NotNull FabricHuskHomes plugin) {
        super(player.method_5667(), player.method_7334().getName(), (HuskHomes)plugin);
        this.INVULNERABLE_TAG = this.plugin.getKey(new String[]{"invulnerable"}).asString();
        this.player = player;
    }

    @NotNull
    @ApiStatus.Internal
    public static FabricUser adapt(@NotNull class_3222 player, @NotNull FabricHuskHomes plugin) {
        return new FabricUser(player, plugin);
    }

    public Position getPosition() {
        return FabricHuskHomes.Adapter.adapt(this.player.method_19538(), (class_1937)this.player.method_51469(), this.player.method_36454(), this.player.method_36455(), this.plugin.getServerName());
    }

    public Optional<Position> getBedSpawnPosition() {
        class_2338 spawn = this.player.method_26280();
        float angle = this.player.method_30631();
        class_5321 world = this.player.method_26281();
        if (spawn == null || world == null) {
            return Optional.empty();
        }
        return Optional.of(Position.at((double)spawn.method_10263(), (double)spawn.method_10264(), (double)spawn.method_10260(), (float)angle, (float)0.0f, (World)World.from((String)world.method_29177().asString(), (UUID)UUID.nameUUIDFromBytes(world.method_29177().asString().getBytes())), (String)this.plugin.getServerName()));
    }

    public double getHealth() {
        return this.player.method_6032();
    }

    public boolean isPermissionSet(@NotNull String permission) {
        return Permissions.getPermissionValue((class_1297)this.player, (String)permission) != TriState.DEFAULT;
    }

    public boolean hasPermission(@NotNull String node) {
        boolean op = Boolean.TRUE.equals(((FabricHuskHomes)this.plugin).getPermissions().getOrDefault(node, true));
        return Permissions.check((class_1297)this.player, (String)node, (!op || this.player.method_5687(3) ? 1 : 0) != 0);
    }

    @NotNull
    public Map<String, Boolean> getPermissions() {
        return ((FabricHuskHomes)this.plugin).getPermissions().entrySet().stream().filter(entry -> Permissions.check((class_1297)this.player, (String)((String)entry.getKey()), (boolean)((Boolean)entry.getValue()))).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (Boolean)entry.getValue()), HashMap::putAll);
    }

    @NotNull
    protected List<Integer> getNumericalPermissions(@NotNull String nodePrefix) {
        ArrayList<Integer> permissions = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            if (!this.hasPermission(nodePrefix + i)) continue;
            permissions.add(i);
        }
        return permissions.stream().sorted(Collections.reverseOrder()).toList();
    }

    @NotNull
    public Audience getAudience() {
        return this.player;
    }

    public CompletableFuture<Void> dismount() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.plugin.runSync(() -> {
            this.player.method_5848();
            this.player.method_5685().forEach(class_1297::method_5848);
            future.complete(null);
        }, (OnlineUser)this);
        return future;
    }

    public void teleportLocally(@NotNull Location location, boolean async) throws TeleportationException {
        MinecraftServer server = this.player.method_5682();
        if (server == null) {
            throw new TeleportationException(TeleportationException.Type.ILLEGAL_TARGET_COORDINATES, this.plugin);
        }
        class_3218 world = FabricHuskHomes.Adapter.adapt(location.getWorld(), server);
        if (world == null) {
            throw new TeleportationException(TeleportationException.Type.WORLD_NOT_FOUND, this.plugin);
        }
        this.plugin.runSync(() -> {
            this.player.method_5848();
            this.player.method_5685().forEach(class_1297::method_5848);
            this.player.method_14251(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }, (OnlineUser)this);
    }

    public void sendPluginMessage(byte[] message) {
        ServerPlayNetworking.send((class_3222)this.player, (class_8710)new PluginMessagePacket(message));
    }

    public boolean isMoving() {
        return this.player.method_5799() || this.player.method_6128() || this.player.method_5624() || this.player.method_5715();
    }

    public boolean isVanished() {
        return false;
    }

    public boolean hasInvulnerability() {
        return this.markedAsInvulnerable || this.player.method_5752().contains(this.INVULNERABLE_TAG);
    }

    public void handleInvulnerability() {
        long invulnerableTicks = 20L * (long)this.plugin.getSettings().getGeneral().getTeleportInvulnerabilityTime();
        if (invulnerableTicks <= 0L) {
            return;
        }
        this.player.method_5684(true);
        this.player.method_5752().add(this.INVULNERABLE_TAG);
        this.markedAsInvulnerable = true;
        this.plugin.runSyncDelayed(this::removeInvulnerabilityIfPermitted, (OnlineUser)this, invulnerableTicks);
    }

    public void removeInvulnerabilityIfPermitted() {
        if (this.hasInvulnerability()) {
            this.player.method_5684(false);
        }
        this.player.method_5738(this.INVULNERABLE_TAG);
        this.markedAsInvulnerable = false;
    }

    @NotNull
    public class_3222 getPlayer() {
        return this.player;
    }

    public boolean isValid() {
        return this.player.method_5805();
    }
}

