/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.ConsoleUser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public class BukkitCommand
extends org.bukkit.command.Command {
    private final BukkitHuskHomes plugin;
    private final Command command;

    public BukkitCommand(@NotNull Command command, @NotNull BukkitHuskHomes plugin) {
        super(command.getName(), command.getDescription(), command.getUsage(), command.getAliases());
        this.setPermission(command.getPermission(new String[0]));
        this.command = command;
        this.plugin = plugin;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        CommandUser commandUser;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            commandUser = this.plugin.getOnlineUser(p);
        } else {
            commandUser = this.plugin.getConsole();
        }
        this.command.onExecuted(commandUser, args);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        CommandUser commandUser;
        Command command = this.command;
        if (!(command instanceof TabCompletable)) {
            return List.of();
        }
        TabCompletable completable = (TabCompletable)((Object)command);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            commandUser = this.plugin.getOnlineUser(p);
        } else {
            commandUser = this.plugin.getConsole();
        }
        ConsoleUser user = commandUser;
        return completable.getSuggestions(user, args);
    }

    public void register() {
        this.plugin.getMorePaperLib().commandRegistration().getServerCommandMap().register("huskhomes", (org.bukkit.command.Command)this);
        BukkitCommand.addPermission(this.plugin, this.command.getPermission(new String[0]), this.command.getUsage(), BukkitCommand.getPermissionDefault(this.command.isOperatorCommand()), new Permission[0]);
        this.setPermission(this.command.getPermission(new String[0]));
        List<Permission> childNodes = this.command.getAdditionalPermissions().entrySet().stream().map(entry -> BukkitCommand.addPermission(this.plugin, (String)entry.getKey(), "", BukkitCommand.getPermissionDefault((Boolean)entry.getValue()), new Permission[0])).filter(Objects::nonNull).toList();
        if (!childNodes.isEmpty()) {
            BukkitCommand.addPermission(this.plugin, this.command.getPermission("*"), this.command.getUsage(), PermissionDefault.FALSE, childNodes.toArray(new Permission[0]));
        }
    }

    @Nullable
    protected static Permission addPermission(@NotNull BukkitHuskHomes plugin, @NotNull String node, @NotNull String description, @NotNull PermissionDefault permissionDefault, Permission ... children) {
        Map childNodes = Arrays.stream(children).map(Permission::getName).collect(HashMap::new, (map, child) -> map.put(child, true), HashMap::putAll);
        PluginManager manager = plugin.getServer().getPluginManager();
        if (manager.getPermission(node) != null) {
            return null;
        }
        Permission permission = description.isEmpty() ? new Permission(node, permissionDefault, childNodes) : new Permission(node, description, permissionDefault, childNodes);
        manager.addPermission(permission);
        return permission;
    }

    @NotNull
    protected static PermissionDefault getPermissionDefault(boolean isOperatorCommand) {
        return isOperatorCommand ? PermissionDefault.OP : PermissionDefault.TRUE;
    }
}

