/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.database;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.lang.annotations.Language;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public abstract class Database {
    protected HuskHomes plugin;
    private boolean loaded;

    protected Database(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    @NotNull
    protected final String[] getScript(@NotNull String name) {
        String[] stringArray;
        block8: {
            name = (((String)name).startsWith("database/") ? "" : "database/") + (String)name + (((String)name).endsWith(".sql") ? "" : ".sql");
            InputStream file = Objects.requireNonNull(this.plugin.getResource((String)name), "Invalid script %s".formatted(name));
            try {
                String schema = new String(file.readAllBytes(), StandardCharsets.UTF_8);
                stringArray = this.format(schema).split(";");
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.log(Level.SEVERE, "Failed to load database schema", e);
                    return new String[0];
                }
            }
            file.close();
        }
        return stringArray;
    }

    protected abstract void executeScript(@NotNull Connection var1, @NotNull String var2) throws SQLException;

    @NotNull
    protected final String format(@NotNull @Language(value="SQL") String statement) {
        Pattern pattern = Pattern.compile("%(\\w+)%");
        Matcher matcher = pattern.matcher(statement);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            Table table = Table.match(matcher.group(1));
            matcher.appendReplacement(sb, this.plugin.getSettings().getDatabase().getTableName(table));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected final void backupFlatFile(@NotNull Path file) {
        if (!file.toFile().exists()) {
            return;
        }
        Path backup = file.getParent().resolve(String.format("%s.bak", file.getFileName().toString()));
        try {
            File backupFile = backup.toFile();
            if (!backupFile.exists() || backupFile.delete()) {
                Files.copy(file, backup, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            this.plugin.log(Level.WARNING, "Failed to backup flat file database", e);
        }
    }

    public abstract void initialize() throws IllegalStateException;

    public abstract boolean isCreated();

    protected final void performMigrations(@NotNull Connection connection, @NotNull Type type) throws SQLException {
        int latestVersion;
        int currentVersion = this.getSchemaVersion();
        if (currentVersion < (latestVersion = Migration.getLatestVersion())) {
            this.plugin.log(Level.INFO, "Performing database migrations (Target version: v" + latestVersion + ")", new Throwable[0]);
            for (Migration migration : Migration.getOrderedMigrations()) {
                if (!migration.isSupported(type) || migration.getVersion() <= currentVersion) continue;
                try {
                    this.plugin.log(Level.INFO, "Performing database migration: " + migration.getMigrationName() + " (v" + migration.getVersion() + ")", new Throwable[0]);
                    this.executeScript(connection, "migrations/%s-%s-%s.sql".formatted(migration.getVersion(), type.name().toLowerCase(Locale.ENGLISH), migration.getMigrationName()));
                }
                catch (SQLException e) {
                    this.plugin.log(Level.WARNING, "Migration " + migration.getMigrationName() + " (v" + migration.getVersion() + ") failed; skipping", e);
                }
            }
            this.setSchemaVersion(latestVersion);
            this.plugin.log(Level.INFO, "Completed database migration (Target version: v" + latestVersion + ")", new Throwable[0]);
        }
    }

    public abstract int getSchemaVersion();

    public abstract void setSchemaVersion(int var1);

    protected abstract int setPosition(@NotNull Position var1, @NotNull Connection var2) throws SQLException;

    @ApiStatus.Internal
    protected abstract void updatePosition(int var1, @NotNull Position var2, @NotNull Connection var3) throws SQLException;

    @ApiStatus.Internal
    protected abstract int setSavedPosition(@NotNull SavedPosition var1, @NotNull Connection var2) throws SQLException;

    @ApiStatus.Internal
    protected abstract void updateSavedPosition(int var1, @NotNull SavedPosition var2, @NotNull Connection var3) throws SQLException;

    public abstract void ensureUser(@NotNull User var1);

    public abstract Optional<SavedUser> getUser(@NotNull String var1);

    public abstract Optional<SavedUser> getUser(@NotNull UUID var1);

    public abstract void deleteUser(@NotNull UUID var1);

    public abstract Optional<Instant> getCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2);

    public abstract void setCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2, @NotNull Instant var3);

    public abstract void removeCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2);

    public abstract List<Home> getHomes(@NotNull User var1);

    public abstract List<Warp> getWarps();

    @NotNull
    public final List<Warp> getLocalWarps(@NotNull HuskHomes plugin) {
        return this.getWarps().stream().filter(warp -> warp.getServer().equals(plugin.getServerName())).collect(Collectors.toList());
    }

    public abstract List<Home> getPublicHomes();

    public abstract List<Home> getPublicHomes(@NotNull String var1, boolean var2);

    public List<Home> getPublicHomes(@NotNull String name) {
        return this.getPublicHomes(name, this.plugin.getSettings().getGeneral().getNames().isCaseInsensitive());
    }

    @NotNull
    public final List<Home> getLocalPublicHomes(@NotNull HuskHomes plugin) {
        return this.getPublicHomes().stream().filter(home -> home.getServer().equals(plugin.getServerName())).collect(Collectors.toList());
    }

    public final Optional<Home> getHome(@NotNull User user, @NotNull String homeName) {
        return this.getHome(user, homeName, this.plugin.getSettings().getGeneral().getNames().isCaseInsensitive());
    }

    public abstract Optional<Home> getHome(@NotNull User var1, @NotNull String var2, boolean var3);

    public abstract Optional<Home> getHome(@NotNull UUID var1);

    public final Optional<Warp> getWarp(@NotNull String warpName) {
        return this.getWarp(warpName, this.plugin.getSettings().getGeneral().getNames().isCaseInsensitive());
    }

    public abstract Optional<Warp> getWarp(@NotNull String var1, boolean var2);

    public abstract Optional<Warp> getWarp(@NotNull UUID var1);

    public abstract Optional<Teleport> getCurrentTeleport(@NotNull OnlineUser var1);

    public abstract void updateUserData(@NotNull SavedUser var1);

    public abstract void setCurrentTeleport(@NotNull User var1, @Nullable Teleport var2);

    public final void clearCurrentTeleport(@NotNull User user) {
        this.setCurrentTeleport(user, null);
    }

    public abstract Optional<Position> getLastPosition(@NotNull User var1);

    public abstract void setLastPosition(@NotNull User var1, @NotNull Position var2);

    public abstract Optional<Position> getOfflinePosition(@NotNull User var1);

    public abstract void setOfflinePosition(@NotNull User var1, @NotNull Position var2);

    public abstract Optional<Position> getRespawnPosition(@NotNull User var1);

    public abstract void setRespawnPosition(@NotNull User var1, @Nullable Position var2);

    public abstract void saveHome(@NotNull Home var1);

    public abstract void saveWarp(@NotNull Warp var1);

    public abstract void deleteHome(@NotNull UUID var1);

    public abstract int deleteAllHomes(@NotNull User var1);

    public abstract int deleteAllHomes(@NotNull String var1, @NotNull String var2);

    public abstract void deleteWarp(@NotNull UUID var1);

    public abstract int deleteAllWarps();

    public abstract int deleteAllWarps(@NotNull String var1, @NotNull String var2);

    public abstract void close();

    @Generated
    protected Database(HuskHomes plugin, boolean loaded) {
        this.plugin = plugin;
        this.loaded = loaded;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public static enum Table {
        META_DATA("huskhomes_metadata"),
        PLAYER_DATA("huskhomes_users"),
        PLAYER_COOLDOWNS_DATA("huskhomes_user_cooldowns"),
        POSITION_DATA("huskhomes_position_data"),
        SAVED_POSITION_DATA("huskhomes_saved_positions"),
        HOME_DATA("huskhomes_homes"),
        WARP_DATA("huskhomes_warps"),
        TELEPORT_DATA("huskhomes_teleports");

        @NotNull
        private final String defaultName;

        @NotNull
        public static Table match(@NotNull String placeholder) throws IllegalArgumentException {
            return Table.valueOf(placeholder.toUpperCase(Locale.ENGLISH));
        }

        @NotNull
        public String getDefaultName() {
            return this.defaultName;
        }

        @NotNull
        public static Map<Table, String> getConfigMap() {
            return Arrays.stream(Table.values()).collect(Collectors.toMap(t -> t, Table::getDefaultName, (a, b) -> b, TreeMap::new));
        }

        @Generated
        private Table(String defaultName) {
            if (defaultName == null) {
                throw new NullPointerException("defaultName is marked non-null but is null");
            }
            this.defaultName = defaultName;
        }
    }

    public static enum Migration {
        ADD_METADATA_TABLE(0, "add_metadata_table", Type.MYSQL, Type.MARIADB, Type.POSTGRESQL, Type.SQLITE, Type.H2);

        private final int version;
        private final String migrationName;
        private final Type[] supportedTypes;

        private Migration(@NotNull int version, String migrationName, Type ... supportedTypes) {
            this.version = version;
            this.migrationName = migrationName;
            this.supportedTypes = supportedTypes;
        }

        private int getVersion() {
            return this.version;
        }

        private String getMigrationName() {
            return this.migrationName;
        }

        private boolean isSupported(@NotNull Type type) {
            return Arrays.stream(this.supportedTypes).anyMatch(supportedType -> supportedType == type);
        }

        @NotNull
        public static List<Migration> getOrderedMigrations() {
            return Arrays.stream(Migration.values()).sorted(Comparator.comparingInt(Migration::getVersion)).collect(Collectors.toList());
        }

        public static int getLatestVersion() {
            return Migration.getOrderedMigrations().get(Migration.getOrderedMigrations().size() - 1).getVersion();
        }
    }

    public static enum Type {
        MYSQL("MySQL", "mysql"),
        MARIADB("MariaDB", "mariadb"),
        SQLITE("SQLite", "sqlite"),
        H2("H2", "h2"),
        POSTGRESQL("PostgreSQL", "postgresql");

        private final String displayName;
        private final String protocol;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        private Type(String displayName, String protocol) {
            this.displayName = displayName;
            this.protocol = protocol;
        }
    }
}

