/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.event;

import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.event.Event;
import net.william278.huskhomes.event.IDeleteAllHomesEvent;
import net.william278.huskhomes.event.IDeleteAllWarpsEvent;
import net.william278.huskhomes.event.IHomeCreateEvent;
import net.william278.huskhomes.event.IHomeDeleteEvent;
import net.william278.huskhomes.event.IHomeEditEvent;
import net.william278.huskhomes.event.IHomeListEvent;
import net.william278.huskhomes.event.IReceiveTeleportRequestEvent;
import net.william278.huskhomes.event.IReplyTeleportRequestEvent;
import net.william278.huskhomes.event.ISendTeleportRequestEvent;
import net.william278.huskhomes.event.ITeleportEvent;
import net.william278.huskhomes.event.ITeleportWarmupCancelledEvent;
import net.william278.huskhomes.event.ITeleportWarmupEvent;
import net.william278.huskhomes.event.IWarpCreateEvent;
import net.william278.huskhomes.event.IWarpDeleteEvent;
import net.william278.huskhomes.event.IWarpEditEvent;
import net.william278.huskhomes.event.IWarpListEvent;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.teleport.TimedTeleport;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;

public interface EventDispatcher {
    default public <T extends Event> void fireEvent(@NotNull T event, @Nullable Consumer<T> callback) {
        this.getPlugin().runSync(() -> {
            if (!this.fireIsCancelled(event) && callback != null) {
                this.getPlugin().runAsync(() -> callback.accept(event));
            }
        });
    }

    public <T extends Event> boolean fireIsCancelled(@NotNull T var1);

    @NotNull
    public ITeleportEvent getTeleportEvent(@NotNull Teleport var1);

    @NotNull
    public ITeleportWarmupEvent getTeleportWarmupEvent(@NotNull TimedTeleport var1, int var2);

    @NotNull
    public ITeleportWarmupCancelledEvent getTeleportWarmupCancelledEvent(@NotNull TimedTeleport var1, int var2, int var3, @NotNull ITeleportWarmupCancelledEvent.CancelReason var4);

    @NotNull
    public ISendTeleportRequestEvent getSendTeleportRequestEvent(@NotNull OnlineUser var1, @NotNull TeleportRequest var2);

    @NotNull
    public IReceiveTeleportRequestEvent getReceiveTeleportRequestEvent(@NotNull OnlineUser var1, @NotNull TeleportRequest var2);

    @NotNull
    public IReplyTeleportRequestEvent getReplyTeleportRequestEvent(@NotNull OnlineUser var1, @NotNull TeleportRequest var2);

    @NotNull
    public IHomeCreateEvent getHomeCreateEvent(@NotNull User var1, @NotNull String var2, @NotNull Position var3, @NotNull CommandUser var4);

    @NotNull
    public IHomeEditEvent getHomeEditEvent(@NotNull Home var1, @NotNull Home var2, @NotNull CommandUser var3);

    @NotNull
    public IHomeDeleteEvent getHomeDeleteEvent(@NotNull Home var1, @NotNull CommandUser var2);

    @NotNull
    public IWarpCreateEvent getWarpCreateEvent(@NotNull String var1, @NotNull Position var2, @NotNull CommandUser var3);

    @NotNull
    public IWarpEditEvent getWarpEditEvent(@NotNull Warp var1, @NotNull Warp var2, @NotNull CommandUser var3);

    @NotNull
    public IWarpDeleteEvent getWarpDeleteEvent(@NotNull Warp var1, @NotNull CommandUser var2);

    @NotNull
    public IHomeListEvent getViewHomeListEvent(@NotNull List<Home> var1, @NotNull CommandUser var2, boolean var3);

    @NotNull
    public IWarpListEvent getViewWarpListEvent(@NotNull List<Warp> var1, @NotNull CommandUser var2);

    @NotNull
    public IDeleteAllHomesEvent getDeleteAllHomesEvent(@NotNull User var1, @NotNull CommandUser var2);

    @NotNull
    public IDeleteAllWarpsEvent getDeleteAllWarpsEvent(@NotNull CommandUser var1);

    @NotNull
    public HuskHomes getPlugin();
}

