/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import java.util.UUID;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.World;

public abstract class SavedPosition
extends Position
implements Comparable<SavedPosition> {
    private PositionMeta meta;
    private final UUID uuid;

    protected SavedPosition(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server, @NotNull PositionMeta meta, @NotNull UUID uuid) {
        super(x, y, z, yaw, pitch, world, server);
        this.setMeta(meta);
        this.uuid = uuid;
    }

    protected SavedPosition(@NotNull Position position, @NotNull PositionMeta meta) {
        super(position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch(), position.getWorld(), position.getServer());
        this.setMeta(meta);
        this.uuid = UUID.randomUUID();
    }

    @NotNull
    public PositionMeta getMeta() {
        return this.meta;
    }

    public void setMeta(@NotNull PositionMeta meta) {
        this.meta = meta;
    }

    @NotNull
    public String getName() {
        return this.getMeta().getName();
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public String getSafeIdentifier() {
        return Locales.escapeText(this.getName()).equals(this.getName()) ? this.getName() : this.getUuid().toString();
    }

    @NotNull
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public int compareTo(@NotNull SavedPosition o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SavedPosition) {
            return this.getUuid().equals(((SavedPosition)obj).getUuid());
        }
        return false;
    }
}

