/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.user;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Unmodifiable;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public interface UserProvider {
    @NotNull
    public Map<UUID, OnlineUser> getOnlineUserMap();

    @NotNull
    public Map<String, List<User>> getGlobalUserList();

    @NotNull
    public Set<SavedUser> getSavedUsers();

    @NotNull
    public OnlineUser getOnlineUser(@NotNull UUID var1);

    @NotNull
    default public @Unmodifiable Collection<OnlineUser> getOnlineUsers() {
        return this.getOnlineUserMap().values();
    }

    @NotNull
    default public List<User> getUserList() {
        return Stream.concat(this.getGlobalUserList().values().stream().flatMap(Collection::stream), this.getOnlineUsers().stream().filter(o -> !o.isVanished())).distinct().sorted().toList();
    }

    default public void setUserList(@NotNull String server, @NotNull List<User> players) {
        this.getGlobalUserList().values().forEach(list -> {
            list.removeAll(players);
            list.removeAll(this.getOnlineUsers());
        });
        this.getGlobalUserList().put(server, players);
    }

    default public boolean isUserOnlineGlobally(@NotNull String playerName) {
        return this.getUserList().stream().map(u -> u.getName().toLowerCase(Locale.ENGLISH)).anyMatch(u -> u.equals(playerName.toLowerCase(Locale.ENGLISH)));
    }

    default public Optional<OnlineUser> getOnlineUser(@NotNull String playerName) {
        return this.getOnlineUserExact(playerName).or(() -> this.getOnlineUsers().stream().filter(user -> user.getName().toLowerCase().startsWith(playerName.toLowerCase())).findFirst());
    }

    default public Optional<OnlineUser> getOnlineUserExact(@NotNull String playerName) {
        return this.getOnlineUsers().stream().filter(user -> user.getName().equalsIgnoreCase(playerName)).findFirst();
    }

    default public Optional<SavedUser> getSavedUser(@NotNull User user) {
        return this.getSavedUsers().stream().filter(savedUser -> savedUser.getUser().equals(user)).findFirst();
    }

    default public void editSavedUser(@NotNull User user, @NotNull Consumer<SavedUser> editor) {
        this.getPlugin().runAsync(() -> this.getSavedUser(user).ifPresent(result -> {
            editor.accept((SavedUser)result);
            this.getPlugin().getDatabase().updateUserData((SavedUser)result);
        }));
    }

    @NotNull
    public HuskHomes getPlugin();
}

