/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.Blocking;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.toilet.DumpOptions;
import net.william278.huskhomes.libraries.toilet.Toilet;
import net.william278.huskhomes.libraries.toilet.dump.DumpUser;
import net.william278.huskhomes.libraries.toilet.dump.ExtraFile;
import net.william278.huskhomes.libraries.toilet.dump.PluginInfo;
import net.william278.huskhomes.libraries.toilet.dump.PluginStatus;
import net.william278.huskhomes.libraries.toilet.dump.ProjectMeta;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.StatusLine;

public interface DumpProvider {
    @NotNull
    public static final String BYTEBIN_URL = "https://bytebin.lucko.me";
    @NotNull
    public static final String VIEWER_URL = "https://william278.net/dump";

    @NotNull
    public Toilet getToilet();

    @NotNull
    @Blocking
    default public String createDump(@NotNull CommandUser u) {
        DumpUser dumpUser;
        Toilet toilet = this.getToilet();
        PluginStatus pluginStatus = this.getPluginStatus();
        if (u instanceof OnlineUser) {
            OnlineUser o = (OnlineUser)u;
            dumpUser = new DumpUser(o.getName(), o.getUuid());
        } else {
            dumpUser = null;
        }
        return toilet.dump(pluginStatus, dumpUser, new ExtraFile[0]).toString();
    }

    @NotNull
    default public DumpOptions getDumpOptions() {
        return DumpOptions.builder().bytebinUrl(BYTEBIN_URL).viewerUrl(VIEWER_URL).projectMeta(ProjectMeta.builder().id("huskhomes").name("HuskHomes").version(this.getPlugin().getPluginVersion().toString()).md5("unknown").author("William278").sourceCode("https://github.com/WiIIiam278/HuskHomes").website("https://william278.net/project/huskhomes").support("https://discord.gg/tVYhJfyDWG").build()).fileInclusionRules(List.of(DumpOptions.FileInclusionRule.configFile("config.yml", "Config File"), DumpOptions.FileInclusionRule.configFile("spawn.yml", "Spawn File"), DumpOptions.FileInclusionRule.configFile(this.getMessagesFile(), "Locales File"))).compatibilityRules(List.of(this.getCompatibilityWarning("CMI", "CMI may cause compatibility issues with HuskHomes. If you're using Vault, ensure the CMI-compatible version is in use."), this.getCompatibilityWarning("Essentials", "Command conflicts likely. Check to resolve: https://william278.net/docs/huskhomes/command-conflicts"), this.getCompatibilityWarning("floodgate", "Ensure the home_delimiter is set toa different value from the Bedrock user prefix in Floodgate/Geyser!"))).build();
    }

    @NotNull
    @Blocking
    private PluginStatus getPluginStatus() {
        return PluginStatus.builder().blocks(List.of(this.getSystemStatus(), this.getHookStatus(), this.getPublicHomes(), this.getWarps())).build();
    }

    @NotNull
    @Blocking
    private PluginStatus.MapStatusBlock getSystemStatus() {
        return new PluginStatus.MapStatusBlock(Map.ofEntries(Map.entry("Language", StatusLine.LANGUAGE.getValue(this.getPlugin())), Map.entry("Database Type", StatusLine.DATABASE_TYPE.getValue(this.getPlugin())), Map.entry("Database Local", StatusLine.IS_DATABASE_LOCAL.getValue(this.getPlugin())), Map.entry("Economy Mode", StatusLine.ECONOMY_MODE.getValue(this.getPlugin())), Map.entry("Home Delimiter", StatusLine.HOME_DELIMITER.getValue(this.getPlugin())), Map.entry("Cross Server", StatusLine.IS_CROSS_SERVER.getValue(this.getPlugin())), Map.entry("Server Name", StatusLine.SERVER_NAME.getValue(this.getPlugin())), Map.entry("Message Broker", StatusLine.MESSAGE_BROKER_TYPE.getValue(this.getPlugin())), Map.entry("Redis Sentinel", StatusLine.USING_REDIS_SENTINEL.getValue(this.getPlugin())), Map.entry("Redis Password", StatusLine.USING_REDIS_PASSWORD.getValue(this.getPlugin())), Map.entry("Redis SSL", StatusLine.REDIS_USING_SSL.getValue(this.getPlugin())), Map.entry("Redis Local", StatusLine.IS_REDIS_LOCAL.getValue(this.getPlugin()))), "Plugin Status", "fa6-solid:wrench");
    }

    @NotNull
    @Blocking
    private PluginStatus.ChartStatusBlock getPublicHomes() {
        List<Home> homes = this.getPlugin().getDatabase().getLocalPublicHomes(this.getPlugin());
        Set worlds = homes.stream().map(l -> l.getWorld().getName()).collect(Collectors.toSet());
        return new PluginStatus.ChartStatusBlock(worlds.stream().collect(Collectors.toMap(PluginStatus.ChartKey::new, w -> (int)homes.stream().filter(h -> h.getWorld().getName().equals(w)).count(), Integer::sum)), PluginStatus.ChartType.BAR, "Public Homes by World", "ic:round-home");
    }

    @NotNull
    @Blocking
    private PluginStatus.ChartStatusBlock getWarps() {
        List<Warp> warps = this.getPlugin().getDatabase().getLocalWarps(this.getPlugin());
        Set worlds = warps.stream().map(l -> l.getWorld().getName()).collect(Collectors.toSet());
        return new PluginStatus.ChartStatusBlock(worlds.stream().collect(Collectors.toMap(PluginStatus.ChartKey::new, w -> (int)warps.stream().filter(h -> h.getWorld().getName().equals(w)).count(), Integer::sum)), PluginStatus.ChartType.BAR, "Warps by World", "mdi:location");
    }

    @NotNull
    @Blocking
    private PluginStatus.ListStatusBlock getHookStatus() {
        return new PluginStatus.ListStatusBlock(this.getPlugin().getHooks().stream().map(Hook::getName).toList(), "Loaded Hooks", "fa6-solid:plug");
    }

    @NotNull
    private DumpOptions.CompatibilityRule getCompatibilityWarning(@NotNull String plugin, @NotNull String description) {
        return DumpOptions.CompatibilityRule.builder().labelToApply(new PluginInfo.Label("Warning", "#fcba03", description)).resourceName(plugin).build();
    }

    @NotNull
    private String getMessagesFile() {
        return "messages-%s.yml".formatted(this.getPlugin().getSettings().getLanguage());
    }

    @NotNull
    public HuskHomes getPlugin();
}

