/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.OnlineUser;

public interface Task
extends Runnable {
    @NotNull
    public HuskHomes getPlugin();

    public static interface Supplier {
        @NotNull
        public Sync getSyncTask(@NotNull Runnable var1, @Nullable OnlineUser var2, long var3);

        @NotNull
        public Async getAsyncTask(@NotNull Runnable var1, long var2);

        @NotNull
        public Repeating getRepeatingTask(@NotNull Runnable var1, long var2);

        @NotNull
        default public Sync runSyncDelayed(@NotNull Runnable runnable, @Nullable OnlineUser user, long delayTicks) {
            Sync task = this.getSyncTask(runnable, user, delayTicks);
            task.run();
            return task;
        }

        default public Async runAsyncDelayed(@NotNull Runnable runnable, long delayTicks) {
            Async task = this.getAsyncTask(runnable, delayTicks);
            task.run();
            return task;
        }

        @NotNull
        default public Sync runSync(@NotNull Runnable runnable) {
            return this.runSyncDelayed(runnable, null, 0L);
        }

        @NotNull
        default public Sync runSync(@NotNull Runnable runnable, @NotNull OnlineUser user) {
            return this.runSyncDelayed(runnable, user, 0L);
        }

        @NotNull
        default public Async runAsync(@NotNull Runnable runnable) {
            Async task = this.getAsyncTask(runnable, 0L);
            task.run();
            return task;
        }

        default public <T> CompletableFuture<T> supplyAsync(@NotNull java.util.function.Supplier<T> supplier) {
            CompletableFuture future = new CompletableFuture();
            this.runAsync(() -> {
                try {
                    future.complete(supplier.get());
                }
                catch (Throwable throwable) {
                    future.completeExceptionally(throwable);
                }
            });
            return future;
        }

        public void cancelTasks();

        @NotNull
        public HuskHomes getPlugin();
    }

    public static abstract class Repeating
    extends Base {
        protected final long repeatingTicks;

        protected Repeating(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long repeatingTicks) {
            super(plugin, runnable);
            this.repeatingTicks = repeatingTicks;
        }
    }

    public static abstract class Sync
    extends Base {
        protected long delayTicks;

        protected Sync(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long delayTicks) {
            super(plugin, runnable);
            this.delayTicks = delayTicks;
        }
    }

    public static abstract class Async
    extends Base {
        protected long delayTicks;

        protected Async(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long delayTicks) {
            super(plugin, runnable);
            this.delayTicks = delayTicks;
        }
    }

    public static abstract class Base
    implements Task {
        protected final HuskHomes plugin;
        protected final Runnable runnable;
        protected boolean cancelled = false;

        protected Base(@NotNull HuskHomes plugin, @NotNull Runnable runnable) {
            this.plugin = plugin;
            this.runnable = runnable;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        @NotNull
        public HuskHomes getPlugin() {
            return this.plugin;
        }
    }
}

