/*
 * Decompiled with CFR 0.152.
 */
package ua.lazydev418.echo_compass_hud.gui;

import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ua.lazydev418.echo_compass_hud.enums.DirectionLabel;

public class CompassRenderer {
    private static final ResourceLocation COMPASS_BACKGROUND = new ResourceLocation("echo_compass_hud", "textures/gui/compass_background.png");
    private static final DirectionLabel[] DIRECTIONS = DirectionLabel.values();
    private static final int DIRECTION_COUNT = DIRECTIONS.length;
    private static final int MARKER_SPACING = 50;
    private static final float SCALE = 1.5f;
    private static final int TOTAL_SPAN = DIRECTION_COUNT * 50;
    private static final int BACKGROUND_WIDTH = 250;

    public static void renderBackgroundCompass(GuiGraphics graphics, int centerX) {
        CompassRenderer.filledOverlayBackground(graphics, centerX - 127, 28, centerX + 127, 42);
        CompassRenderer.filledOverlayBackground(graphics, centerX - 127, 0, centerX + 127, 23);
        graphics.m_280163_(COMPASS_BACKGROUND, centerX - 128, 0, 0.0f, 0.0f, 256, 45, 256, 45);
    }

    public static void renderCompass(GuiGraphics graphics, Minecraft mc, int centerX, float yaw) {
        Font font = mc.f_91062_;
        int yPos = 5;
        EnumSet<DirectionLabel> visible = EnumSet.noneOf(DirectionLabel.class);
        float adjustedYaw = (yaw % 360.0f + 360.0f) % 360.0f / 360.0f * (float)TOTAL_SPAN;
        for (int i = -25; i <= 75; i += 5) {
            float pos = (adjustedYaw + (float)i + (float)TOTAL_SPAN) % (float)TOTAL_SPAN;
            int index = (int)(pos / 50.0f) % DIRECTION_COUNT;
            float offset = pos % 50.0f;
            float xPos = (float)centerX - offset * 1.5f + (float)i * 1.5f;
            DirectionLabel label = DIRECTIONS[index];
            if (visible.contains((Object)label)) continue;
            String shortStr = String.valueOf(ChatFormatting.BOLD) + label.getShort().getString();
            CompassRenderer.drawCenteredString(graphics, font, shortStr, xPos, yPos);
            int baseAngle = (index * 45 + 360) % 360;
            visible.add(label);
            for (int j = -2; j <= 2; ++j) {
                float markerX;
                if (j == 0 || !((markerX = xPos + (float)j * 1.5f * 50.0f / 3.0f) >= (float)centerX - 125.0f) || !(markerX <= (float)centerX + 125.0f)) continue;
                String tick = "\u2223";
                String angleStr = String.valueOf((baseAngle + 15 * j + 360) % 360);
                CompassRenderer.drawCenteredString(graphics, font, tick, markerX, yPos);
                CompassRenderer.drawCenteredString(graphics, font, angleStr, markerX, yPos + 9);
            }
        }
    }

    public static void renderInformation(GuiGraphics graphics, Minecraft mc, Player player, int centerX, float yaw) {
        Font font = mc.f_91062_;
        int index = Math.round(yaw / 45.0f) % DIRECTION_COUNT;
        int currentAngle = (int)((yaw % 360.0f + 361.0f) % 360.0f);
        String angleStr = String.valueOf(currentAngle);
        String directionName = DIRECTIONS[index].getFull().getString();
        String coordinates = (int)player.m_20185_() + ", " + (int)player.m_20186_() + ", " + (int)player.m_20189_();
        CompassRenderer.drawCenteredString(graphics, font, directionName, centerX + 67, 31);
        CompassRenderer.drawCenteredString(graphics, font, coordinates, centerX - 67, 31);
        CompassRenderer.drawCenteredString(graphics, font, angleStr, centerX, 31);
    }

    private static void drawCenteredString(GuiGraphics graphics, Font font, String text, float x, int y) {
        graphics.m_280488_(font, text, (int)(x - (float)font.m_92895_(text) / 2.0f), y, 0xFFFFFF);
    }

    private static void filledOverlayBackground(GuiGraphics graphics, int pMinX, int pMinY, int pMaxX, int pMaxY) {
        graphics.m_280509_(pMinX, pMinY, pMaxX, pMaxY, 0x40000000);
    }
}

