/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.playerhealth;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PlayerHealth
extends JavaPlugin
implements Listener {
    private Map<UUID, ArmorStand> playerHealthDisplays = new HashMap<UUID, ArmorStand>();
    private String heartFull;
    private String heartHalf;
    private String heartEmpty;
    private double healthDisplayHeight;
    private BukkitTask positionTask;
    private BukkitTask healthTask;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.cleanupOrphanedArmorStands();
        this.positionTask = new BukkitRunnable(){

            @Override
            public void run() {
                PlayerHealth.this.updateAllArmorStandPositions();
            }
        }.runTaskTimer(this, 0L, 1L);
        this.healthTask = new BukkitRunnable(){

            @Override
            public void run() {
                PlayerHealth.this.updateAllArmorStandHealth();
            }
        }.runTaskTimer(this, 0L, 2L);
        this.getLogger().info("PlayerHealth has been enabled!");
    }

    @Override
    public void onDisable() {
        if (this.positionTask != null) {
            this.positionTask.cancel();
        }
        if (this.healthTask != null) {
            this.healthTask.cancel();
        }
        this.cleanupAllArmorStands();
        this.getLogger().info("PlayerHealth has been disabled!");
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, this::cleanupOrphanedArmorStands, 40L);
    }

    private void loadConfig() {
        this.reloadConfig();
        this.heartFull = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("hearts.full", "&c\u2764"));
        this.heartHalf = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("hearts.half", "&6\ud83d\udc9b"));
        this.heartEmpty = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("hearts.empty", "&7\ud83e\udd0d"));
        this.healthDisplayHeight = this.getConfig().getDouble("health-display-height", 2.3);
    }

    private void cleanupOrphanedArmorStands() {
        int cleaned = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand armorStand;
                if (!(entity instanceof ArmorStand) || (armorStand = (ArmorStand)entity).isVisible() || !armorStand.isMarker() || !armorStand.isSmall() || armorStand.getCustomName() == null || !armorStand.getCustomName().contains("\u2764")) continue;
                boolean hasNearbyPlayer = false;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getWorld().equals(armorStand.getWorld()) || !(player.getLocation().distance(armorStand.getLocation()) < 5.0)) continue;
                    hasNearbyPlayer = true;
                    break;
                }
                if (hasNearbyPlayer) continue;
                armorStand.remove();
                ++cleaned;
            }
        }
        if (cleaned > 0) {
            this.getLogger().info("Cleaned up " + cleaned + " orphaned armor stands");
        }
    }

    private void cleanupAllArmorStands() {
        for (ArmorStand armorStand : this.playerHealthDisplays.values()) {
            if (armorStand == null || armorStand.isDead()) continue;
            armorStand.remove();
        }
        this.playerHealthDisplays.clear();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand armorStand;
                if (!(entity instanceof ArmorStand) || (armorStand = (ArmorStand)entity).isVisible() || !armorStand.isMarker() || !armorStand.isSmall() || armorStand.getCustomName() == null || !armorStand.getCustomName().contains("\u2764")) continue;
                armorStand.remove();
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.setupArmorStandHealth(player), 10L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeArmorStand(player);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.removeArmorStand(player);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.setupArmorStandHealth(player), 20L);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.updateArmorStandHealthDisplay(player), 1L);
        }
    }

    @EventHandler
    public void onPlayerHeal(EntityRegainHealthEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.updateArmorStandHealthDisplay(player), 1L);
        }
    }

    private void setupArmorStandHealth(Player player) {
        this.removeArmorStand(player);
        if (!player.isOnline() || player.isDead()) {
            return;
        }
        try {
            ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(player.getLocation().add(0.0, this.healthDisplayHeight, 0.0), EntityType.ARMOR_STAND);
            armorStand.setVisible(false);
            armorStand.setCustomNameVisible(true);
            armorStand.setGravity(false);
            armorStand.setMarker(true);
            armorStand.setSmall(true);
            armorStand.setBasePlate(false);
            armorStand.setCanPickupItems(false);
            armorStand.setRemoveWhenFarAway(false);
            armorStand.setInvulnerable(true);
            this.updateArmorStandHealthText(player, armorStand);
            this.playerHealthDisplays.put(player.getUniqueId(), armorStand);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to create armor stand for player " + player.getName() + ": " + e.getMessage());
        }
    }

    private void removeArmorStand(Player player) {
        ArmorStand armorStand = this.playerHealthDisplays.remove(player.getUniqueId());
        if (armorStand != null && !armorStand.isDead()) {
            armorStand.remove();
        }
    }

    private void updateAllArmorStandPositions() {
        for (Map.Entry<UUID, ArmorStand> entry : this.playerHealthDisplays.entrySet()) {
            Player player = Bukkit.getPlayer(entry.getKey());
            ArmorStand armorStand = entry.getValue();
            if (player != null && player.isOnline() && !player.isDead()) {
                if (armorStand != null && !armorStand.isDead()) {
                    try {
                        armorStand.teleport(player.getLocation().add(0.0, this.healthDisplayHeight, 0.0));
                    }
                    catch (Exception e) {
                        this.setupArmorStandHealth(player);
                    }
                    continue;
                }
                this.setupArmorStandHealth(player);
                continue;
            }
            if (armorStand != null && !armorStand.isDead()) {
                armorStand.remove();
            }
            this.playerHealthDisplays.remove(entry.getKey());
        }
    }

    private void updateAllArmorStandHealth() {
        for (Map.Entry<UUID, ArmorStand> entry : this.playerHealthDisplays.entrySet()) {
            Player player = Bukkit.getPlayer(entry.getKey());
            ArmorStand armorStand = entry.getValue();
            if (player == null || !player.isOnline() || player.isDead() || armorStand == null || armorStand.isDead()) continue;
            this.updateArmorStandHealthText(player, armorStand);
        }
    }

    private void updateArmorStandHealthDisplay(Player player) {
        ArmorStand armorStand = this.playerHealthDisplays.get(player.getUniqueId());
        if (armorStand != null && !armorStand.isDead() && player.isOnline() && !player.isDead()) {
            this.updateArmorStandHealthText(player, armorStand);
        }
    }

    private void updateArmorStandHealthText(Player player, ArmorStand armorStand) {
        if (armorStand != null && !armorStand.isDead() && player.isOnline() && !player.isDead()) {
            String healthDisplay = this.getHealthDisplay(player);
            String displayText = String.valueOf((Object)ChatColor.RED) + "\u2764 " + healthDisplay + String.valueOf((Object)ChatColor.GRAY) + " (" + String.format("%.0f", player.getHealth()) + "/" + String.format("%.0f", player.getMaxHealth()) + ")";
            armorStand.setCustomName(displayText);
        }
    }

    private String getHealthDisplay(Player player) {
        double health = player.getHealth();
        double maxHealth = player.getMaxHealth();
        double hearts = health / 2.0;
        double maxHearts = maxHealth / 2.0;
        StringBuilder display = new StringBuilder();
        int fullHearts = (int)Math.floor(hearts);
        for (int i = 0; i < fullHearts; ++i) {
            display.append(this.heartFull);
        }
        if (hearts - (double)fullHearts >= 0.5) {
            display.append(this.heartHalf);
            ++fullHearts;
        }
        int emptyHearts = (int)maxHearts - fullHearts;
        for (int i = 0; i < emptyHearts; ++i) {
            display.append(this.heartEmpty);
        }
        return display.toString();
    }

    private void cleanupAllTeamPrefixes() {
        try {
            Scoreboard mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            for (Team team : mainScoreboard.getTeams()) {
                if (!team.getName().startsWith("health_")) continue;
                team.unregister();
            }
            this.getLogger().info("All health-related team prefixes have been cleaned up!");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to cleanup team prefixes: " + e.getMessage());
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("playerhealth")) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (sender.hasPermission("playerhealth.reload")) {
                        if (this.positionTask != null) {
                            this.positionTask.cancel();
                        }
                        if (this.healthTask != null) {
                            this.healthTask.cancel();
                        }
                        this.cleanupAllArmorStands();
                        this.loadConfig();
                        this.positionTask = new BukkitRunnable(){

                            @Override
                            public void run() {
                                PlayerHealth.this.updateAllArmorStandPositions();
                            }
                        }.runTaskTimer(this, 0L, 1L);
                        this.healthTask = new BukkitRunnable(){

                            @Override
                            public void run() {
                                PlayerHealth.this.updateAllArmorStandHealth();
                            }
                        }.runTaskTimer(this, 0L, 2L);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            this.setupArmorStandHealth(player);
                        }
                        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "PlayerHealth configuration reloaded!");
                        return true;
                    }
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to reload the configuration!");
                    return true;
                }
                if (args[0].equalsIgnoreCase("cleanup")) {
                    if (sender.hasPermission("playerhealth.admin")) {
                        this.cleanupAllTeamPrefixes();
                        this.cleanupOrphanedArmorStands();
                        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "All PlayerHealth prefixes and orphaned armor stands have been cleaned up!");
                        return true;
                    }
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command!");
                    return true;
                }
                if (args[0].equalsIgnoreCase("recreate")) {
                    if (sender.hasPermission("playerhealth.admin")) {
                        this.cleanupAllArmorStands();
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            this.setupArmorStandHealth(player);
                        }
                        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "All armor stands have been recreated!");
                        return true;
                    }
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command!");
                    return true;
                }
            }
            if (sender.hasPermission("playerhealth.use")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "=== PlayerHealth Commands ===");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/playerhealth reload" + String.valueOf((Object)ChatColor.GRAY) + " - Reload configuration");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/playerhealth cleanup" + String.valueOf((Object)ChatColor.GRAY) + " - Remove orphaned armor stands and old prefixes");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/playerhealth recreate" + String.valueOf((Object)ChatColor.GRAY) + " - Recreate all armor stands");
                return true;
            }
        }
        return false;
    }
}

