/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.wispforest.owo.ui.util.Delta;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import rearth.oracle.Oracle;
import rearth.oracle.SemanticSearch;
import rearth.oracle.progress.AdvancementProgressValidator;
import rearth.oracle.ui.OracleScreen;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.util.MarkdownParser;

public final class OracleClient {
    public static final class_304 ORACLE_WIKI = new class_304("key.oracle_index.open", 72, "key.categories.oracle");
    public static final class_304 ORACLE_SEARCH = new class_304("key.oracle_index.search", -1, "key.categories.oracle");
    public static final Set<String> LOADED_BOOKS = new HashSet<String>();
    public static final HashMap<class_2960, BookItemLink> ITEM_LINKS = new HashMap();
    public static final HashMap<String, class_3545<String, String>> UNLOCK_CRITERIONS = new HashMap();
    public static class_1799 tooltipStack;
    public static float openEntryProgress;
    private static SemanticSearch searchInstance;

    public static void init() {
        Oracle.LOGGER.info("Hello from the Oracle Wiki Client!");
        KeyMappingRegistry.register((class_304)ORACLE_WIKI);
        KeyMappingRegistry.register((class_304)ORACLE_SEARCH);
        AdvancementProgressValidator.register();
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (ORACLE_WIKI.method_1436()) {
                if (class_437.method_25441()) {
                    Oracle.LOGGER.info("Opening Oracle Search...");
                    client.method_1507((class_437)new SearchScreen(client.field_1755));
                    return;
                }
                Oracle.LOGGER.info("Opening Oracle Wiki...");
                client.method_1507((class_437)new OracleScreen(client.field_1755));
            }
            if (ORACLE_SEARCH.method_1436()) {
                Oracle.LOGGER.info("Opening Oracle Search...");
                client.method_1507((class_437)new SearchScreen(client.field_1755));
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(client -> {
            Oracle.LOGGER.info("Indexing entry items...");
            OracleClient.findAllResourceEntries();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (class_437.method_25443()) {
                return;
            }
            openEntryProgress += Delta.compute((float)openEntryProgress, (float)0.0f, (float)0.13f);
        });
    }

    public static void openScreen(@Nullable String bookId, @Nullable class_2960 entryId, @Nullable class_437 parent) {
        if (bookId != null) {
            OracleScreen.activeBook = bookId;
        }
        if (entryId != null) {
            OracleScreen.activeEntry = entryId;
        }
        class_310.method_1551().method_1507((class_437)new OracleScreen(parent));
    }

    private static void findAllResourceEntries() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Map resources = resourceManager.method_14488("books", path -> path.method_12832().endsWith(".mdx"));
        LOADED_BOOKS.clear();
        for (class_2960 resourceId : resources.keySet()) {
            String entryFileName;
            String[] segments;
            String modId;
            String purePath = resourceId.method_12832().replaceFirst("books/", "");
            String entryPath = purePath.replaceFirst((modId = (segments = purePath.split("/"))[0]) + "/", "");
            String entryDirectory = entryPath.replace(entryFileName = segments[segments.length - 1], "");
            if (entryDirectory.startsWith(".translated")) continue;
            try {
                String unlockText;
                String[] unlockParts;
                String fileContent = new String(((class_3298)resources.get(resourceId)).method_14482().readAllBytes(), StandardCharsets.UTF_8);
                Map<String, String> fileComponents = MarkdownParser.parseFrontmatter(fileContent);
                if (fileComponents.containsKey("related_items")) {
                    String[] itemStrings;
                    String baseString = fileComponents.get("related_items").replace("[", "").replace("]", "");
                    for (String itemString : itemStrings = baseString.split(", ")) {
                        class_2960 itemId = class_2960.method_60654((String)itemString);
                        BookItemLink linkData = new BookItemLink(resourceId, fileComponents.getOrDefault("title", "missing"), modId);
                        ITEM_LINKS.put(itemId, linkData);
                    }
                }
                if (fileComponents.containsKey("unlock") && (unlockParts = (unlockText = fileComponents.get("unlock")).split(":", 2)).length == 2) {
                    String unlockType = unlockParts[0];
                    String unlockContent = unlockParts[1];
                    UNLOCK_CRITERIONS.put(resourceId.method_12832(), (class_3545<String, String>)new class_3545((Object)unlockType, (Object)unlockContent));
                }
            }
            catch (IOException e) {
                Oracle.LOGGER.error("Unable to load book with id: " + String.valueOf(resourceId));
                throw new RuntimeException(e);
            }
            LOADED_BOOKS.add(modId);
        }
    }

    public static SemanticSearch getOrCreateSearch() {
        if (searchInstance == null) {
            searchInstance = new SemanticSearch();
        }
        return searchInstance;
    }

    public static String getActiveLangCode() {
        return class_310.method_1551().method_1526().method_4669();
    }

    public static Optional<class_2960> getTranslatedPath(class_2960 identifier, String bookId) {
        class_2960 translatedPath;
        String languageCode = OracleClient.getActiveLangCode();
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (!languageCode.startsWith("en_") && resourceManager.method_14486(translatedPath = class_2960.method_60655((String)identifier.method_12836(), (String)identifier.method_12832().replace("books/" + bookId, "books/" + bookId + "/.translated/" + languageCode))).isPresent()) {
            return Optional.of(translatedPath);
        }
        return Optional.empty();
    }

    static {
        openEntryProgress = 0.0f;
    }

    public record BookItemLink(class_2960 linkTarget, String entryName, String bookId) {
    }
}

