/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.progress.OracleProgressAPI;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.ui.components.ColoredCollapsibleContainer;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.MarkdownParser;

public class OracleScreen
extends BaseOwoScreen<FlowLayout> {
    private FlowLayout navigationBar;
    private FlowLayout contentContainer;
    private FlowLayout rootComponent;
    private FlowLayout leftPanel;
    private ScrollContainer<FlowLayout> outerContentContainer;
    private final class_437 parent;
    private boolean needsLayout = false;
    public static class_2960 activeEntry;
    public static String activeBook;
    private static final int wideContentWidth = 50;

    public OracleScreen() {
        this.parent = null;
    }

    public OracleScreen(class_437 parent) {
        this.parent = parent;
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.blur((float)4.0f, (float)48.0f));
        rootComponent.child(Components.box((Sizing)Sizing.fill(), (Sizing)Sizing.fill()).color(new Color(0.1f, 0.1f, 0.15f, 0.9f)).fill(true).zIndex(-1).positioning(Positioning.absolute((int)0, (int)0)));
        rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
        rootComponent.verticalAlignment(VerticalAlignment.CENTER);
        this.rootComponent = rootComponent;
        this.leftPanel = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill());
        this.leftPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        this.navigationBar = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content((int)3));
        this.navigationBar.surface(MarkdownParser.ORACLE_PANEL_DARK);
        this.navigationBar.padding(Insets.of((int)9, (int)5, (int)5, (int)5));
        rootComponent.child((Component)this.leftPanel);
        this.contentContainer = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content((int)3));
        this.contentContainer.horizontalSizing(Sizing.fill());
        this.contentContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.contentContainer.margins(Insets.of((int)2, (int)2, (int)4, (int)4));
        this.contentContainer.padding(Insets.of((int)20, (int)25, (int)0, (int)0));
        this.contentContainer.allowOverflow(true);
        this.outerContentContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)50), (Sizing)Sizing.fill(), (Component)this.contentContainer);
        this.outerContentContainer.allowOverflow(true);
        rootComponent.child(this.outerContentContainer);
        this.buildModNavigation(this.leftPanel);
        ScrollContainer outerNavigationBarContainer = Containers.verticalScroll((Sizing)Sizing.content((int)3), (Sizing)Sizing.fill((int)80), (Component)this.navigationBar);
        this.leftPanel.child((Component)outerNavigationBarContainer);
        FlowLayout searchContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        searchContainer.surface(MarkdownParser.ORACLE_PANEL);
        searchContainer.margins(Insets.of((int)6, (int)6, (int)6, (int)6));
        searchContainer.padding(Insets.of((int)4, (int)6, (int)4, (int)4));
        searchContainer.positioning(Positioning.relative((int)99, (int)99));
        searchContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            class_310.method_1551().method_1507((class_437)new SearchScreen((class_437)this));
            return true;
        });
        searchContainer.mouseEnter().subscribe(() -> searchContainer.surface(MarkdownParser.ORACLE_PANEL_HOVER));
        searchContainer.mouseLeave().subscribe(() -> searchContainer.surface(MarkdownParser.ORACLE_PANEL));
        ItemComponent searchIcon = Components.item((class_1799)new class_1799((class_1935)class_1802.field_27070));
        searchIcon.sizing(Sizing.fixed((int)24));
        searchIcon.tooltip((class_2561)class_2561.method_43469((String)"tooltip.oracle_index.open_search", (Object[])new Object[]{OracleClient.ORACLE_WIKI.method_16007(), OracleClient.ORACLE_SEARCH.method_16007()}));
        searchContainer.child((Component)searchIcon);
        rootComponent.child(searchContainer.zIndex(5));
    }

    protected void method_25426() {
        super.method_25426();
        this.updateLayout();
    }

    private void updateLayout() {
        boolean wideEnough;
        int leftOffset = Math.max(15, this.field_22789 / 20);
        int leftPanelSize = this.leftPanel.width();
        int leftPanelEnd = this.leftPanel.x() + this.leftPanel.width();
        float innerPanelWideLeft = (float)this.field_22789 * 0.5f - (float)(this.field_22789 * 50) / 100.0f / 2.0f;
        boolean bl = wideEnough = this.field_22789 >= 650;
        if ((float)leftPanelEnd > innerPanelWideLeft + 30.0f) {
            wideEnough = false;
        }
        if (wideEnough) {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
            this.leftPanel.positioning(Positioning.relative((int)0, (int)0));
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)leftOffset, (int)(leftOffset / 2)));
            this.outerContentContainer.positioning(Positioning.relative((int)60, (int)50));
            this.outerContentContainer.horizontalSizing(Sizing.fill((int)50));
        } else {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
            this.leftPanel.positioning(Positioning.layout());
            this.outerContentContainer.positioning(Positioning.layout());
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)10, (int)5));
            this.outerContentContainer.horizontalSizing(Sizing.fixed((int)(this.field_22789 - leftPanelSize - 20)));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.needsLayout) {
            this.needsLayout = false;
            this.updateLayout();
        }
        if (class_437.method_25441()) {
            Oracle.LOGGER.info("Opening Oracle Search...");
            Objects.requireNonNull(this.field_22787).method_1507((class_437)new SearchScreen((class_437)this));
        }
    }

    private void loadContentContainer(class_2960 filePath, String bookId) throws IOException {
        class_3300 resourceManager;
        Optional resourceCandidate;
        this.contentContainer.clearChildren();
        activeEntry = filePath;
        Optional<class_2960> translatedPath = OracleClient.getTranslatedPath(filePath, bookId);
        if (translatedPath.isPresent()) {
            filePath = translatedPath.get();
        }
        if ((resourceCandidate = (resourceManager = class_310.method_1551().method_1478()).method_14486(filePath)).isEmpty()) {
            System.out.println("No content file found for " + String.valueOf(filePath));
            return;
        }
        String fileContent = new String(((class_3298)resourceCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
        class_2960 finalFilePath = filePath;
        List<Component> parsedTexts = MarkdownParser.parseMarkdownToOwoComponents(fileContent, bookId, link -> {
            if (link.startsWith("http")) {
                return false;
            }
            String[] pathSegments = finalFilePath.method_12832().split("/");
            Object newPath = "";
            int parentIteration = link.startsWith("../") ? 1 : 0;
            for (int i = 0; i < pathSegments.length - 1 - parentIteration; ++i) {
                newPath = (String)newPath + pathSegments[i] + "/";
            }
            newPath = ((String)newPath).split("#")[0];
            newPath = (String)newPath + link.replace("../", "") + ".mdx";
            class_2960 newId = class_2960.method_60655((String)"oracle_index", (String)newPath);
            try {
                this.loadContentContainer(newId, bookId);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        });
        for (Component paragraph : parsedTexts) {
            if (paragraph instanceof LabelComponent) {
                paragraph.horizontalSizing(Sizing.fill());
            } else if (paragraph instanceof TextureComponent) {
                TextureComponent textureComponent = (TextureComponent)paragraph;
                ratio = (float)((PositionedRectangle)textureComponent.visibleArea().get()).width() / (float)((PositionedRectangle)textureComponent.visibleArea().get()).height();
                targetSize = (float)((Sizing)textureComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.field_22789 * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                textureComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            } else if (paragraph instanceof ItemComponent) {
                ItemComponent itemComponent = (ItemComponent)paragraph;
                ratio = 1.0f;
                targetSize = (float)((Sizing)itemComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.field_22789 * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                itemComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            }
            if (((Insets)paragraph.margins().get()).equals((Object)Insets.of((int)0))) {
                paragraph.margins(Insets.of((int)4, (int)1, (int)0, (int)0));
            }
            this.contentContainer.child(paragraph);
        }
    }

    private void buildModNavigation(FlowLayout buttonContainer) {
        List bookIds = OracleClient.LOADED_BOOKS.stream().sorted().toList();
        DropdownComponent modSelectorDropdown = Components.dropdown((Sizing)Sizing.content((int)3));
        modSelectorDropdown.zIndex(5);
        if (activeBook == null) {
            activeBook = (String)bookIds.getFirst();
        }
        if (activeEntry != null) {
            try {
                this.loadContentContainer(activeEntry, activeBook);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int topMargins = 40;
        if (this.field_22790 < 350) {
            topMargins = 5;
        }
        ScalableLabelComponent bookTitleLabel = new ScalableLabelComponent((class_2561)class_2561.method_43471((String)("oracle_index.title." + activeBook)).method_27692(class_124.field_1063).method_27693(" >").method_27692(class_124.field_1063), text -> false);
        bookTitleLabel.scale = 1.5f;
        FlowLayout bookTitleWrapper = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL);
        bookTitleWrapper.padding(Insets.of((int)8));
        bookTitleWrapper.margins(Insets.of((int)topMargins, (int)-7, (int)0, (int)0));
        bookTitleWrapper.child((Component)bookTitleLabel);
        buttonContainer.child(bookTitleWrapper.zIndex(5));
        bookTitleWrapper.mouseEnter().subscribe(() -> bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL_HOVER));
        bookTitleWrapper.mouseLeave().subscribe(() -> bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL));
        bookTitleWrapper.mouseDown().subscribe((a, b, c) -> {
            if (modSelectorDropdown.hasParent()) {
                modSelectorDropdown.remove();
                return true;
            }
            this.rootComponent.child((Component)modSelectorDropdown.positioning(Positioning.absolute((int)(bookTitleWrapper.x() + bookTitleWrapper.width()), (int)bookTitleWrapper.y())));
            return true;
        });
        for (String bookId : bookIds) {
            modSelectorDropdown.button((class_2561)class_2561.method_43471((String)("oracle_index.title." + bookId)), elem -> {
                activeEntry = null;
                modSelectorDropdown.remove();
                this.buildModNavigationBar(bookId);
                bookTitleLabel.text((class_2561)class_2561.method_43471((String)("oracle_index.title." + bookId)).method_27692(class_124.field_1063).method_27693(" >").method_27692(class_124.field_1063));
                activeBook = bookId;
            });
        }
        this.buildModNavigationBar(activeBook);
    }

    private void buildModNavigationBar(String bookId) {
        this.navigationBar.clearChildren();
        this.buildNavigationEntriesForModPath(bookId, "", this.navigationBar);
    }

    private boolean buildNavigationEntriesForModPath(String bookId, String path, FlowLayout container) {
        Optional resourceCandidate;
        class_3300 resourceManager = class_310.method_1551().method_1478();
        class_2960 metaPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + bookId + path + "/_meta.json"));
        Optional<class_2960> translatedMetaPath = OracleClient.getTranslatedPath(metaPath, bookId);
        if (translatedMetaPath.isPresent()) {
            metaPath = translatedMetaPath.get();
        }
        if ((resourceCandidate = resourceManager.method_14486(metaPath)).isEmpty()) {
            System.out.println("No _meta.json found for " + bookId + " at " + String.valueOf(metaPath));
            return false;
        }
        boolean anyUnlocked = false;
        try {
            Optional<MetaJsonEntry> firstEntry;
            String metaFile = new String(((class_3298)resourceCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
            List<MetaJsonEntry> entries = OracleScreen.parseJson(metaFile);
            if (activeEntry == null && (firstEntry = entries.stream().filter(elem -> !elem.directory).findFirst()).isPresent()) {
                class_2960 firstEntryPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + bookId + path + "/" + firstEntry.get().id()));
                this.loadContentContainer(firstEntryPath, bookId);
                activeEntry = firstEntryPath;
            }
            ArrayList<ColoredCollapsibleContainer> levelContainers = new ArrayList<ColoredCollapsibleContainer>();
            for (MetaJsonEntry entry : entries) {
                if (entry.directory) {
                    ColoredCollapsibleContainer directoryContainer = new ColoredCollapsibleContainer(Sizing.content((int)1), Sizing.content((int)1), (class_2561)class_2561.method_43471((String)entry.name()).method_27692(class_124.field_1068), false);
                    boolean anyChildrenUnlocked = this.buildNavigationEntriesForModPath(bookId, path + "/" + entry.id(), (FlowLayout)directoryContainer);
                    if (anyChildrenUnlocked) {
                        anyUnlocked = true;
                    }
                    directoryContainer.margins(Insets.of((int)0, (int)0, (int)0, (int)0));
                    directoryContainer.mouseDown().subscribe((a, b, c) -> {
                        for (ColoredCollapsibleContainer elem : levelContainers) {
                            if (elem == directoryContainer || !elem.expanded()) continue;
                            elem.toggleExpansion();
                        }
                        this.needsLayout = true;
                        return false;
                    });
                    if (!anyChildrenUnlocked) continue;
                    container.child((Component)directoryContainer);
                    levelContainers.add(directoryContainer);
                    continue;
                }
                class_2960 labelPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + bookId + path + "/" + entry.id()));
                class_5250 labelText = class_2561.method_43471((String)entry.name).method_27692(class_124.field_1068);
                LabelComponent label = Components.label((class_2561)labelText.method_27692(class_124.field_1073));
                boolean isUnlocked = true;
                if (OracleClient.UNLOCK_CRITERIONS.containsKey(labelPath.method_12832())) {
                    class_3545<String, String> unlockData = OracleClient.UNLOCK_CRITERIONS.get(labelPath.method_12832());
                    isUnlocked = OracleProgressAPI.IsUnlocked(bookId, labelPath.method_12832(), (String)unlockData.method_15442(), (String)unlockData.method_15441());
                }
                if (isUnlocked) {
                    anyUnlocked = true;
                    label.mouseEnter().subscribe(() -> label.text((class_2561)labelText.method_27661().method_27692(class_124.field_1080)));
                    label.mouseLeave().subscribe(() -> label.text((class_2561)labelText.method_27661()));
                    label.mouseDown().subscribe((a, b, c) -> {
                        try {
                            this.loadContentContainer(labelPath, bookId);
                            return true;
                        }
                        catch (IOException e) {
                            Oracle.LOGGER.error(e.getMessage());
                            return false;
                        }
                    });
                } else {
                    label.text((class_2561)labelText.method_27692(class_124.field_1051));
                }
                label.margins(Insets.of((int)3, (int)2, (int)5, (int)2));
                container.child((Component)label);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return anyUnlocked;
    }

    private static List<MetaJsonEntry> parseJson(String jsonString) {
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        ArrayList<MetaJsonEntry> entries = new ArrayList<MetaJsonEntry>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            boolean directory;
            String id = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            boolean bl = directory = !id.endsWith(".mdx");
            String name = value instanceof JsonPrimitive ? value.getAsString() : (value instanceof JsonObject ? ((JsonObject)value).get("name").getAsString() : "Unknown Name");
            entries.add(new MetaJsonEntry(id, name, directory));
        }
        return entries;
    }

    public record MetaJsonEntry(String id, String name, boolean directory) {
        @Override
        public String toString() {
            return "MetaJsonEntry{id='" + this.id + "', name='" + this.name + "', directory=" + this.directory + "}";
        }
    }
}

