/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.ValidationResult;
import org.jetbrains.annotations.NotNull;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.SemanticSearch;
import rearth.oracle.progress.OracleProgressAPI;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.MarkdownParser;

public class SearchScreen
extends BaseOwoScreen<FlowLayout> {
    private FlowLayout resultsPanel;
    private int waitFrames = 0;
    private final class_437 parent;
    private static final String MATH_EXPR_REGEX = "^[\\d\\s+\\-*/%().]+$";
    private TextBoxComponent searchBar;

    public SearchScreen(class_437 parent) {
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.blur((float)4.0f, (float)24.0f));
        rootComponent.child(Components.box((Sizing)Sizing.fill(), (Sizing)Sizing.fill()).color(new Color(0.1f, 0.1f, 0.15f, 0.6f)).fill(true).zIndex(-1).positioning(Positioning.absolute((int)0, (int)0)));
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
        rootComponent.verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.fill((int)99));
        rootComponent.child((Component)mainContainer);
        FlowLayout searchPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content((int)2));
        searchPanel.margins(Insets.of((int)16, (int)-2, (int)0, (int)0));
        TextureComponent oracleIcon = Components.texture((class_2960)class_2960.method_60655((String)"oracle_index", (String)"textures/oracle-index-icon.png"), (int)0, (int)0, (int)256, (int)256, (int)256, (int)256);
        oracleIcon.sizing(Sizing.fixed((int)50));
        oracleIcon.zIndex(2);
        searchPanel.child((Component)oracleIcon);
        this.searchBar = Components.textBox((Sizing)Sizing.fixed((int)296), (String)"");
        this.searchBar.onChanged().subscribe(this::onSearchTyped);
        this.searchBar.tooltip((class_2561)class_2561.method_43471((String)"oracle_index.searchbar.tooltip"));
        this.searchBar.method_1887(class_2561.method_43471((String)"oracle_index.searchbar.placeholder").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}).getString());
        this.searchBar.method_1888(false);
        FlowLayout searchTextContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        searchTextContainer.surface(MarkdownParser.ORACLE_PANEL);
        searchTextContainer.padding(Insets.of((int)3, (int)5, (int)22, (int)3));
        searchTextContainer.margins(Insets.of((int)4, (int)0, (int)-25, (int)0));
        searchTextContainer.child((Component)this.searchBar);
        searchPanel.child((Component)searchTextContainer);
        mainContainer.child((Component)searchPanel);
        this.resultsPanel = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content((int)3));
        ScrollContainer outerContainer = Containers.verticalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.fill((int)80), (Component)this.resultsPanel);
        mainContainer.child((Component)outerContainer);
    }

    protected void method_25426() {
        super.method_25426();
        ((FlowLayout)this.uiAdapter.rootComponent).focusHandler().focus((Component)this.searchBar, Component.FocusSource.MOUSE_CLICK);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        boolean searchReady = false;
        try {
            searchReady = OracleClient.getOrCreateSearch().isReady();
        }
        catch (Throwable error) {
            error.printStackTrace();
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Sorry, Oracle Index Search is not available on your platform."));
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"If you want this search feature, you can use the xplat jar available on the mods github."));
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"https://github.com/Rearth/Oracle-Index - The jars are available in the 'releases' section."));
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"This is not the default file due to jar size limitations."));
            this.method_25419();
            return;
        }
        if (searchReady) {
            this.searchBar.method_1888(true);
            if (this.searchBar.method_1882().startsWith("Indexing")) {
                this.searchBar.method_1852("");
                Oracle.LOGGER.info("Embeddings took {}ms across all threads.", (Object)(OracleClient.getOrCreateSearch().getEmbeddingTime() / 1000000L));
            }
        } else {
            ++this.waitFrames;
            int dots = this.waitFrames / 2 % 3 + 1;
            this.searchBar.method_1888(false);
            this.searchBar.method_1852("Indexing" + ".".repeat(dots));
            this.searchBar.method_1887("");
        }
    }

    private void onSearchTyped(String query) {
        if (query.startsWith("Indexing")) {
            return;
        }
        String usedPlaceholder = class_2561.method_43471((String)"oracle_index.searchbar.placeholder").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}).getString();
        if (!query.isEmpty()) {
            usedPlaceholder = "";
        }
        this.searchBar.method_1887(usedPlaceholder);
        if (query.length() <= 2) {
            return;
        }
        Optional<SemanticSearch.SearchResult> expressionResult = this.tryProcessExpression(query);
        if (expressionResult.isEmpty() && query.matches(MATH_EXPR_REGEX)) {
            return;
        }
        this.resultsPanel.clearChildren();
        List<SemanticSearch.SearchResult> results = expressionResult.isPresent() ? List.of(expressionResult.get()) : OracleClient.getOrCreateSearch().search(query);
        for (SemanticSearch.SearchResult result : results) {
            class_2960 contentId = class_2960.method_60655((String)"oracle_index", (String)String.format("books/%s/%s", result.id().method_12836(), result.id().method_12832()));
            if (OracleClient.UNLOCK_CRITERIONS.containsKey(contentId.method_12832())) {
                class_3545<String, String> criterionData = OracleClient.UNLOCK_CRITERIONS.get(contentId.method_12832());
                if (!OracleProgressAPI.IsUnlocked(result.id().method_12836(), result.id().method_12832(), (String)criterionData.method_15442(), (String)criterionData.method_15441())) continue;
            }
            FlowLayout resultTitlePanel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_DARK);
            resultTitlePanel.margins(Insets.of((int)2, (int)2, (int)1, (int)5));
            resultTitlePanel.padding(Insets.of((int)6, (int)7, (int)6, (int)8));
            resultTitlePanel.zIndex(2);
            if (result.iconName() != null && class_7923.field_41178.method_10250(class_2960.method_60654((String)result.iconName()))) {
                class_1799 itemDisplay = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)result.iconName())));
                ItemComponent itemComponent = Components.item((class_1799)itemDisplay);
                itemComponent.sizing(Sizing.fixed((int)14));
                itemComponent.margins(Insets.of((int)-3, (int)-2, (int)-2, (int)4));
                resultTitlePanel.allowOverflow(true);
                resultTitlePanel.child((Component)itemComponent);
            }
            class_5250 titleText = class_2561.method_43470((String)result.title());
            LabelComponent title = Components.label((class_2561)titleText.method_27692(class_124.field_1067));
            resultTitlePanel.child((Component)title);
            FlowLayout resultTextPanel = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
            resultTextPanel.surface(MarkdownParser.ORACLE_PANEL);
            resultTextPanel.margins(Insets.of((int)-5, (int)2, (int)10, (int)5));
            resultTextPanel.padding(Insets.of((int)7, (int)8, (int)4, (int)4));
            for (String text : result.texts()) {
                List<Component> paragraphs = MarkdownParser.parseMarkdownToOwoComponents(text, result.id().method_12836(), string -> false);
                Component component = paragraphs.getFirst();
                if (component instanceof BaseParentComponent) {
                    BaseParentComponent parentComponent = (BaseParentComponent)component;
                    paragraphs.addAll(parentComponent.children());
                }
                boolean hadContent = false;
                for (Component paragraph : paragraphs) {
                    if (!(paragraph instanceof ScalableLabelComponent)) continue;
                    ScalableLabelComponent labelComponent = (ScalableLabelComponent)paragraph;
                    if (labelComponent.scale != 1.0f) continue;
                    paragraph.horizontalSizing(Sizing.fill());
                    paragraph.margins(Insets.of((int)0));
                    labelComponent.lineSpacing(0);
                    resultTextPanel.child(paragraph);
                    labelComponent.text((class_2561)labelComponent.text().method_27661().method_27692(class_124.field_1063));
                    hadContent = true;
                }
                if (!hadContent) continue;
                break;
            }
            this.resultsPanel.child((Component)resultTitlePanel);
            if (!resultTextPanel.children().isEmpty()) {
                this.resultsPanel.child((Component)resultTextPanel);
            }
            resultTextPanel.mouseEnter().subscribe(() -> resultTextPanel.surface(MarkdownParser.ORACLE_PANEL_HOVER));
            resultTextPanel.mouseLeave().subscribe(() -> resultTextPanel.surface(MarkdownParser.ORACLE_PANEL));
            resultTitlePanel.mouseEnter().subscribe(() -> resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_PRESSED));
            resultTitlePanel.mouseLeave().subscribe(() -> resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_DARK));
            resultTitlePanel.mouseDown().subscribe((mouseX, mouseY, button) -> {
                OracleClient.openScreen(result.id().method_12836(), contentId, (class_437)this);
                return true;
            });
            resultTextPanel.mouseDown().subscribe((mouseX, mouseY, button) -> {
                OracleClient.openScreen(result.id().method_12836(), contentId, (class_437)this);
                return true;
            });
        }
    }

    private Optional<SemanticSearch.SearchResult> tryProcessExpression(String input) {
        try {
            Expression expression = new ExpressionBuilder(input).build();
            ValidationResult valid = expression.validate();
            if (valid.isValid()) {
                double resultingNumber = expression.evaluate();
                String calculationText = String.format("%s = **%s**", input.replace("*", "x"), new DecimalFormat("#.####").format(resultingNumber));
                SemanticSearch.SearchResult res = new SemanticSearch.SearchResult(List.of(calculationText), 1.0, "Calculation: ", class_2960.method_60655((String)"oracle_index", (String)"expression"), "minecraft:comparator");
                return Optional.of(res);
            }
            return Optional.empty();
        }
        catch (RuntimeException ex) {
            return Optional.empty();
        }
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }
}

