/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle;

import ai.djl.engine.Engine;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2q.AllMiniLmL6V2QuantizedEmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import rearth.oracle.Oracle;
import rearth.oracle.util.MarkdownParser;

public class SemanticSearch {
    private InMemoryEmbeddingStore<TextSegment> embeddingStore;
    private AllMiniLmL6V2QuantizedEmbeddingModel embeddingModel;
    private EmbeddingStoreIngestor ingestor;
    private final AtomicLong TOTAL_EMBEDDING_TIME = new AtomicLong(0L);
    private final AtomicInteger PENDING_JOBS = new AtomicInteger(0);
    public static AtomicBoolean EMBEDDING_ERRORED = new AtomicBoolean(false);

    public SemanticSearch() {
        new Thread(() -> {
            try {
                this.embeddingStore = new InMemoryEmbeddingStore();
                ClassLoader original = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(Engine.class.getClassLoader());
                    this.embeddingModel = new AllMiniLmL6V2QuantizedEmbeddingModel();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(original);
                }
                this.ingestor = EmbeddingStoreIngestor.builder().embeddingStore(this.embeddingStore).embeddingModel((EmbeddingModel)this.embeddingModel).documentSplitter(DocumentSplitters.recursive((int)500, (int)50)).build();
                ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
                Map resources = resourceManager.listResources("books", path -> path.getPath().endsWith(".mdx"));
                for (ResourceLocation resourceId : resources.keySet()) {
                    String entryFileName;
                    String[] segments;
                    String modId;
                    String purePath = resourceId.getPath().replaceFirst("books/", "");
                    String entryPath = purePath.replaceFirst((modId = (segments = purePath.split("/"))[0]) + "/", "");
                    String entryDirectory = entryPath.replace(entryFileName = segments[segments.length - 1], "");
                    if (entryDirectory.startsWith(".translated")) continue;
                    try {
                        String fileContent = new String(((Resource)resources.get(resourceId)).open().readAllBytes(), StandardCharsets.UTF_8);
                        Map<String, String> fileComponents = MarkdownParser.parseFrontmatter(fileContent);
                        this.queueEmbeddingsJob(modId, entryDirectory, entryFileName, fileComponents, fileContent);
                    }
                    catch (IOException e) {
                        Oracle.LOGGER.error("Unable to load book with id: " + String.valueOf(resourceId));
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            catch (Throwable e) {
                Oracle.LOGGER.error("Unable to generate embeddings: " + e.getMessage());
                EMBEDDING_ERRORED.set(true);
            }
        }).start();
    }

    public boolean isReady() throws InvalidObjectException {
        if (EMBEDDING_ERRORED.get()) {
            throw new InvalidObjectException("Embeddings failed to load");
        }
        return this.PENDING_JOBS.get() <= 0 && this.TOTAL_EMBEDDING_TIME.get() > 10L;
    }

    public long getEmbeddingTime() {
        return this.TOTAL_EMBEDDING_TIME.get();
    }

    public ArrayList<SearchResult> search(String query) {
        Embedding queryEmbedding = (Embedding)this.embeddingModel.embed(query).content();
        EmbeddingSearchRequest searchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).maxResults(Integer.valueOf(15)).minScore(Double.valueOf(0.6)).build();
        List matches = this.embeddingStore.search(searchRequest).matches();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (EmbeddingMatch match : matches) {
            Optional<SearchResult> existingCandidate;
            String id = ((TextSegment)match.embedded()).metadata().getString("book") + ":" + ((TextSegment)match.embedded()).metadata().getString("category") + ((TextSegment)match.embedded()).metadata().getString("fileName");
            String title = ((TextSegment)match.embedded()).metadata().getString("title");
            if (title == null) {
                title = "No title";
            }
            if ((existingCandidate = results.stream().filter(result -> result.id.equals((Object)ResourceLocation.parse((String)id))).findFirst()).isPresent()) {
                existingCandidate.get().texts.add(((TextSegment)match.embedded()).text());
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(((TextSegment)match.embedded()).text());
            SearchResult step = new SearchResult(list, match.score(), title, ResourceLocation.parse((String)id), ((TextSegment)match.embedded()).metadata().getString("icon"));
            results.add(step);
        }
        return results;
    }

    public void queueEmbeddingsJob(String bookId, String filePath, String fileName, Map<String, String> frontmatter, String content) {
        CompletableFuture.runAsync(() -> {
            this.PENDING_JOBS.addAndGet(1);
            long startedAt = System.nanoTime();
            Document document = Document.from((String)content, (Metadata)Metadata.from((Map)frontmatter));
            document.metadata().put("fileName", fileName);
            document.metadata().put("category", filePath);
            document.metadata().put("book", bookId);
            this.ingestor.ingest(document);
            long takenTime = System.nanoTime() - startedAt;
            this.TOTAL_EMBEDDING_TIME.addAndGet(takenTime);
            this.PENDING_JOBS.decrementAndGet();
        });
    }

    public record SearchResult(List<String> texts, double bestScore, String title, ResourceLocation id, String iconName) {
    }
}

