/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ScalableLabelComponent
extends LabelComponent {
    public float scale = 1.0f;

    public ScalableLabelComponent(Component text, Predicate<String> linkHandler) {
        super(text);
        this.textClickHandler(style -> {
            if (style == null) {
                return false;
            }
            ClickEvent event = style.getClickEvent();
            if (event != null && event.getAction() == ClickEvent.Action.OPEN_URL) {
                return linkHandler.test(event.getValue());
            }
            return false;
        });
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return (int)((double)((float)super.determineVerticalContentSize(sizing) * this.scale) + 0.5);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return (int)((double)((float)super.determineHorizontalContentSize(sizing) * this.scale) + 0.5);
    }

    protected Style styleAt(int mouseX, int mouseY) {
        return super.styleAt(mouseX, mouseY);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate(0.0, 1.0 / Minecraft.getInstance().getWindow().getGuiScale(), 0.0);
        int x = this.x;
        int y = this.y;
        if (((Sizing)this.horizontalSizing.get()).isContent()) {
            x += ((Sizing)this.horizontalSizing.get()).value;
        }
        if (((Sizing)this.verticalSizing.get()).isContent()) {
            y += ((Sizing)this.verticalSizing.get()).value;
        }
        switch (this.verticalTextAlignment) {
            case CENTER: {
                y += (this.height - this.textHeight()) / 2;
                break;
            }
            case BOTTOM: {
                y += this.height - this.textHeight();
            }
        }
        int finalX = x;
        int finalY = y;
        context.drawManaged(() -> {
            for (int i = 0; i < this.wrappedText.size(); ++i) {
                FormattedCharSequence renderText = (FormattedCharSequence)this.wrappedText.get(i);
                int renderX = finalX;
                switch (this.horizontalTextAlignment) {
                    case CENTER: {
                        renderX = finalX + (this.width - this.textRenderer.width(renderText)) / 2;
                        break;
                    }
                    case RIGHT: {
                        renderX = finalX + (this.width - this.textRenderer.width(renderText));
                    }
                }
                int renderY = finalY + i * (this.lineHeight() + this.lineSpacing());
                int var10001 = this.lineHeight();
                Objects.requireNonNull(this.textRenderer);
                matrices.pushPose();
                float translateX = (float)finalX * (1.0f - this.scale);
                float translateY = (float)finalY * (1.0f - this.scale);
                matrices.translate(translateX, translateY, 0.0f);
                matrices.scale(this.scale, this.scale, this.scale);
                context.drawString(this.textRenderer, renderText, renderX, renderY += var10001 - 9, ((Color)this.color.get()).argb(), this.shadow);
                matrices.popPose();
            }
        });
        matrices.popPose();
    }
}

