/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.potionBrewingDisabler.listeners;

import de.scholle.potionBrewingDisabler.PotionBrewingDisabler;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionBrewListener
implements Listener {
    @EventHandler
    public void onBrew(BrewEvent event) {
        List<String> disabledPotions = PotionBrewingDisabler.getInstance().getDisabledPotions();
        for (ItemStack result : event.getResults()) {
            Object object;
            if (result == null || result.getType() != Material.POTION || !((object = result.getItemMeta()) instanceof PotionMeta)) continue;
            PotionMeta meta = (PotionMeta)object;
            try {
                PotionData potionData = meta.getBasePotionData();
                PotionType baseType = potionData.getType();
                if (disabledPotions.contains(baseType.name())) {
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = meta.getCustomEffects().iterator();
            while (object.hasNext()) {
                PotionEffect effect = (PotionEffect)object.next();
                PotionEffectType type = effect.getType();
                if (!disabledPotions.contains(type.getName())) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

