/*
 * Decompiled with CFR 0.152.
 */
package coppertoolsarmorbackport.item;

import coppertoolsarmorbackport.init.CopperToolsArmorBackportModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class CopperItem
extends ArmorItem {
    public CopperItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 121;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{1, 3, 4, 2})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 8;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("block.copper.place"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COPPER_INGOT), new ItemStack((ItemLike)CopperToolsArmorBackportModItems.COPPER_HELMET.get()), new ItemStack((ItemLike)CopperToolsArmorBackportModItems.COPPER_CHESTPLATE.get()), new ItemStack((ItemLike)CopperToolsArmorBackportModItems.COPPER_LEGGINGS.get()), new ItemStack((ItemLike)CopperToolsArmorBackportModItems.COPPER_BOOTS.get())});
            }

            public String getName() {
                return "copper";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends CopperItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "copper_tools_armor_backport:textures/entities/copper_layer_1.png";
        }
    }

    public static class Leggings
    extends CopperItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "copper_tools_armor_backport:textures/entities/copper_layer_2.png";
        }
    }

    public static class Chestplate
    extends CopperItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "copper_tools_armor_backport:textures/entities/copper_layer_1.png";
        }
    }

    public static class Helmet
    extends CopperItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "copper_tools_armor_backport:textures/entities/copper_layer_1.png";
        }
    }
}

