/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.datagen.fabric;

import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPBlockLootTableGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPBlockTagGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPFusionMetadataGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPFusionModelGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPItemTagGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPLanguageUKGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPLanguageUSGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPModelGenerator;
import com.github.sokyranthedragon.svtp.datagen.fabric.SVTPRecipeGenerator;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class SVTPDatagen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        FabricDataGenerator.Pack pack = generator.createPack();
        pack.addProvider(SVTPLanguageUSGenerator::new);
        pack.addProvider(SVTPLanguageUKGenerator::new);
        pack.addProvider(SVTPModelGenerator::new);
        pack.addProvider(SVTPRecipeGenerator.SVTPRecipeRunner::new);
        SVTPBlockTagGenerator blockTags = (SVTPBlockTagGenerator)pack.addProvider(SVTPBlockTagGenerator::new);
        pack.addProvider((output, future) -> new SVTPItemTagGenerator(output, future, blockTags));
        pack.addProvider(SVTPBlockLootTableGenerator::new);
        Path fusionPath = SVTPDatagen.getFabricDataOutput(pack).resolve("fusion");
        FabricDataOutput fusionOutput = new FabricDataOutput(generator.getModContainer(), fusionPath, generator.isStrictValidationEnabled());
        pack.addProvider((output, future) -> new SVTPFusionModelGenerator(fusionOutput));
        pack.addProvider((output, future) -> new SVTPFusionMetadataGenerator(fusionOutput));
    }

    @NotNull
    private static Path getFabricDataOutput(FabricDataGenerator.Pack pack) {
        try {
            Field field = class_2403.class_7856.class.getDeclaredField("output");
            field.setAccessible(true);
            return ((class_7784)field.get(pack)).method_45971();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

