/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.datagen.fabric;

import com.github.sokyranthedragon.svtp.SVTPMod;
import com.github.sokyranthedragon.svtp.blocks.SVTPBlocks;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4945;

public class SVTPFusionModelGenerator
extends FusionModelProvider {
    public SVTPFusionModelGenerator(FabricDataOutput output) {
        super("sokys_various_things_pack", output);
    }

    protected void generate() {
        this.generateGlassBlockModel(SVTPBlocks.ARMORED_GLASS);
        this.generateGlassPaneModel(SVTPBlocks.ARMORED_GLASS_PANE, SVTPBlocks.ARMORED_GLASS);
        this.generateGlassBlockModel(SVTPBlocks.ARMORED_TINTED_GLASS);
        RegistrySupplier<class_2248>[] glassBlocks = SVTPBlocks.getStainedGlassBlockProviders();
        RegistrySupplier<class_2248>[] glassPanes = SVTPBlocks.getStainedGlassPaneBlockProviders();
        for (int i = 0; i < glassBlocks.length; ++i) {
            this.generateGlassBlockModel(glassBlocks[i]);
            this.generateGlassPaneModel(glassPanes[i], glassBlocks[i]);
        }
    }

    private void generateGlassBlockModel(RegistrySupplier<class_2248> block) {
        ModelInstance modelInstance = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)this.getBlockModelDataBuilder(block).build()));
        this.addModel(SVTPMod.resourceLocation("block/" + block.getId().method_12832()), modelInstance);
    }

    private void generateGlassPaneModel(RegistrySupplier<class_2248> paneSupplier, RegistrySupplier<class_2248> blockSupplier) {
    }

    private void generateGlassPaneModel(RegistrySupplier<class_2248> pane, RegistrySupplier<class_2248> block, String side, boolean edge) {
        ConnectingModelDataBuilder modelData = edge ? this.getPaneModelDataBuilderWithEdge(side, block) : this.getPaneModelDataBuilder(side, block);
        ModelInstance modelInstance = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)modelData.build()));
        this.addModel(SVTPMod.resourceLocation("block/" + pane.getId().method_12832() + side), modelInstance);
    }

    private ConnectingModelDataBuilder getBaseModelDataBuilder(String parent, RegistrySupplier<class_2248> blockSupplier) {
        return (ConnectingModelDataBuilder)ConnectingModelData.builder().parent(class_2960.method_60656((String)("block/" + parent)));
    }

    private ConnectingModelDataBuilder getBlockModelDataBuilder(RegistrySupplier<class_2248> block) {
        return (ConnectingModelDataBuilder)this.getBaseModelDataBuilder("cube_all", block).connection(DefaultConnectionPredicates.isSameBlock()).texture(class_4945.field_23010.method_25912(), SVTPMod.resourceLocation("block/" + block.getId().method_12832()));
    }

    private ConnectingModelDataBuilder getPaneModelDataBuilder(String parent, RegistrySupplier<class_2248> block) {
        return (ConnectingModelDataBuilder)this.getBaseModelDataBuilder("template_glass_pane" + parent, block).connection(DefaultConnectionPredicates.and((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isSameBlock(), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.LEFT, ConnectionDirection.RIGHT})})).texture(class_4945.field_23031.method_25912(), SVTPMod.resourceLocation("block/" + block.getId().method_12832()));
    }

    private ConnectingModelDataBuilder getPaneModelDataBuilderWithEdge(String parent, RegistrySupplier<class_2248> block) {
        return (ConnectingModelDataBuilder)this.getPaneModelDataBuilder(parent, block).texture(class_4945.field_23032.method_25912(), SVTPMod.resourceLocation("block/armored_glass_pane_top"));
    }
}

