/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.blocks;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
public class GoldenTorchBlock
extends TorchBlock {
    public static final VoxelShape AABB_GOLDEN_TORCH = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public GoldenTorchBlock(SimpleParticleType simpleParticleType, BlockBehaviour.Properties properties) {
        super(simpleParticleType, properties);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        double x = (double)blockPos.getX() + 0.5;
        double y = (double)blockPos.getY() + 0.7625;
        double z = (double)blockPos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AABB_GOLDEN_TORCH;
    }
}

