/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.svtp.blocks;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class RedstoneLanternBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<RedstoneLanternBlock> CODEC = RedstoneLanternBlock.simpleCodec(RedstoneLanternBlock::new);
    public static final BooleanProperty REDSTONE_STATE = BooleanProperty.create((String)"redstone_state");
    public static final BooleanProperty MANUAL_STATE = BooleanProperty.create((String)"manual_state");

    public RedstoneLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)REDSTONE_STATE, (Comparable)Boolean.valueOf(false))).setValue((Property)MANUAL_STATE, (Comparable)Boolean.valueOf(false)));
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)REDSTONE_STATE)).booleanValue() && !serverLevel.hasNeighborSignal(blockPos)) {
            serverLevel.setBlock(blockPos, (BlockState)blockState.cycle((Property)REDSTONE_STATE), 2);
        }
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos otherPos, boolean bl) {
        Boolean redstoneState;
        if (!level.isClientSide && (redstoneState = (Boolean)blockState.getValue((Property)REDSTONE_STATE)).booleanValue() != level.hasNeighborSignal(blockPos)) {
            if (redstoneState.booleanValue()) {
                level.scheduleTick(blockPos, (Block)this, 4);
            } else {
                level.setBlock(blockPos, (BlockState)blockState.cycle((Property)REDSTONE_STATE), 2);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            if (player.isShiftKeyDown()) {
                level.setBlock(pos, (BlockState)state.cycle((Property)FACING), 2);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.toggleManualState(state, level, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer) {
        if (explosion.canTriggerBlocks()) {
            this.toggleManualState(state, level, pos);
        }
        super.onExplosionHit(state, level, pos, explosion, biConsumer);
    }

    public void toggleManualState(BlockState state, Level level, BlockPos pos) {
        state = (BlockState)state.cycle((Property)MANUAL_STATE);
        level.setBlock(pos, state, 2);
        Boolean manualPower = (Boolean)state.getValue((Property)MANUAL_STATE);
        level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, manualPower != false ? 0.6f : 0.5f);
        level.gameEvent(null, (Holder)(manualPower ^ (Boolean)state.getValue((Property)REDSTONE_STATE) ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, REDSTONE_STATE, MANUAL_STATE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite())).setValue((Property)REDSTONE_STATE, (Comparable)Boolean.valueOf(blockPlaceContext.getLevel().hasNeighborSignal(blockPlaceContext.getClickedPos())))).setValue((Property)MANUAL_STATE, (Comparable)Boolean.valueOf(false));
    }
}

